"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reportexecutioncontext import (
    ReportExecutionContext,
    ReportExecutionContextTypedDict,
)
from .reportexecutionstatus import ReportExecutionStatus
from .reportsummary import ReportSummary, ReportSummaryTypedDict
from datetime import datetime
from gr4vy.types import BaseModel
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, TypedDict


class ReportExecutionTypedDict(TypedDict):
    id: str
    r"""The unique ID for the report execution."""
    created_at: datetime
    r"""The date this report execution was created at."""
    updated_at: datetime
    r"""The date this report execution was last updated."""
    status: ReportExecutionStatus
    context: ReportExecutionContextTypedDict
    report: ReportSummaryTypedDict
    type: Literal["report-execution"]
    r"""Always `report-execution`."""


class ReportExecution(BaseModel):
    id: str
    r"""The unique ID for the report execution."""

    created_at: datetime
    r"""The date this report execution was created at."""

    updated_at: datetime
    r"""The date this report execution was last updated."""

    status: Annotated[ReportExecutionStatus, PlainValidator(validate_open_enum(False))]

    context: ReportExecutionContext

    report: ReportSummary

    TYPE: Annotated[
        Annotated[
            Optional[Literal["report-execution"]],
            AfterValidator(validate_const("report-execution")),
        ],
        pydantic.Field(alias="type"),
    ] = "report-execution"
    r"""Always `report-execution`."""
