"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, Dict, List
from typing_extensions import NotRequired, TypedDict


class RequiredCheckoutFieldsTypedDict(TypedDict):
    r"""A collection of checkout fields and the conditions under which they are required."""

    required_fields: List[str]
    r"""A list of transaction fields that are required to process a payment for this service."""
    conditions: NotRequired[Nullable[Dict[str, Any]]]
    r"""The conditions under which these fields are required"""


class RequiredCheckoutFields(BaseModel):
    r"""A collection of checkout fields and the conditions under which they are required."""

    required_fields: List[str]
    r"""A list of transaction fields that are required to process a payment for this service."""

    conditions: OptionalNullable[Dict[str, Any]] = UNSET
    r"""The conditions under which these fields are required"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["conditions"]
        nullable_fields = ["conditions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
