# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, conlist, constr, validator

from typing import Optional

from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.set_transaction_configuration_source_request import SetTransactionConfigurationSourceRequest
from lusid.models.side_configuration_data_request import SideConfigurationDataRequest
from lusid.models.transaction_configuration_data_request import TransactionConfigurationDataRequest
from lusid.models.transaction_set_configuration_data import TransactionSetConfigurationData
from lusid.models.transaction_set_configuration_data_request import TransactionSetConfigurationDataRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class SystemConfigurationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_configuration_transaction_type(self, transaction_configuration_data_request : Annotated[Optional[TransactionConfigurationDataRequest], Field(description="A transaction type definition.")] = None, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @overload
    def create_configuration_transaction_type(self, transaction_configuration_data_request : Annotated[Optional[TransactionConfigurationDataRequest], Field(description="A transaction type definition.")] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @validate_arguments
    def create_configuration_transaction_type(self, transaction_configuration_data_request : Annotated[Optional[TransactionConfigurationDataRequest], Field(description="A transaction type definition.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionSetConfigurationData, Awaitable[TransactionSetConfigurationData]]:  # noqa: E501
        """[EARLY ACCESS] CreateConfigurationTransactionType: Create transaction type  # noqa: E501

        Create a new transaction type by specifying a definition and mappings to movements.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_configuration_transaction_type(transaction_configuration_data_request, async_req=True)
        >>> result = thread.get()

        :param transaction_configuration_data_request: A transaction type definition.
        :type transaction_configuration_data_request: TransactionConfigurationDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionSetConfigurationData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_configuration_transaction_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_configuration_transaction_type_with_http_info(transaction_configuration_data_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_configuration_transaction_type_with_http_info(self, transaction_configuration_data_request : Annotated[Optional[TransactionConfigurationDataRequest], Field(description="A transaction type definition.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CreateConfigurationTransactionType: Create transaction type  # noqa: E501

        Create a new transaction type by specifying a definition and mappings to movements.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_configuration_transaction_type_with_http_info(transaction_configuration_data_request, async_req=True)
        >>> result = thread.get()

        :param transaction_configuration_data_request: A transaction type definition.
        :type transaction_configuration_data_request: TransactionConfigurationDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionSetConfigurationData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'transaction_configuration_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_configuration_transaction_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_configuration_data_request'] is not None:
            _body_params = _params['transaction_configuration_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "TransactionSetConfigurationData",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/systemconfiguration/transactions/type', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_side_definition(self, side_configuration_data_request : Annotated[Optional[SideConfigurationDataRequest], Field(description="The definition of the side.")] = None, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @overload
    def create_side_definition(self, side_configuration_data_request : Annotated[Optional[SideConfigurationDataRequest], Field(description="The definition of the side.")] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @validate_arguments
    def create_side_definition(self, side_configuration_data_request : Annotated[Optional[SideConfigurationDataRequest], Field(description="The definition of the side.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionSetConfigurationData, Awaitable[TransactionSetConfigurationData]]:  # noqa: E501
        """[EXPERIMENTAL] CreateSideDefinition: Create side definition  # noqa: E501

        Create a new side definition for use in a transaction type. For more information, see https://support.lusid.com/knowledgebase/article/KA-01875.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_side_definition(side_configuration_data_request, async_req=True)
        >>> result = thread.get()

        :param side_configuration_data_request: The definition of the side.
        :type side_configuration_data_request: SideConfigurationDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionSetConfigurationData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_side_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_side_definition_with_http_info(side_configuration_data_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_side_definition_with_http_info(self, side_configuration_data_request : Annotated[Optional[SideConfigurationDataRequest], Field(description="The definition of the side.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateSideDefinition: Create side definition  # noqa: E501

        Create a new side definition for use in a transaction type. For more information, see https://support.lusid.com/knowledgebase/article/KA-01875.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_side_definition_with_http_info(side_configuration_data_request, async_req=True)
        >>> result = thread.get()

        :param side_configuration_data_request: The definition of the side.
        :type side_configuration_data_request: SideConfigurationDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionSetConfigurationData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'side_configuration_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_side_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['side_configuration_data_request'] is not None:
            _body_params = _params['side_configuration_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "TransactionSetConfigurationData",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/systemconfiguration/transactions/side', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source to delete transaction configurations for")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source to delete transaction configurations for")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source to delete transaction configurations for")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteTransactionConfigurationSource: Delete all transaction configurations for a source  # noqa: E501

        /// WARNING! Changing existing transaction types has a material impact on how data, new and old,  is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_configuration_source(source, async_req=True)
        >>> result = thread.get()

        :param source: The source to delete transaction configurations for (required)
        :type source: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_transaction_configuration_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_transaction_configuration_source_with_http_info(source, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_transaction_configuration_source_with_http_info(self, source : Annotated[StrictStr, Field(..., description="The source to delete transaction configurations for")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteTransactionConfigurationSource: Delete all transaction configurations for a source  # noqa: E501

        /// WARNING! Changing existing transaction types has a material impact on how data, new and old,  is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_configuration_source_with_http_info(source, async_req=True)
        >>> result = thread.get()

        :param source: The source to delete transaction configurations for (required)
        :type source: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transaction_configuration_source" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['source']:
            _path_params['source'] = _params['source']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/systemconfiguration/transactions/type/{source}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source for which to retrieve transaction configurations")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction configurations.              Defaults to returning the latest version of the transaction configurations if not specified.")] = None, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @overload
    def get_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source for which to retrieve transaction configurations")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction configurations.              Defaults to returning the latest version of the transaction configurations if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @validate_arguments
    def get_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source for which to retrieve transaction configurations")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction configurations.              Defaults to returning the latest version of the transaction configurations if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionSetConfigurationData, Awaitable[TransactionSetConfigurationData]]:  # noqa: E501
        """[EXPERIMENTAL] GetTransactionConfigurationSource: Get all transaction configurations for a source  # noqa: E501

        Returns failure if requested source is not found  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_configuration_source(source, as_at, async_req=True)
        >>> result = thread.get()

        :param source: The source for which to retrieve transaction configurations (required)
        :type source: str
        :param as_at: The asAt datetime at which to retrieve the transaction configurations.              Defaults to returning the latest version of the transaction configurations if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionSetConfigurationData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_transaction_configuration_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_transaction_configuration_source_with_http_info(source, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_transaction_configuration_source_with_http_info(self, source : Annotated[StrictStr, Field(..., description="The source for which to retrieve transaction configurations")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction configurations.              Defaults to returning the latest version of the transaction configurations if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetTransactionConfigurationSource: Get all transaction configurations for a source  # noqa: E501

        Returns failure if requested source is not found  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_configuration_source_with_http_info(source, as_at, async_req=True)
        >>> result = thread.get()

        :param source: The source for which to retrieve transaction configurations (required)
        :type source: str
        :param as_at: The asAt datetime at which to retrieve the transaction configurations.              Defaults to returning the latest version of the transaction configurations if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionSetConfigurationData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_configuration_source" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['source']:
            _path_params['source'] = _params['source']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionSetConfigurationData",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/systemconfiguration/transactions/type/{source}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_configuration_transaction_types(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.")] = None, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @overload
    def list_configuration_transaction_types(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @validate_arguments
    def list_configuration_transaction_types(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionSetConfigurationData, Awaitable[TransactionSetConfigurationData]]:  # noqa: E501
        """[EARLY ACCESS] ListConfigurationTransactionTypes: List transaction types  # noqa: E501

        Get the list of current transaction types. For information on the default transaction types provided with  LUSID, see https://support.lusid.com/knowledgebase/article/KA-01873/.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_configuration_transaction_types(as_at, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionSetConfigurationData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_configuration_transaction_types_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_configuration_transaction_types_with_http_info(as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def list_configuration_transaction_types_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListConfigurationTransactionTypes: List transaction types  # noqa: E501

        Get the list of current transaction types. For information on the default transaction types provided with  LUSID, see https://support.lusid.com/knowledgebase/article/KA-01873/.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_configuration_transaction_types_with_http_info(as_at, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionSetConfigurationData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_configuration_transaction_types" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionSetConfigurationData",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/systemconfiguration/transactions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_configuration_transaction_types(self, transaction_set_configuration_data_request : Annotated[Optional[TransactionSetConfigurationDataRequest], Field(description="The complete set of transaction type definitions.")] = None, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @overload
    def set_configuration_transaction_types(self, transaction_set_configuration_data_request : Annotated[Optional[TransactionSetConfigurationDataRequest], Field(description="The complete set of transaction type definitions.")] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @validate_arguments
    def set_configuration_transaction_types(self, transaction_set_configuration_data_request : Annotated[Optional[TransactionSetConfigurationDataRequest], Field(description="The complete set of transaction type definitions.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionSetConfigurationData, Awaitable[TransactionSetConfigurationData]]:  # noqa: E501
        """[EXPERIMENTAL] SetConfigurationTransactionTypes: Set transaction types  # noqa: E501

        Configure all existing transaction types. Note it is not possible to configure a single existing transaction type on its own.                WARNING! Changing existing transaction types has a material impact on how data, new and old, is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_configuration_transaction_types(transaction_set_configuration_data_request, async_req=True)
        >>> result = thread.get()

        :param transaction_set_configuration_data_request: The complete set of transaction type definitions.
        :type transaction_set_configuration_data_request: TransactionSetConfigurationDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionSetConfigurationData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_configuration_transaction_types_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_configuration_transaction_types_with_http_info(transaction_set_configuration_data_request, **kwargs)  # noqa: E501

    @validate_arguments
    def set_configuration_transaction_types_with_http_info(self, transaction_set_configuration_data_request : Annotated[Optional[TransactionSetConfigurationDataRequest], Field(description="The complete set of transaction type definitions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetConfigurationTransactionTypes: Set transaction types  # noqa: E501

        Configure all existing transaction types. Note it is not possible to configure a single existing transaction type on its own.                WARNING! Changing existing transaction types has a material impact on how data, new and old, is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_configuration_transaction_types_with_http_info(transaction_set_configuration_data_request, async_req=True)
        >>> result = thread.get()

        :param transaction_set_configuration_data_request: The complete set of transaction type definitions.
        :type transaction_set_configuration_data_request: TransactionSetConfigurationDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionSetConfigurationData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'transaction_set_configuration_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_configuration_transaction_types" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_set_configuration_data_request'] is not None:
            _body_params = _params['transaction_set_configuration_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionSetConfigurationData",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/systemconfiguration/transactions', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction configurations for")], set_transaction_configuration_source_request : Annotated[conlist(SetTransactionConfigurationSourceRequest), Field(..., description="The set of transaction configurations")], **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @overload
    def set_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction configurations for")], set_transaction_configuration_source_request : Annotated[conlist(SetTransactionConfigurationSourceRequest), Field(..., description="The set of transaction configurations")], async_req: Optional[bool]=True, **kwargs) -> TransactionSetConfigurationData:  # noqa: E501
        ...

    @validate_arguments
    def set_transaction_configuration_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction configurations for")], set_transaction_configuration_source_request : Annotated[conlist(SetTransactionConfigurationSourceRequest), Field(..., description="The set of transaction configurations")], async_req: Optional[bool]=None, **kwargs) -> Union[TransactionSetConfigurationData, Awaitable[TransactionSetConfigurationData]]:  # noqa: E501
        """[EXPERIMENTAL] SetTransactionConfigurationSource: Set transaction types for a source  # noqa: E501

        This will replace all the existing transaction configurations for the given source                WARNING! Changing existing transaction types has a material impact on how data, new and old, is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_transaction_configuration_source(source, set_transaction_configuration_source_request, async_req=True)
        >>> result = thread.get()

        :param source: The source to set the transaction configurations for (required)
        :type source: str
        :param set_transaction_configuration_source_request: The set of transaction configurations (required)
        :type set_transaction_configuration_source_request: List[SetTransactionConfigurationSourceRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionSetConfigurationData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_transaction_configuration_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_transaction_configuration_source_with_http_info(source, set_transaction_configuration_source_request, **kwargs)  # noqa: E501

    @validate_arguments
    def set_transaction_configuration_source_with_http_info(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction configurations for")], set_transaction_configuration_source_request : Annotated[conlist(SetTransactionConfigurationSourceRequest), Field(..., description="The set of transaction configurations")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetTransactionConfigurationSource: Set transaction types for a source  # noqa: E501

        This will replace all the existing transaction configurations for the given source                WARNING! Changing existing transaction types has a material impact on how data, new and old, is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_transaction_configuration_source_with_http_info(source, set_transaction_configuration_source_request, async_req=True)
        >>> result = thread.get()

        :param source: The source to set the transaction configurations for (required)
        :type source: str
        :param set_transaction_configuration_source_request: The set of transaction configurations (required)
        :type set_transaction_configuration_source_request: List[SetTransactionConfigurationSourceRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionSetConfigurationData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source',
            'set_transaction_configuration_source_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_transaction_configuration_source" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['source']:
            _path_params['source'] = _params['source']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['set_transaction_configuration_source_request'] is not None:
            _body_params = _params['set_transaction_configuration_source_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionSetConfigurationData",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/systemconfiguration/transactions/type/{source}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
