# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist 
from lusid.models.block import Block
from lusid.models.order import Order

class BlockAndOrders(BaseModel):
    """
    BlockAndOrders
    """
    block: Block = Field(...)
    orders: conlist(Order) = Field(...)
    __properties = ["block", "orders"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BlockAndOrders:
        """Create an instance of BlockAndOrders from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of block
        if self.block:
            _dict['block'] = self.block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in orders (list)
        _items = []
        if self.orders:
            for _item in self.orders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orders'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BlockAndOrders:
        """Create an instance of BlockAndOrders from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BlockAndOrders.parse_obj(obj)

        _obj = BlockAndOrders.parse_obj({
            "block": Block.from_dict(obj.get("block")) if obj.get("block") is not None else None,
            "orders": [Order.from_dict(_item) for _item in obj.get("orders")] if obj.get("orders") is not None else None
        })
        return _obj
