# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist, constr, validator 
from lusid.models.model_property import ModelProperty
from lusid.models.resource_id import ResourceId
from lusid.models.weekend_mask import WeekendMask

class CreateCalendarRequest(BaseModel):
    """
    CreateCalendarRequest
    """
    calendar_id: ResourceId = Field(..., alias="calendarId")
    calendar_type:  StrictStr = Field(...,alias="calendarType") 
    weekend_mask: WeekendMask = Field(..., alias="weekendMask")
    source_provider:  StrictStr = Field(...,alias="sourceProvider") 
    properties: Optional[conlist(ModelProperty)] = None
    __properties = ["calendarId", "calendarType", "weekendMask", "sourceProvider", "properties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateCalendarRequest:
        """Create an instance of CreateCalendarRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of calendar_id
        if self.calendar_id:
            _dict['calendarId'] = self.calendar_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of weekend_mask
        if self.weekend_mask:
            _dict['weekendMask'] = self.weekend_mask.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item in self.properties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['properties'] = _items
        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateCalendarRequest:
        """Create an instance of CreateCalendarRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateCalendarRequest.parse_obj(obj)

        _obj = CreateCalendarRequest.parse_obj({
            "calendar_id": ResourceId.from_dict(obj.get("calendarId")) if obj.get("calendarId") is not None else None,
            "calendar_type": obj.get("calendarType"),
            "weekend_mask": WeekendMask.from_dict(obj.get("weekendMask")) if obj.get("weekendMask") is not None else None,
            "source_provider": obj.get("sourceProvider"),
            "properties": [ModelProperty.from_dict(_item) for _item in obj.get("properties")] if obj.get("properties") is not None else None
        })
        return _obj
