# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist, constr 
from lusid.models.template_field import TemplateField

class FeeTransactionTemplateSpecification(BaseModel):
    """
    FeeTransactionTemplateSpecification
    """
    specification_type_name:  StrictStr = Field(...,alias="specificationTypeName") 
    supported_template_fields: conlist(TemplateField) = Field(..., alias="supportedTemplateFields")
    __properties = ["specificationTypeName", "supportedTemplateFields"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FeeTransactionTemplateSpecification:
        """Create an instance of FeeTransactionTemplateSpecification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in supported_template_fields (list)
        _items = []
        if self.supported_template_fields:
            for _item in self.supported_template_fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['supportedTemplateFields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FeeTransactionTemplateSpecification:
        """Create an instance of FeeTransactionTemplateSpecification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FeeTransactionTemplateSpecification.parse_obj(obj)

        _obj = FeeTransactionTemplateSpecification.parse_obj({
            "specification_type_name": obj.get("specificationTypeName"),
            "supported_template_fields": [TemplateField.from_dict(_item) for _item in obj.get("supportedTemplateFields")] if obj.get("supportedTemplateFields") is not None else None
        })
        return _obj
