# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conint, conlist, constr, validator 
from lusid.models.instrument_resolution_detail import InstrumentResolutionDetail
from lusid.models.model_property import ModelProperty
from lusid.models.nav_type_definition import NavTypeDefinition
from lusid.models.portfolio_entity_id import PortfolioEntityId
from lusid.models.resource_id import ResourceId

class FundDefinitionRequest(BaseModel):
    """
    The request used to create a Fund.  # noqa: E501
    """
    code:  StrictStr = Field(...,alias="code", description="The code given for the Fund.") 
    display_name:  StrictStr = Field(...,alias="displayName", description="The name of the Fund.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A description for the Fund.") 
    base_currency:  StrictStr = Field(...,alias="baseCurrency", description="The base currency of the Fund in ISO 4217 currency code format. All portfolios must be of a matching base currency.") 
    portfolio_ids: conlist(PortfolioEntityId) = Field(..., alias="portfolioIds", description="A list of the Portfolio IDs associated with the fund, which are part of the Fund. Note: These must all have the same base currency, which must also much the Fund Base Currency.")
    fund_configuration_id: ResourceId = Field(..., alias="fundConfigurationId")
    share_class_instrument_scopes: Optional[conlist(StrictStr)] = Field(None, alias="shareClassInstrumentScopes", description="The scopes in which the instruments lie, currently limited to one.")
    share_class_instruments: Optional[conlist(InstrumentResolutionDetail)] = Field(None, alias="shareClassInstruments", description="Details the user-provided instrument identifiers and the instrument resolved from them.")
    type:  StrictStr = Field(...,alias="type", description="The type of fund; 'Standalone', 'Master' or 'Feeder'") 
    inception_date: datetime = Field(..., alias="inceptionDate", description="Inception date of the Fund")
    decimal_places: Optional[conint(strict=True)] = Field(None, alias="decimalPlaces", description="Number of decimal places for reporting")
    primary_nav_type: NavTypeDefinition = Field(..., alias="primaryNavType")
    additional_nav_types: Optional[conlist(NavTypeDefinition)] = Field(None, alias="additionalNavTypes", description="The definitions for any additional NAVs on the Fund.")
    properties: Optional[Dict[str, ModelProperty]] = Field(None, description="A set of properties for the Fund.")
    __properties = ["code", "displayName", "description", "baseCurrency", "portfolioIds", "fundConfigurationId", "shareClassInstrumentScopes", "shareClassInstruments", "type", "inceptionDate", "decimalPlaces", "primaryNavType", "additionalNavTypes", "properties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FundDefinitionRequest:
        """Create an instance of FundDefinitionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in portfolio_ids (list)
        _items = []
        if self.portfolio_ids:
            for _item in self.portfolio_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['portfolioIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of fund_configuration_id
        if self.fund_configuration_id:
            _dict['fundConfigurationId'] = self.fund_configuration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in share_class_instruments (list)
        _items = []
        if self.share_class_instruments:
            for _item in self.share_class_instruments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['shareClassInstruments'] = _items
        # override the default output from pydantic by calling `to_dict()` of primary_nav_type
        if self.primary_nav_type:
            _dict['primaryNavType'] = self.primary_nav_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in additional_nav_types (list)
        _items = []
        if self.additional_nav_types:
            for _item in self.additional_nav_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict['additionalNavTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if share_class_instrument_scopes (nullable) is None
        # and __fields_set__ contains the field
        if self.share_class_instrument_scopes is None and "share_class_instrument_scopes" in self.__fields_set__:
            _dict['shareClassInstrumentScopes'] = None

        # set to None if share_class_instruments (nullable) is None
        # and __fields_set__ contains the field
        if self.share_class_instruments is None and "share_class_instruments" in self.__fields_set__:
            _dict['shareClassInstruments'] = None

        # set to None if decimal_places (nullable) is None
        # and __fields_set__ contains the field
        if self.decimal_places is None and "decimal_places" in self.__fields_set__:
            _dict['decimalPlaces'] = None

        # set to None if additional_nav_types (nullable) is None
        # and __fields_set__ contains the field
        if self.additional_nav_types is None and "additional_nav_types" in self.__fields_set__:
            _dict['additionalNavTypes'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FundDefinitionRequest:
        """Create an instance of FundDefinitionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FundDefinitionRequest.parse_obj(obj)

        _obj = FundDefinitionRequest.parse_obj({
            "code": obj.get("code"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "base_currency": obj.get("baseCurrency"),
            "portfolio_ids": [PortfolioEntityId.from_dict(_item) for _item in obj.get("portfolioIds")] if obj.get("portfolioIds") is not None else None,
            "fund_configuration_id": ResourceId.from_dict(obj.get("fundConfigurationId")) if obj.get("fundConfigurationId") is not None else None,
            "share_class_instrument_scopes": obj.get("shareClassInstrumentScopes"),
            "share_class_instruments": [InstrumentResolutionDetail.from_dict(_item) for _item in obj.get("shareClassInstruments")] if obj.get("shareClassInstruments") is not None else None,
            "type": obj.get("type"),
            "inception_date": obj.get("inceptionDate"),
            "decimal_places": obj.get("decimalPlaces"),
            "primary_nav_type": NavTypeDefinition.from_dict(obj.get("primaryNavType")) if obj.get("primaryNavType") is not None else None,
            "additional_nav_types": [NavTypeDefinition.from_dict(_item) for _item in obj.get("additionalNavTypes")] if obj.get("additionalNavTypes") is not None else None,
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None
        })
        return _obj
