# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, Field, StrictStr, validator 
from lusid.models.fx_conventions import FxConventions
from lusid.models.relative_date_offset import RelativeDateOffset
from lusid.models.schedule import Schedule

class FxLinkedNotionalSchedule(Schedule):
    """
    Schedule for notional changes based on the change in FX rate.  Used in the representation of a resettable cross currency interest rate swap.  # noqa: E501
    """
    fx_conventions: FxConventions = Field(..., alias="fxConventions")
    varying_notional_currency:  StrictStr = Field(...,alias="varyingNotionalCurrency", description="The currency of the varying notional amount.") 
    varying_notional_fixing_dates: RelativeDateOffset = Field(..., alias="varyingNotionalFixingDates")
    varying_notional_interim_exchange_payment_dates: Optional[RelativeDateOffset] = Field(None, alias="varyingNotionalInterimExchangePaymentDates")
    schedule_type:  StrictStr = Field(...,alias="scheduleType", description="The available values are: FixedSchedule, FloatSchedule, OptionalitySchedule, StepSchedule, Exercise, FxRateSchedule, FxLinkedNotionalSchedule, BondConversionSchedule, Invalid") 
    additional_properties: Dict[str, Any] = {}
    __properties = ["scheduleType", "fxConventions", "varyingNotionalCurrency", "varyingNotionalFixingDates", "varyingNotionalInterimExchangePaymentDates"]

    @validator('schedule_type')
    def schedule_type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'FxLinkedNotionalSchedule' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse']:
           return value
        
        # Only validate the 'type' property of the class
        if "schedule_type" != "type":
            return value

        if value not in ('FixedSchedule', 'FloatSchedule', 'OptionalitySchedule', 'StepSchedule', 'Exercise', 'FxRateSchedule', 'FxLinkedNotionalSchedule', 'BondConversionSchedule', 'Invalid'):
            raise ValueError("must be one of enum values ('FixedSchedule', 'FloatSchedule', 'OptionalitySchedule', 'StepSchedule', 'Exercise', 'FxRateSchedule', 'FxLinkedNotionalSchedule', 'BondConversionSchedule', 'Invalid')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FxLinkedNotionalSchedule:
        """Create an instance of FxLinkedNotionalSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of fx_conventions
        if self.fx_conventions:
            _dict['fxConventions'] = self.fx_conventions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of varying_notional_fixing_dates
        if self.varying_notional_fixing_dates:
            _dict['varyingNotionalFixingDates'] = self.varying_notional_fixing_dates.to_dict()
        # override the default output from pydantic by calling `to_dict()` of varying_notional_interim_exchange_payment_dates
        if self.varying_notional_interim_exchange_payment_dates:
            _dict['varyingNotionalInterimExchangePaymentDates'] = self.varying_notional_interim_exchange_payment_dates.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FxLinkedNotionalSchedule:
        """Create an instance of FxLinkedNotionalSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FxLinkedNotionalSchedule.parse_obj(obj)

        _obj = FxLinkedNotionalSchedule.parse_obj({
            "schedule_type": obj.get("scheduleType"),
            "fx_conventions": FxConventions.from_dict(obj.get("fxConventions")) if obj.get("fxConventions") is not None else None,
            "varying_notional_currency": obj.get("varyingNotionalCurrency"),
            "varying_notional_fixing_dates": RelativeDateOffset.from_dict(obj.get("varyingNotionalFixingDates")) if obj.get("varyingNotionalFixingDates") is not None else None,
            "varying_notional_interim_exchange_payment_dates": RelativeDateOffset.from_dict(obj.get("varyingNotionalInterimExchangePaymentDates")) if obj.get("varyingNotionalInterimExchangePaymentDates") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
