# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 
from lusid.models.group_reconciliation_dates import GroupReconciliationDates

class GroupReconciliationRunRequest(BaseModel):
    """
    GroupReconciliationRunRequest
    """
    instance_id:  StrictStr = Field(...,alias="instanceId", description="Reconciliation run Id. Consists of run type (manual or workflow) and identifier.") 
    dates_to_reconcile: Optional[GroupReconciliationDates] = Field(None, alias="datesToReconcile")
    __properties = ["instanceId", "datesToReconcile"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupReconciliationRunRequest:
        """Create an instance of GroupReconciliationRunRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of dates_to_reconcile
        if self.dates_to_reconcile:
            _dict['datesToReconcile'] = self.dates_to_reconcile.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupReconciliationRunRequest:
        """Create an instance of GroupReconciliationRunRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupReconciliationRunRequest.parse_obj(obj)

        _obj = GroupReconciliationRunRequest.parse_obj({
            "instance_id": obj.get("instanceId"),
            "dates_to_reconcile": GroupReconciliationDates.from_dict(obj.get("datesToReconcile")) if obj.get("datesToReconcile") is not None else None
        })
        return _obj
