# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 

class GroupReconciliationUserReviewComment(BaseModel):
    """
    GroupReconciliationUserReviewComment
    """
    comment_text:  StrictStr = Field(...,alias="commentText", description="User's comment regarding the reconciliation result.") 
    user_id:  Optional[StrictStr] = Field(None,alias="userId", description="Id of the user who made a User Review input.") 
    as_at_added: Optional[datetime] = Field(None, alias="asAtAdded", description="The timestamp of the added User Review input.")
    as_at_invalid: Optional[datetime] = Field(None, alias="asAtInvalid", description="The timestamp when User Review input became invalid e.g. because of the different attribute values within the new run.")
    __properties = ["commentText", "userId", "asAtAdded", "asAtInvalid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupReconciliationUserReviewComment:
        """Create an instance of GroupReconciliationUserReviewComment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id is None and "user_id" in self.__fields_set__:
            _dict['userId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupReconciliationUserReviewComment:
        """Create an instance of GroupReconciliationUserReviewComment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupReconciliationUserReviewComment.parse_obj(obj)

        _obj = GroupReconciliationUserReviewComment.parse_obj({
            "comment_text": obj.get("commentText"),
            "user_id": obj.get("userId"),
            "as_at_added": obj.get("asAtAdded"),
            "as_at_invalid": obj.get("asAtInvalid")
        })
        return _obj
