# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, conlist 
from lusid.models.order_graph_block_placement_detail import OrderGraphBlockPlacementDetail

class OrderGraphBlockPlacementSynopsis(BaseModel):
    """
    OrderGraphBlockPlacementSynopsis
    """
    quantity: Union[StrictFloat, StrictInt] = Field(..., description="Total number of units placed.")
    quantity_by_state: Optional[Dict[str, Union[StrictFloat, StrictInt]]] = Field(None, alias="quantityByState", description="Total number of units placed.")
    details: conlist(OrderGraphBlockPlacementDetail) = Field(..., description="Identifiers for each placement in this block.")
    __properties = ["quantity", "quantityByState", "details"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrderGraphBlockPlacementSynopsis:
        """Create an instance of OrderGraphBlockPlacementSynopsis from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item in self.details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['details'] = _items
        # set to None if quantity_by_state (nullable) is None
        # and __fields_set__ contains the field
        if self.quantity_by_state is None and "quantity_by_state" in self.__fields_set__:
            _dict['quantityByState'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrderGraphBlockPlacementSynopsis:
        """Create an instance of OrderGraphBlockPlacementSynopsis from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrderGraphBlockPlacementSynopsis.parse_obj(obj)

        _obj = OrderGraphBlockPlacementSynopsis.parse_obj({
            "quantity": obj.get("quantity"),
            "quantity_by_state": obj.get("quantityByState"),
            "details": [OrderGraphBlockPlacementDetail.from_dict(_item) for _item in obj.get("details")] if obj.get("details") is not None else None
        })
        return _obj
