# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictStr 
from lusid.models.model_selection import ModelSelection
from lusid.models.return_zero_pv_options import ReturnZeroPvOptions

class PricingOptions(BaseModel):
    """
    Options for controlling the default aspects and behaviour of the pricing engine.  # noqa: E501
    """
    model_selection: Optional[ModelSelection] = Field(None, alias="modelSelection")
    use_instrument_type_to_determine_pricer: Optional[StrictBool] = Field(None, alias="useInstrumentTypeToDeterminePricer", description="If true then use the instrument type to set the default instrument pricer  This applies where no more specific set of overrides are provided on a per-vendor and instrument basis.")
    allow_any_instruments_with_sec_uid_to_price_off_lookup: Optional[StrictBool] = Field(None, alias="allowAnyInstrumentsWithSecUidToPriceOffLookup", description="By default, one would not expect to price and exotic instrument, i.e. an instrument with a complicated  instrument definition simply through looking up a price as there should be a better way of evaluating it.  To override that behaviour and allow lookup for a price from the instrument identifier(s), set this to true.")
    allow_partially_successful_evaluation: Optional[StrictBool] = Field(None, alias="allowPartiallySuccessfulEvaluation", description="If true then a failure in task evaluation doesn't cause overall failure.  results will be returned where they succeeded and annotation elsewhere")
    produce_separate_result_for_linear_otc_legs: Optional[StrictBool] = Field(None, alias="produceSeparateResultForLinearOtcLegs", description="If true (default), when pricing an Fx-Forward or Interest Rate Swap, Future and other linearly separable products, product two results, one for each leg  rather than a single line result with the amalgamated/summed pv from both legs.")
    enable_use_of_cached_unit_results: Optional[StrictBool] = Field(None, alias="enableUseOfCachedUnitResults", description="If true, when pricing using a model or for an instrument that supports use of intermediate cached-results, use them.  Default is that this caching is turned off.")
    window_valuation_on_instrument_start_end: Optional[StrictBool] = Field(None, alias="windowValuationOnInstrumentStartEnd", description="If true, when valuing an instrument outside the period where it is 'alive' (the start-maturity window) it will return a valuation of zero")
    remove_contingent_cashflows_in_payment_diary: Optional[StrictBool] = Field(None, alias="removeContingentCashflowsInPaymentDiary", description="When creating a payment diary, should contingent cash payments (e.g. from exercise of a swaption into a swap) be included or not.  i.e. Is exercise or default being assumed to happen or not.")
    use_child_sub_holding_keys_for_portfolio_expansion: Optional[StrictBool] = Field(None, alias="useChildSubHoldingKeysForPortfolioExpansion", description="Should fund constituents inherit subholding keys from the parent subholding keyb")
    validate_domestic_and_quote_currencies_are_consistent: Optional[StrictBool] = Field(None, alias="validateDomesticAndQuoteCurrenciesAreConsistent", description="Do we validate that the instrument domestic currency matches the quote currency (unless unknown/zzz) when using lookup pricing.")
    mbs_valuation_using_holding_current_face: Optional[StrictBool] = Field(None, alias="mbsValuationUsingHoldingCurrentFace")
    convert_srs_cash_flows_to_portfolio_currency: Optional[StrictBool] = Field(None, alias="convertSrsCashFlowsToPortfolioCurrency", description="In the case upserted structured result store (SRS) cashflows are not   in the portfolio currency, set this parameter to True to convert said  cashflows into the portfolio currency. By default, this flag is set   to False and Lusid will not do any FX conversion.    Please note that FX conversion is dependent on the data available in  the quote store - ensure that all relevant FX quotes have been loaded  for cashflow currency conversion.")
    conserved_quantity_for_lookthrough_expansion:  Optional[StrictStr] = Field(None,alias="conservedQuantityForLookthroughExpansion", description="When performing lookthrough portfolio expansion with ScalingMethodology set to \"Sum\" or \"AbsoluteSum\",  the quantity specified here will be conserved and apportioned to lookthrough constituents.  For example, an equal-weighting index with 100 constituents can be modelled as a reference portfolio with 1% weights on each equity.  When expanding a $9000 holding of that index into its constituents while conserving PV, we end up with $90 of each equity.  The number of units of each equity held is then implied.  Note that conservation of one quantity may imply non-conservation of others, especially when some constituents are OTCs.                Allowed values are: \"PV\" (default), \"Exposure\".") 
    return_zero_pv: Optional[ReturnZeroPvOptions] = Field(None, alias="returnZeroPv")
    enable_leg_level_inference_for_custom_srs_columns: Optional[StrictBool] = Field(None, alias="enableLegLevelInferenceForCustomSrsColumns", description="When enabled, allows inference between leg-level and  instrument-level data during portfolio valuation. If  data is missing at one level, it may be inferred from  the other level. For example, missing leg-level data   may be inferred from existing leg-level and instrument-  level data when ProduceSeparateResultForLinearOtcLegs  is enabled, and vice versa. Explicitly provided data  always takes precedence.")
    __properties = ["modelSelection", "useInstrumentTypeToDeterminePricer", "allowAnyInstrumentsWithSecUidToPriceOffLookup", "allowPartiallySuccessfulEvaluation", "produceSeparateResultForLinearOtcLegs", "enableUseOfCachedUnitResults", "windowValuationOnInstrumentStartEnd", "removeContingentCashflowsInPaymentDiary", "useChildSubHoldingKeysForPortfolioExpansion", "validateDomesticAndQuoteCurrenciesAreConsistent", "mbsValuationUsingHoldingCurrentFace", "convertSrsCashFlowsToPortfolioCurrency", "conservedQuantityForLookthroughExpansion", "returnZeroPv", "enableLegLevelInferenceForCustomSrsColumns"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PricingOptions:
        """Create an instance of PricingOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of model_selection
        if self.model_selection:
            _dict['modelSelection'] = self.model_selection.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_zero_pv
        if self.return_zero_pv:
            _dict['returnZeroPv'] = self.return_zero_pv.to_dict()
        # set to None if conserved_quantity_for_lookthrough_expansion (nullable) is None
        # and __fields_set__ contains the field
        if self.conserved_quantity_for_lookthrough_expansion is None and "conserved_quantity_for_lookthrough_expansion" in self.__fields_set__:
            _dict['conservedQuantityForLookthroughExpansion'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PricingOptions:
        """Create an instance of PricingOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PricingOptions.parse_obj(obj)

        _obj = PricingOptions.parse_obj({
            "model_selection": ModelSelection.from_dict(obj.get("modelSelection")) if obj.get("modelSelection") is not None else None,
            "use_instrument_type_to_determine_pricer": obj.get("useInstrumentTypeToDeterminePricer"),
            "allow_any_instruments_with_sec_uid_to_price_off_lookup": obj.get("allowAnyInstrumentsWithSecUidToPriceOffLookup"),
            "allow_partially_successful_evaluation": obj.get("allowPartiallySuccessfulEvaluation"),
            "produce_separate_result_for_linear_otc_legs": obj.get("produceSeparateResultForLinearOtcLegs"),
            "enable_use_of_cached_unit_results": obj.get("enableUseOfCachedUnitResults"),
            "window_valuation_on_instrument_start_end": obj.get("windowValuationOnInstrumentStartEnd"),
            "remove_contingent_cashflows_in_payment_diary": obj.get("removeContingentCashflowsInPaymentDiary"),
            "use_child_sub_holding_keys_for_portfolio_expansion": obj.get("useChildSubHoldingKeysForPortfolioExpansion"),
            "validate_domestic_and_quote_currencies_are_consistent": obj.get("validateDomesticAndQuoteCurrenciesAreConsistent"),
            "mbs_valuation_using_holding_current_face": obj.get("mbsValuationUsingHoldingCurrentFace"),
            "convert_srs_cash_flows_to_portfolio_currency": obj.get("convertSrsCashFlowsToPortfolioCurrency"),
            "conserved_quantity_for_lookthrough_expansion": obj.get("conservedQuantityForLookthroughExpansion"),
            "return_zero_pv": ReturnZeroPvOptions.from_dict(obj.get("returnZeroPv")) if obj.get("returnZeroPv") is not None else None,
            "enable_leg_level_inference_for_custom_srs_columns": obj.get("enableLegLevelInferenceForCustomSrsColumns")
        })
        return _obj
