# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr 
from lusid.models.recipe_value import RecipeValue

class RecipeBlock(BaseModel):
    """
    An atomic operation used in Recipe composer to compose a Configuration Recipe  # noqa: E501
    """
    value: Optional[RecipeValue] = None
    path:  Optional[StrictStr] = Field(None,alias="path", description="Path of the Value that the operation is to be performed on.") 
    op:  Optional[StrictStr] = Field(None,alias="op", description="Operation to be performed on the part of the value.") 
    __properties = ["value", "path", "op"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RecipeBlock:
        """Create an instance of RecipeBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        # set to None if path (nullable) is None
        # and __fields_set__ contains the field
        if self.path is None and "path" in self.__fields_set__:
            _dict['path'] = None

        # set to None if op (nullable) is None
        # and __fields_set__ contains the field
        if self.op is None and "op" in self.__fields_set__:
            _dict['op'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RecipeBlock:
        """Create an instance of RecipeBlock from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RecipeBlock.parse_obj(obj)

        _obj = RecipeBlock.parse_obj({
            "value": RecipeValue.from_dict(obj.get("value")) if obj.get("value") is not None else None,
            "path": obj.get("path"),
            "op": obj.get("op")
        })
        return _obj
