#!/bin/bash
#=======================================================================
# 🌳 BROOT SHELL INTEGRATION 🌳
#=======================================================================
# This script was automatically generated by the broot program
# More information can be found in https://github.com/Canop/broot
# 
# This function starts broot and executes the command it produces, if any.
# It's needed because some shell commands, like `cd`, have no useful effect 
# if executed in a subshell.

function br {
    #-----------------------------------------------------------------------
    # Function to integrate broot with the shell environment
    #-----------------------------------------------------------------------
    local cmd cmd_file code
    
    # Create temporary file for broot to write its command
    cmd_file=$(mktemp)
    
    # Run broot with the temporary command file
    if broot --outcmd "$cmd_file" "$@"; then
        # If broot exited successfully, read the command
        cmd=$(<"$cmd_file")
        
        # Clean up temporary file
        rm -f "$cmd_file"
        
        # Execute the command broot produced
        eval "$cmd"
    else
        # Handle errors
        code=$?
        
        # Clean up temporary file
        rm -f "$cmd_file"
        
        # Return the exit code from broot
        return "$code"
    fi
}

#=======================================================================
# ℹ️ USAGE:
#    br [options]
#
# 🔧 EXAMPLES:
#    br                 # Open broot in the current directory
#    br /path/to/dir    # Open broot in the specified directory
#    br -h              # Show broot help
#=======================================================================
