# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardGroupArgs', 'DashboardGroup']

@pulumi.input_type
class DashboardGroupArgs:
    def __init__(__self__, *,
                 authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dashboards: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupDashboardArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 import_qualifiers: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupImportQualifierArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupPermissionArgs']]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DashboardGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_teams: Team IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's team (or user id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_users: User IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGroupDashboardArgs']]] dashboards: [Mirrored dashboards](https://docs.splunk.com/observability/en/data-visualization/dashboards/dashboard-share-clone-mirror.html#mirror-dashboard) in this dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param pulumi.Input[_builtins.str] description: Description of the dashboard group.
        :param pulumi.Input[_builtins.str] name: Name of the dashboard group.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGroupPermissionArgs']]] permissions: [Permissions](https://docs.splunk.com/Observability/infrastructure/terms-concepts/permissions.html) List of read and write permission configuration to specify which user, team, and organization can view and/or edit your dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: Team IDs to associate the dashboard group to.
        """
        if authorized_writer_teams is not None:
            warnings.warn("""Please use permissions field now""", DeprecationWarning)
            pulumi.log.warn("""authorized_writer_teams is deprecated: Please use permissions field now""")
        if authorized_writer_teams is not None:
            pulumi.set(__self__, "authorized_writer_teams", authorized_writer_teams)
        if authorized_writer_users is not None:
            warnings.warn("""Please use permissions field now""", DeprecationWarning)
            pulumi.log.warn("""authorized_writer_users is deprecated: Please use permissions field now""")
        if authorized_writer_users is not None:
            pulumi.set(__self__, "authorized_writer_users", authorized_writer_users)
        if dashboards is not None:
            pulumi.set(__self__, "dashboards", dashboards)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if import_qualifiers is not None:
            pulumi.set(__self__, "import_qualifiers", import_qualifiers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterTeams")
    @_utilities.deprecated("""Please use permissions field now""")
    def authorized_writer_teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Team IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's team (or user id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        """
        return pulumi.get(self, "authorized_writer_teams")

    @authorized_writer_teams.setter
    def authorized_writer_teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_writer_teams", value)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterUsers")
    @_utilities.deprecated("""Please use permissions field now""")
    def authorized_writer_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        User IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        """
        return pulumi.get(self, "authorized_writer_users")

    @authorized_writer_users.setter
    def authorized_writer_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_writer_users", value)

    @_builtins.property
    @pulumi.getter
    def dashboards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupDashboardArgs']]]]:
        """
        [Mirrored dashboards](https://docs.splunk.com/observability/en/data-visualization/dashboards/dashboard-share-clone-mirror.html#mirror-dashboard) in this dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        """
        return pulumi.get(self, "dashboards")

    @dashboards.setter
    def dashboards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupDashboardArgs']]]]):
        pulumi.set(self, "dashboards", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the dashboard group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="importQualifiers")
    def import_qualifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupImportQualifierArgs']]]]:
        return pulumi.get(self, "import_qualifiers")

    @import_qualifiers.setter
    def import_qualifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupImportQualifierArgs']]]]):
        pulumi.set(self, "import_qualifiers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the dashboard group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupPermissionArgs']]]]:
        """
        [Permissions](https://docs.splunk.com/Observability/infrastructure/terms-concepts/permissions.html) List of read and write permission configuration to specify which user, team, and organization can view and/or edit your dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Team IDs to associate the dashboard group to.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "teams", value)


@pulumi.input_type
class _DashboardGroupState:
    def __init__(__self__, *,
                 authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dashboards: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupDashboardArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 import_qualifiers: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupImportQualifierArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupPermissionArgs']]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DashboardGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_teams: Team IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's team (or user id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_users: User IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGroupDashboardArgs']]] dashboards: [Mirrored dashboards](https://docs.splunk.com/observability/en/data-visualization/dashboards/dashboard-share-clone-mirror.html#mirror-dashboard) in this dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param pulumi.Input[_builtins.str] description: Description of the dashboard group.
        :param pulumi.Input[_builtins.str] name: Name of the dashboard group.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGroupPermissionArgs']]] permissions: [Permissions](https://docs.splunk.com/Observability/infrastructure/terms-concepts/permissions.html) List of read and write permission configuration to specify which user, team, and organization can view and/or edit your dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: Team IDs to associate the dashboard group to.
        """
        if authorized_writer_teams is not None:
            warnings.warn("""Please use permissions field now""", DeprecationWarning)
            pulumi.log.warn("""authorized_writer_teams is deprecated: Please use permissions field now""")
        if authorized_writer_teams is not None:
            pulumi.set(__self__, "authorized_writer_teams", authorized_writer_teams)
        if authorized_writer_users is not None:
            warnings.warn("""Please use permissions field now""", DeprecationWarning)
            pulumi.log.warn("""authorized_writer_users is deprecated: Please use permissions field now""")
        if authorized_writer_users is not None:
            pulumi.set(__self__, "authorized_writer_users", authorized_writer_users)
        if dashboards is not None:
            pulumi.set(__self__, "dashboards", dashboards)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if import_qualifiers is not None:
            pulumi.set(__self__, "import_qualifiers", import_qualifiers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterTeams")
    @_utilities.deprecated("""Please use permissions field now""")
    def authorized_writer_teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Team IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's team (or user id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        """
        return pulumi.get(self, "authorized_writer_teams")

    @authorized_writer_teams.setter
    def authorized_writer_teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_writer_teams", value)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterUsers")
    @_utilities.deprecated("""Please use permissions field now""")
    def authorized_writer_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        User IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        """
        return pulumi.get(self, "authorized_writer_users")

    @authorized_writer_users.setter
    def authorized_writer_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_writer_users", value)

    @_builtins.property
    @pulumi.getter
    def dashboards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupDashboardArgs']]]]:
        """
        [Mirrored dashboards](https://docs.splunk.com/observability/en/data-visualization/dashboards/dashboard-share-clone-mirror.html#mirror-dashboard) in this dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        """
        return pulumi.get(self, "dashboards")

    @dashboards.setter
    def dashboards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupDashboardArgs']]]]):
        pulumi.set(self, "dashboards", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the dashboard group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="importQualifiers")
    def import_qualifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupImportQualifierArgs']]]]:
        return pulumi.get(self, "import_qualifiers")

    @import_qualifiers.setter
    def import_qualifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupImportQualifierArgs']]]]):
        pulumi.set(self, "import_qualifiers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the dashboard group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupPermissionArgs']]]]:
        """
        [Permissions](https://docs.splunk.com/Observability/infrastructure/terms-concepts/permissions.html) List of read and write permission configuration to specify which user, team, and organization can view and/or edit your dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGroupPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Team IDs to associate the dashboard group to.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "teams", value)


@pulumi.type_token("signalfx:index/dashboardGroup:DashboardGroup")
class DashboardGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dashboards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupDashboardArgs', 'DashboardGroupDashboardArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 import_qualifiers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupImportQualifierArgs', 'DashboardGroupImportQualifierArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupPermissionArgs', 'DashboardGroupPermissionArgsDict']]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        In the Splunk Observability Cloud web UI, a [dashboard group](https://developers.signalfx.com/dashboard_groups_reference.html) is a collection of dashboards.

        Dashboard groups cannot be accessed directly. You can access them through a dashboard within a group.

        > **NOTE** When you want to change or remove write permissions for a user other than yourself regarding dashboard groups, use a session token of an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator).

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mydashboardgroup0 = signalfx.DashboardGroup("mydashboardgroup0",
            name="My team dashboard group",
            description="Cool dashboard group",
            authorized_writer_teams=[mycoolteam["id"]],
            authorized_writer_users=["abc123"])
        ```

        ## Example with permissions

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mydashboardgroup_withpermissions = signalfx.DashboardGroup("mydashboardgroup_withpermissions",
            name="My team dashboard group",
            description="Cool dashboard group",
            permissions=[
                {
                    "principal_id": "abc123",
                    "principal_type": "ORG",
                    "actions": ["READ"],
                },
                {
                    "principal_id": "abc456",
                    "principal_type": "USER",
                    "actions": [
                        "READ",
                        "WRITE",
                    ],
                },
            ])
        ```

        ## Example With mirrored dashboards

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mydashboardgroup_withmirrors = signalfx.DashboardGroup("mydashboardgroup_withmirrors",
            name="My team dashboard group",
            description="Cool dashboard group",
            dashboards=[{
                "dashboard_id": gc_dashboard["id"],
                "name_override": "GC For My Service",
                "description_override": "Garbage Collection dashboard maintained by JVM team",
                "filter_overrides": [{
                    "property": "service",
                    "values": ["myservice"],
                    "negated": False,
                }],
                "variable_overrides": [{
                    "property": "region",
                    "values": ["us-west1"],
                    "values_suggesteds": [
                        "us-west-1",
                        "us-east-1",
                    ],
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_teams: Team IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's team (or user id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_users: User IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupDashboardArgs', 'DashboardGroupDashboardArgsDict']]]] dashboards: [Mirrored dashboards](https://docs.splunk.com/observability/en/data-visualization/dashboards/dashboard-share-clone-mirror.html#mirror-dashboard) in this dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param pulumi.Input[_builtins.str] description: Description of the dashboard group.
        :param pulumi.Input[_builtins.str] name: Name of the dashboard group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupPermissionArgs', 'DashboardGroupPermissionArgsDict']]]] permissions: [Permissions](https://docs.splunk.com/Observability/infrastructure/terms-concepts/permissions.html) List of read and write permission configuration to specify which user, team, and organization can view and/or edit your dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: Team IDs to associate the dashboard group to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DashboardGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        In the Splunk Observability Cloud web UI, a [dashboard group](https://developers.signalfx.com/dashboard_groups_reference.html) is a collection of dashboards.

        Dashboard groups cannot be accessed directly. You can access them through a dashboard within a group.

        > **NOTE** When you want to change or remove write permissions for a user other than yourself regarding dashboard groups, use a session token of an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator).

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mydashboardgroup0 = signalfx.DashboardGroup("mydashboardgroup0",
            name="My team dashboard group",
            description="Cool dashboard group",
            authorized_writer_teams=[mycoolteam["id"]],
            authorized_writer_users=["abc123"])
        ```

        ## Example with permissions

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mydashboardgroup_withpermissions = signalfx.DashboardGroup("mydashboardgroup_withpermissions",
            name="My team dashboard group",
            description="Cool dashboard group",
            permissions=[
                {
                    "principal_id": "abc123",
                    "principal_type": "ORG",
                    "actions": ["READ"],
                },
                {
                    "principal_id": "abc456",
                    "principal_type": "USER",
                    "actions": [
                        "READ",
                        "WRITE",
                    ],
                },
            ])
        ```

        ## Example With mirrored dashboards

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mydashboardgroup_withmirrors = signalfx.DashboardGroup("mydashboardgroup_withmirrors",
            name="My team dashboard group",
            description="Cool dashboard group",
            dashboards=[{
                "dashboard_id": gc_dashboard["id"],
                "name_override": "GC For My Service",
                "description_override": "Garbage Collection dashboard maintained by JVM team",
                "filter_overrides": [{
                    "property": "service",
                    "values": ["myservice"],
                    "negated": False,
                }],
                "variable_overrides": [{
                    "property": "region",
                    "values": ["us-west1"],
                    "values_suggesteds": [
                        "us-west-1",
                        "us-east-1",
                    ],
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param DashboardGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dashboards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupDashboardArgs', 'DashboardGroupDashboardArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 import_qualifiers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupImportQualifierArgs', 'DashboardGroupImportQualifierArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupPermissionArgs', 'DashboardGroupPermissionArgsDict']]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardGroupArgs.__new__(DashboardGroupArgs)

            __props__.__dict__["authorized_writer_teams"] = authorized_writer_teams
            __props__.__dict__["authorized_writer_users"] = authorized_writer_users
            __props__.__dict__["dashboards"] = dashboards
            __props__.__dict__["description"] = description
            __props__.__dict__["import_qualifiers"] = import_qualifiers
            __props__.__dict__["name"] = name
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["teams"] = teams
        super(DashboardGroup, __self__).__init__(
            'signalfx:index/dashboardGroup:DashboardGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dashboards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupDashboardArgs', 'DashboardGroupDashboardArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            import_qualifiers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupImportQualifierArgs', 'DashboardGroupImportQualifierArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupPermissionArgs', 'DashboardGroupPermissionArgsDict']]]]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'DashboardGroup':
        """
        Get an existing DashboardGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_teams: Team IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's team (or user id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_users: User IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupDashboardArgs', 'DashboardGroupDashboardArgsDict']]]] dashboards: [Mirrored dashboards](https://docs.splunk.com/observability/en/data-visualization/dashboards/dashboard-share-clone-mirror.html#mirror-dashboard) in this dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param pulumi.Input[_builtins.str] description: Description of the dashboard group.
        :param pulumi.Input[_builtins.str] name: Name of the dashboard group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGroupPermissionArgs', 'DashboardGroupPermissionArgsDict']]]] permissions: [Permissions](https://docs.splunk.com/Observability/infrastructure/terms-concepts/permissions.html) List of read and write permission configuration to specify which user, team, and organization can view and/or edit your dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: Team IDs to associate the dashboard group to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardGroupState.__new__(_DashboardGroupState)

        __props__.__dict__["authorized_writer_teams"] = authorized_writer_teams
        __props__.__dict__["authorized_writer_users"] = authorized_writer_users
        __props__.__dict__["dashboards"] = dashboards
        __props__.__dict__["description"] = description
        __props__.__dict__["import_qualifiers"] = import_qualifiers
        __props__.__dict__["name"] = name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["teams"] = teams
        return DashboardGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterTeams")
    @_utilities.deprecated("""Please use permissions field now""")
    def authorized_writer_teams(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Team IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's team (or user id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        """
        return pulumi.get(self, "authorized_writer_teams")

    @_builtins.property
    @pulumi.getter(name="authorizedWriterUsers")
    @_utilities.deprecated("""Please use permissions field now""")
    def authorized_writer_users(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        User IDs that have write access to this dashboard group. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`). **Note:** Deprecated use `permissions` instead.
        """
        return pulumi.get(self, "authorized_writer_users")

    @_builtins.property
    @pulumi.getter
    def dashboards(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardGroupDashboard']]]:
        """
        [Mirrored dashboards](https://docs.splunk.com/observability/en/data-visualization/dashboards/dashboard-share-clone-mirror.html#mirror-dashboard) in this dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        """
        return pulumi.get(self, "dashboards")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the dashboard group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="importQualifiers")
    def import_qualifiers(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardGroupImportQualifier']]]:
        return pulumi.get(self, "import_qualifiers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the dashboard group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence['outputs.DashboardGroupPermission']]:
        """
        [Permissions](https://docs.splunk.com/Observability/infrastructure/terms-concepts/permissions.html) List of read and write permission configuration to specify which user, team, and organization can view and/or edit your dashboard group. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def teams(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Team IDs to associate the dashboard group to.
        """
        return pulumi.get(self, "teams")

