# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SingleValueChartArgs', 'SingleValueChart']

@pulumi.input_type
class SingleValueChartArgs:
    def __init__(__self__, *,
                 program_text: pulumi.Input[_builtins.str],
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartColorScaleArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_timestamp_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
                 show_spark_line: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartVizOptionArgs']]]] = None):
        """
        The set of arguments for constructing a SingleValueChart resource.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[_builtins.str] color_by: Must be `"Dimension"`, `"Scale"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[Sequence[pulumi.Input['SingleValueChartColorScaleArgs']]] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] is_timestamp_hidden: Whether to hide the timestamp in the chart. `false` by default.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints
        :param pulumi.Input[_builtins.int] max_precision: The maximum precision to for value displayed.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the value.
        :param pulumi.Input[_builtins.str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`None`).
        :param pulumi.Input[_builtins.bool] show_spark_line: Whether to show a trend line below the current value. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary"`. `"Metric"` by default.
        :param pulumi.Input[Sequence[pulumi.Input['SingleValueChartVizOptionArgs']]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        pulumi.set(__self__, "program_text", program_text)
        if color_by is not None:
            pulumi.set(__self__, "color_by", color_by)
        if color_scales is not None:
            pulumi.set(__self__, "color_scales", color_scales)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_timestamp_hidden is not None:
            pulumi.set(__self__, "is_timestamp_hidden", is_timestamp_hidden)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if max_precision is not None:
            pulumi.set(__self__, "max_precision", max_precision)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if secondary_visualization is not None:
            pulumi.set(__self__, "secondary_visualization", secondary_visualization)
        if show_spark_line is not None:
            pulumi.set(__self__, "show_spark_line", show_spark_line)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if unit_prefix is not None:
            pulumi.set(__self__, "unit_prefix", unit_prefix)
        if viz_options is not None:
            pulumi.set(__self__, "viz_options", viz_options)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Input[_builtins.str]:
        """
        Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Dimension"`, `"Scale"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @color_by.setter
    def color_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "color_by", value)

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartColorScaleArgs']]]]:
        """
        Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        """
        return pulumi.get(self, "color_scales")

    @color_scales.setter
    def color_scales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartColorScaleArgs']]]]):
        pulumi.set(self, "color_scales", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isTimestampHidden")
    def is_timestamp_hidden(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to hide the timestamp in the chart. `false` by default.
        """
        return pulumi.get(self, "is_timestamp_hidden")

    @is_timestamp_hidden.setter
    def is_timestamp_hidden(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_timestamp_hidden", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="maxPrecision")
    def max_precision(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum precision to for value displayed.
        """
        return pulumi.get(self, "max_precision")

    @max_precision.setter
    def max_precision(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_precision", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (in seconds) to refresh the value.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="secondaryVisualization")
    def secondary_visualization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`None`).
        """
        return pulumi.get(self, "secondary_visualization")

    @secondary_visualization.setter
    def secondary_visualization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_visualization", value)

    @_builtins.property
    @pulumi.getter(name="showSparkLine")
    def show_spark_line(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to show a trend line below the current value. `false` by default.
        """
        return pulumi.get(self, "show_spark_line")

    @show_spark_line.setter
    def show_spark_line(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_spark_line", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary"`. `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @unit_prefix.setter
    def unit_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_prefix", value)

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartVizOptionArgs']]]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

    @viz_options.setter
    def viz_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartVizOptionArgs']]]]):
        pulumi.set(self, "viz_options", value)


@pulumi.input_type
class _SingleValueChartState:
    def __init__(__self__, *,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartColorScaleArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_timestamp_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
                 show_spark_line: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartVizOptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering SingleValueChart resources.
        :param pulumi.Input[_builtins.str] color_by: Must be `"Dimension"`, `"Scale"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[Sequence[pulumi.Input['SingleValueChartColorScaleArgs']]] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] is_timestamp_hidden: Whether to hide the timestamp in the chart. `false` by default.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints
        :param pulumi.Input[_builtins.int] max_precision: The maximum precision to for value displayed.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the value.
        :param pulumi.Input[_builtins.str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`None`).
        :param pulumi.Input[_builtins.bool] show_spark_line: Whether to show a trend line below the current value. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary"`. `"Metric"` by default.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        :param pulumi.Input[Sequence[pulumi.Input['SingleValueChartVizOptionArgs']]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        if color_by is not None:
            pulumi.set(__self__, "color_by", color_by)
        if color_scales is not None:
            pulumi.set(__self__, "color_scales", color_scales)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_timestamp_hidden is not None:
            pulumi.set(__self__, "is_timestamp_hidden", is_timestamp_hidden)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if max_precision is not None:
            pulumi.set(__self__, "max_precision", max_precision)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if program_text is not None:
            pulumi.set(__self__, "program_text", program_text)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if secondary_visualization is not None:
            pulumi.set(__self__, "secondary_visualization", secondary_visualization)
        if show_spark_line is not None:
            pulumi.set(__self__, "show_spark_line", show_spark_line)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if unit_prefix is not None:
            pulumi.set(__self__, "unit_prefix", unit_prefix)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if viz_options is not None:
            pulumi.set(__self__, "viz_options", viz_options)

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Dimension"`, `"Scale"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @color_by.setter
    def color_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "color_by", value)

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartColorScaleArgs']]]]:
        """
        Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        """
        return pulumi.get(self, "color_scales")

    @color_scales.setter
    def color_scales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartColorScaleArgs']]]]):
        pulumi.set(self, "color_scales", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isTimestampHidden")
    def is_timestamp_hidden(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to hide the timestamp in the chart. `false` by default.
        """
        return pulumi.get(self, "is_timestamp_hidden")

    @is_timestamp_hidden.setter
    def is_timestamp_hidden(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_timestamp_hidden", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="maxPrecision")
    def max_precision(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum precision to for value displayed.
        """
        return pulumi.get(self, "max_precision")

    @max_precision.setter
    def max_precision(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_precision", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (in seconds) to refresh the value.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="secondaryVisualization")
    def secondary_visualization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`None`).
        """
        return pulumi.get(self, "secondary_visualization")

    @secondary_visualization.setter
    def secondary_visualization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_visualization", value)

    @_builtins.property
    @pulumi.getter(name="showSparkLine")
    def show_spark_line(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to show a trend line below the current value. `false` by default.
        """
        return pulumi.get(self, "show_spark_line")

    @show_spark_line.setter
    def show_spark_line(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_spark_line", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary"`. `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @unit_prefix.setter
    def unit_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_prefix", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartVizOptionArgs']]]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

    @viz_options.setter
    def viz_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SingleValueChartVizOptionArgs']]]]):
        pulumi.set(self, "viz_options", value)


@pulumi.type_token("signalfx:index/singleValueChart:SingleValueChart")
class SingleValueChart(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartColorScaleArgs', 'SingleValueChartColorScaleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_timestamp_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
                 show_spark_line: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartVizOptionArgs', 'SingleValueChartVizOptionArgsDict']]]]] = None,
                 __props__=None):
        """
        This chart type displays a single number in a large font, representing the current value of a single metric on a plot line.

        If the time period is in the past, the number represents the value of the metric near the end of the time period.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mysvchart0 = signalfx.SingleValueChart("mysvchart0",
            name="CPU Total Idle - Single Value",
            program_text=\"\"\"myfilters = filter(\\"cluster_name\\", \\"prod\\") and filter(\\"role\\", \\"search\\")
        data(\\"cpu.total.idle\\", filter=myfilters).publish()
        \"\"\",
            description="Very cool Single Value Chart",
            color_by="Dimension",
            max_delay=2,
            refresh_interval=1,
            max_precision=2,
            is_timestamp_hidden=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] color_by: Must be `"Dimension"`, `"Scale"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartColorScaleArgs', 'SingleValueChartColorScaleArgsDict']]]] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] is_timestamp_hidden: Whether to hide the timestamp in the chart. `false` by default.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints
        :param pulumi.Input[_builtins.int] max_precision: The maximum precision to for value displayed.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the value.
        :param pulumi.Input[_builtins.str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`None`).
        :param pulumi.Input[_builtins.bool] show_spark_line: Whether to show a trend line below the current value. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary"`. `"Metric"` by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartVizOptionArgs', 'SingleValueChartVizOptionArgsDict']]]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SingleValueChartArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This chart type displays a single number in a large font, representing the current value of a single metric on a plot line.

        If the time period is in the past, the number represents the value of the metric near the end of the time period.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mysvchart0 = signalfx.SingleValueChart("mysvchart0",
            name="CPU Total Idle - Single Value",
            program_text=\"\"\"myfilters = filter(\\"cluster_name\\", \\"prod\\") and filter(\\"role\\", \\"search\\")
        data(\\"cpu.total.idle\\", filter=myfilters).publish()
        \"\"\",
            description="Very cool Single Value Chart",
            color_by="Dimension",
            max_delay=2,
            refresh_interval=1,
            max_precision=2,
            is_timestamp_hidden=True)
        ```

        :param str resource_name: The name of the resource.
        :param SingleValueChartArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SingleValueChartArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartColorScaleArgs', 'SingleValueChartColorScaleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_timestamp_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
                 show_spark_line: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartVizOptionArgs', 'SingleValueChartVizOptionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SingleValueChartArgs.__new__(SingleValueChartArgs)

            __props__.__dict__["color_by"] = color_by
            __props__.__dict__["color_scales"] = color_scales
            __props__.__dict__["description"] = description
            __props__.__dict__["is_timestamp_hidden"] = is_timestamp_hidden
            __props__.__dict__["max_delay"] = max_delay
            __props__.__dict__["max_precision"] = max_precision
            __props__.__dict__["name"] = name
            if program_text is None and not opts.urn:
                raise TypeError("Missing required property 'program_text'")
            __props__.__dict__["program_text"] = program_text
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["secondary_visualization"] = secondary_visualization
            __props__.__dict__["show_spark_line"] = show_spark_line
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["unit_prefix"] = unit_prefix
            __props__.__dict__["viz_options"] = viz_options
            __props__.__dict__["url"] = None
        super(SingleValueChart, __self__).__init__(
            'signalfx:index/singleValueChart:SingleValueChart',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            color_by: Optional[pulumi.Input[_builtins.str]] = None,
            color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartColorScaleArgs', 'SingleValueChartColorScaleArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            is_timestamp_hidden: Optional[pulumi.Input[_builtins.bool]] = None,
            max_delay: Optional[pulumi.Input[_builtins.int]] = None,
            max_precision: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            program_text: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
            secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
            show_spark_line: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartVizOptionArgs', 'SingleValueChartVizOptionArgsDict']]]]] = None) -> 'SingleValueChart':
        """
        Get an existing SingleValueChart resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] color_by: Must be `"Dimension"`, `"Scale"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartColorScaleArgs', 'SingleValueChartColorScaleArgsDict']]]] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] is_timestamp_hidden: Whether to hide the timestamp in the chart. `false` by default.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints
        :param pulumi.Input[_builtins.int] max_precision: The maximum precision to for value displayed.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the value.
        :param pulumi.Input[_builtins.str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`None`).
        :param pulumi.Input[_builtins.bool] show_spark_line: Whether to show a trend line below the current value. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary"`. `"Metric"` by default.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SingleValueChartVizOptionArgs', 'SingleValueChartVizOptionArgsDict']]]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SingleValueChartState.__new__(_SingleValueChartState)

        __props__.__dict__["color_by"] = color_by
        __props__.__dict__["color_scales"] = color_scales
        __props__.__dict__["description"] = description
        __props__.__dict__["is_timestamp_hidden"] = is_timestamp_hidden
        __props__.__dict__["max_delay"] = max_delay
        __props__.__dict__["max_precision"] = max_precision
        __props__.__dict__["name"] = name
        __props__.__dict__["program_text"] = program_text
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["secondary_visualization"] = secondary_visualization
        __props__.__dict__["show_spark_line"] = show_spark_line
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["unit_prefix"] = unit_prefix
        __props__.__dict__["url"] = url
        __props__.__dict__["viz_options"] = viz_options
        return SingleValueChart(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Must be `"Dimension"`, `"Scale"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> pulumi.Output[Optional[Sequence['outputs.SingleValueChartColorScale']]]:
        """
        Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        """
        return pulumi.get(self, "color_scales")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="isTimestampHidden")
    def is_timestamp_hidden(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to hide the timestamp in the chart. `false` by default.
        """
        return pulumi.get(self, "is_timestamp_hidden")

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints
        """
        return pulumi.get(self, "max_delay")

    @_builtins.property
    @pulumi.getter(name="maxPrecision")
    def max_precision(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum precision to for value displayed.
        """
        return pulumi.get(self, "max_precision")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Output[_builtins.str]:
        """
        Signalflow program text for the chart. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How often (in seconds) to refresh the value.
        """
        return pulumi.get(self, "refresh_interval")

    @_builtins.property
    @pulumi.getter(name="secondaryVisualization")
    def secondary_visualization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`None`).
        """
        return pulumi.get(self, "secondary_visualization")

    @_builtins.property
    @pulumi.getter(name="showSparkLine")
    def show_spark_line(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to show a trend line below the current value. `false` by default.
        """
        return pulumi.get(self, "show_spark_line")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary"`. `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> pulumi.Output[Optional[Sequence['outputs.SingleValueChartVizOption']]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

