"""
CipherX - A Substitution-Permutation Network (SPN) cipher implementation.

This package provides a custom block cipher with multiple modes of operation.
"""

from .core import (
    # Core encryption/decryption functions
    encrypt, decrypt,
    encrypt_cbc, decrypt_cbc,
    encrypt_ctr, decrypt_ctr,

    # Block-level operations
    encrypt_block, decrypt_block,

    # Utility functions
    pad_data, unpad_data,

    # Internal components (exported for advanced use)
    mix_columns, inverse_mix_columns,
    key_schedule, generate_round_constants,
)

# Public API - recommended functions for users
__all__ = [
    # Recommended: Use CBC mode for most applications
    'encrypt_cbc',
    'decrypt_cbc',

    # Alternative: CTR mode for streaming
    'encrypt_ctr',
    'decrypt_ctr',

    # Legacy: ECB mode (less secure, avoid in production)
    'encrypt',
    'decrypt',

    # Utilities
    'pad_data',
    'unpad_data',
]

__version__ = '1.1.0'
__author__ = 'Christian Johnson'
__email__ = 'cjohnson@metisos.com'
