"""Model Registry REST API.

REST API for Model Registry to create and manage ML model metadata

The version of the OpenAPI document: v1alpha3
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from typing import Annotated, Any, Optional, Union

from pydantic import Field, StrictFloat, StrictInt, StrictStr, validate_call

from mr_openapi.api_client import ApiClient, RequestSerialized
from mr_openapi.api_response import ApiResponse
from mr_openapi.models.artifact import Artifact
from mr_openapi.models.artifact_create import ArtifactCreate
from mr_openapi.models.artifact_list import ArtifactList
from mr_openapi.models.artifact_type_query_param import ArtifactTypeQueryParam
from mr_openapi.models.artifact_update import ArtifactUpdate
from mr_openapi.models.experiment import Experiment
from mr_openapi.models.experiment_create import ExperimentCreate
from mr_openapi.models.experiment_list import ExperimentList
from mr_openapi.models.experiment_run import ExperimentRun
from mr_openapi.models.experiment_run_create import ExperimentRunCreate
from mr_openapi.models.experiment_run_list import ExperimentRunList
from mr_openapi.models.experiment_run_update import ExperimentRunUpdate
from mr_openapi.models.experiment_update import ExperimentUpdate
from mr_openapi.models.inference_service import InferenceService
from mr_openapi.models.inference_service_create import InferenceServiceCreate
from mr_openapi.models.inference_service_list import InferenceServiceList
from mr_openapi.models.inference_service_update import InferenceServiceUpdate
from mr_openapi.models.metric_list import MetricList
from mr_openapi.models.model_artifact import ModelArtifact
from mr_openapi.models.model_artifact_create import ModelArtifactCreate
from mr_openapi.models.model_artifact_list import ModelArtifactList
from mr_openapi.models.model_artifact_update import ModelArtifactUpdate
from mr_openapi.models.model_version import ModelVersion
from mr_openapi.models.model_version_create import ModelVersionCreate
from mr_openapi.models.model_version_list import ModelVersionList
from mr_openapi.models.model_version_update import ModelVersionUpdate
from mr_openapi.models.order_by_field import OrderByField
from mr_openapi.models.registered_model import RegisteredModel
from mr_openapi.models.registered_model_create import RegisteredModelCreate
from mr_openapi.models.registered_model_list import RegisteredModelList
from mr_openapi.models.registered_model_update import RegisteredModelUpdate
from mr_openapi.models.serve_model import ServeModel
from mr_openapi.models.serve_model_create import ServeModelCreate
from mr_openapi.models.serve_model_list import ServeModelList
from mr_openapi.models.serving_environment import ServingEnvironment
from mr_openapi.models.serving_environment_create import ServingEnvironmentCreate
from mr_openapi.models.serving_environment_list import ServingEnvironmentList
from mr_openapi.models.serving_environment_update import ServingEnvironmentUpdate
from mr_openapi.models.sort_order import SortOrder
from mr_openapi.rest import RESTResponseType


class ModelRegistryServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def create_artifact(
        self,
        artifact_create: Annotated[ArtifactCreate, Field(description="A new `Artifact` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Artifact:
        """Create an Artifact.

        Creates a new instance of an `Artifact`.

        :param artifact_create: A new `Artifact` to be created. (required)
        :type artifact_create: ArtifactCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_artifact_serialize(
            artifact_create=artifact_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_artifact_with_http_info(
        self,
        artifact_create: Annotated[ArtifactCreate, Field(description="A new `Artifact` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Artifact]:
        """Create an Artifact.

        Creates a new instance of an `Artifact`.

        :param artifact_create: A new `Artifact` to be created. (required)
        :type artifact_create: ArtifactCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_artifact_serialize(
            artifact_create=artifact_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_artifact_without_preload_content(
        self,
        artifact_create: Annotated[ArtifactCreate, Field(description="A new `Artifact` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create an Artifact.

        Creates a new instance of an `Artifact`.

        :param artifact_create: A new `Artifact` to be created. (required)
        :type artifact_create: ArtifactCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_artifact_serialize(
            artifact_create=artifact_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_artifact_serialize(
        self,
        artifact_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if artifact_create is not None:
            _body_params = artifact_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/artifacts",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_environment_inference_service(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        inference_service_create: Annotated[
            InferenceServiceCreate, Field(description="A new `InferenceService` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InferenceService:
        """Create a InferenceService in ServingEnvironment.

        Creates a new instance of a `InferenceService`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param inference_service_create: A new `InferenceService` to be created. (required)
        :type inference_service_create: InferenceServiceCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_environment_inference_service_serialize(
            servingenvironment_id=servingenvironment_id,
            inference_service_create=inference_service_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_environment_inference_service_with_http_info(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        inference_service_create: Annotated[
            InferenceServiceCreate, Field(description="A new `InferenceService` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InferenceService]:
        """Create a InferenceService in ServingEnvironment.

        Creates a new instance of a `InferenceService`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param inference_service_create: A new `InferenceService` to be created. (required)
        :type inference_service_create: InferenceServiceCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_environment_inference_service_serialize(
            servingenvironment_id=servingenvironment_id,
            inference_service_create=inference_service_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_environment_inference_service_without_preload_content(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        inference_service_create: Annotated[
            InferenceServiceCreate, Field(description="A new `InferenceService` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a InferenceService in ServingEnvironment.

        Creates a new instance of a `InferenceService`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param inference_service_create: A new `InferenceService` to be created. (required)
        :type inference_service_create: InferenceServiceCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_environment_inference_service_serialize(
            servingenvironment_id=servingenvironment_id,
            inference_service_create=inference_service_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_environment_inference_service_serialize(
        self,
        servingenvironment_id,
        inference_service_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if servingenvironment_id is not None:
            _path_params["servingenvironmentId"] = servingenvironment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if inference_service_create is not None:
            _body_params = inference_service_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/serving_environments/{servingenvironmentId}/inference_services",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_experiment(
        self,
        experiment_create: Annotated[ExperimentCreate, Field(description="A new `Experiment` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Experiment:
        """Create an Experiment.

        Creates a new instance of an `Experiment`.

        :param experiment_create: A new `Experiment` to be created. (required)
        :type experiment_create: ExperimentCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_serialize(
            experiment_create=experiment_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "Experiment",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_experiment_with_http_info(
        self,
        experiment_create: Annotated[ExperimentCreate, Field(description="A new `Experiment` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Experiment]:
        """Create an Experiment.

        Creates a new instance of an `Experiment`.

        :param experiment_create: A new `Experiment` to be created. (required)
        :type experiment_create: ExperimentCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_serialize(
            experiment_create=experiment_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "Experiment",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_experiment_without_preload_content(
        self,
        experiment_create: Annotated[ExperimentCreate, Field(description="A new `Experiment` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create an Experiment.

        Creates a new instance of an `Experiment`.

        :param experiment_create: A new `Experiment` to be created. (required)
        :type experiment_create: ExperimentCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_serialize(
            experiment_create=experiment_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "Experiment",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_experiment_serialize(
        self,
        experiment_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if experiment_create is not None:
            _body_params = experiment_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/experiments",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_experiment_experiment_run(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        experiment_run: Annotated[ExperimentRun, Field(description="A new `ExperimentRun` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExperimentRun:
        """Create an ExperimentRun in Experiment.

        Creates a new instance of an `ExperimentRun`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param experiment_run: A new `ExperimentRun` to be created. (required)
        :type experiment_run: ExperimentRun
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_experiment_run_serialize(
            experiment_id=experiment_id,
            experiment_run=experiment_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_experiment_experiment_run_with_http_info(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        experiment_run: Annotated[ExperimentRun, Field(description="A new `ExperimentRun` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExperimentRun]:
        """Create an ExperimentRun in Experiment.

        Creates a new instance of an `ExperimentRun`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param experiment_run: A new `ExperimentRun` to be created. (required)
        :type experiment_run: ExperimentRun
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_experiment_run_serialize(
            experiment_id=experiment_id,
            experiment_run=experiment_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_experiment_experiment_run_without_preload_content(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        experiment_run: Annotated[ExperimentRun, Field(description="A new `ExperimentRun` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create an ExperimentRun in Experiment.

        Creates a new instance of an `ExperimentRun`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param experiment_run: A new `ExperimentRun` to be created. (required)
        :type experiment_run: ExperimentRun
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_experiment_run_serialize(
            experiment_id=experiment_id,
            experiment_run=experiment_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_experiment_experiment_run_serialize(
        self,
        experiment_id,
        experiment_run,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experiment_id is not None:
            _path_params["experimentId"] = experiment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if experiment_run is not None:
            _body_params = experiment_run

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/experiments/{experimentId}/experiment_runs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_experiment_run(
        self,
        experiment_run_create: Annotated[
            ExperimentRunCreate, Field(description="A new `ExperimentRun` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExperimentRun:
        """Create an ExperimentRun.

        Creates a new instance of an `ExperimentRun`.

        :param experiment_run_create: A new `ExperimentRun` to be created. (required)
        :type experiment_run_create: ExperimentRunCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_run_serialize(
            experiment_run_create=experiment_run_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "422": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_experiment_run_with_http_info(
        self,
        experiment_run_create: Annotated[
            ExperimentRunCreate, Field(description="A new `ExperimentRun` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExperimentRun]:
        """Create an ExperimentRun.

        Creates a new instance of an `ExperimentRun`.

        :param experiment_run_create: A new `ExperimentRun` to be created. (required)
        :type experiment_run_create: ExperimentRunCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_run_serialize(
            experiment_run_create=experiment_run_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "422": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_experiment_run_without_preload_content(
        self,
        experiment_run_create: Annotated[
            ExperimentRunCreate, Field(description="A new `ExperimentRun` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create an ExperimentRun.

        Creates a new instance of an `ExperimentRun`.

        :param experiment_run_create: A new `ExperimentRun` to be created. (required)
        :type experiment_run_create: ExperimentRunCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_experiment_run_serialize(
            experiment_run_create=experiment_run_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "422": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_experiment_run_serialize(
        self,
        experiment_run_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if experiment_run_create is not None:
            _body_params = experiment_run_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/experiment_runs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_inference_service(
        self,
        inference_service_create: Annotated[
            InferenceServiceCreate, Field(description="A new `InferenceService` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InferenceService:
        """Create a InferenceService.

        Creates a new instance of a `InferenceService`.

        :param inference_service_create: A new `InferenceService` to be created. (required)
        :type inference_service_create: InferenceServiceCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_inference_service_serialize(
            inference_service_create=inference_service_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_inference_service_with_http_info(
        self,
        inference_service_create: Annotated[
            InferenceServiceCreate, Field(description="A new `InferenceService` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InferenceService]:
        """Create a InferenceService.

        Creates a new instance of a `InferenceService`.

        :param inference_service_create: A new `InferenceService` to be created. (required)
        :type inference_service_create: InferenceServiceCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_inference_service_serialize(
            inference_service_create=inference_service_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_inference_service_without_preload_content(
        self,
        inference_service_create: Annotated[
            InferenceServiceCreate, Field(description="A new `InferenceService` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a InferenceService.

        Creates a new instance of a `InferenceService`.

        :param inference_service_create: A new `InferenceService` to be created. (required)
        :type inference_service_create: InferenceServiceCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_inference_service_serialize(
            inference_service_create=inference_service_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_inference_service_serialize(
        self,
        inference_service_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if inference_service_create is not None:
            _body_params = inference_service_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/inference_services",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_inference_service_serve(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        serve_model_create: Annotated[
            ServeModelCreate, Field(description="A new `ServeModel` to be associated with the `InferenceService`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ServeModel:
        """Create a ServeModel action in a InferenceService.

        Creates a new instance of a `ServeModel` associated with `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param serve_model_create: A new `ServeModel` to be associated with the `InferenceService`. (required)
        :type serve_model_create: ServeModelCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_inference_service_serve_serialize(
            inferenceservice_id=inferenceservice_id,
            serve_model_create=serve_model_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ServeModel",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_inference_service_serve_with_http_info(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        serve_model_create: Annotated[
            ServeModelCreate, Field(description="A new `ServeModel` to be associated with the `InferenceService`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ServeModel]:
        """Create a ServeModel action in a InferenceService.

        Creates a new instance of a `ServeModel` associated with `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param serve_model_create: A new `ServeModel` to be associated with the `InferenceService`. (required)
        :type serve_model_create: ServeModelCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_inference_service_serve_serialize(
            inferenceservice_id=inferenceservice_id,
            serve_model_create=serve_model_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ServeModel",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_inference_service_serve_without_preload_content(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        serve_model_create: Annotated[
            ServeModelCreate, Field(description="A new `ServeModel` to be associated with the `InferenceService`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a ServeModel action in a InferenceService.

        Creates a new instance of a `ServeModel` associated with `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param serve_model_create: A new `ServeModel` to be associated with the `InferenceService`. (required)
        :type serve_model_create: ServeModelCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_inference_service_serve_serialize(
            inferenceservice_id=inferenceservice_id,
            serve_model_create=serve_model_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ServeModel",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_inference_service_serve_serialize(
        self,
        inferenceservice_id,
        serve_model_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if inferenceservice_id is not None:
            _path_params["inferenceserviceId"] = inferenceservice_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if serve_model_create is not None:
            _body_params = serve_model_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/inference_services/{inferenceserviceId}/serves",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_model_artifact(
        self,
        model_artifact_create: Annotated[
            ModelArtifactCreate, Field(description="A new `ModelArtifact` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelArtifact:
        """Create a ModelArtifact.

        Creates a new instance of a `ModelArtifact`.

        :param model_artifact_create: A new `ModelArtifact` to be created. (required)
        :type model_artifact_create: ModelArtifactCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_model_artifact_serialize(
            model_artifact_create=model_artifact_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_model_artifact_with_http_info(
        self,
        model_artifact_create: Annotated[
            ModelArtifactCreate, Field(description="A new `ModelArtifact` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelArtifact]:
        """Create a ModelArtifact.

        Creates a new instance of a `ModelArtifact`.

        :param model_artifact_create: A new `ModelArtifact` to be created. (required)
        :type model_artifact_create: ModelArtifactCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_model_artifact_serialize(
            model_artifact_create=model_artifact_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_model_artifact_without_preload_content(
        self,
        model_artifact_create: Annotated[
            ModelArtifactCreate, Field(description="A new `ModelArtifact` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a ModelArtifact.

        Creates a new instance of a `ModelArtifact`.

        :param model_artifact_create: A new `ModelArtifact` to be created. (required)
        :type model_artifact_create: ModelArtifactCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_model_artifact_serialize(
            model_artifact_create=model_artifact_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_model_artifact_serialize(
        self,
        model_artifact_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if model_artifact_create is not None:
            _body_params = model_artifact_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/model_artifacts",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_model_version(
        self,
        model_version_create: Annotated[ModelVersionCreate, Field(description="A new `ModelVersion` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelVersion:
        """Create a ModelVersion.

        Creates a new instance of a `ModelVersion`.

        :param model_version_create: A new `ModelVersion` to be created. (required)
        :type model_version_create: ModelVersionCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_model_version_serialize(
            model_version_create=model_version_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "422": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_model_version_with_http_info(
        self,
        model_version_create: Annotated[ModelVersionCreate, Field(description="A new `ModelVersion` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelVersion]:
        """Create a ModelVersion.

        Creates a new instance of a `ModelVersion`.

        :param model_version_create: A new `ModelVersion` to be created. (required)
        :type model_version_create: ModelVersionCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_model_version_serialize(
            model_version_create=model_version_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "422": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_model_version_without_preload_content(
        self,
        model_version_create: Annotated[ModelVersionCreate, Field(description="A new `ModelVersion` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a ModelVersion.

        Creates a new instance of a `ModelVersion`.

        :param model_version_create: A new `ModelVersion` to be created. (required)
        :type model_version_create: ModelVersionCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_model_version_serialize(
            model_version_create=model_version_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "422": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_model_version_serialize(
        self,
        model_version_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if model_version_create is not None:
            _body_params = model_version_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/model_versions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_registered_model(
        self,
        registered_model_create: Annotated[
            RegisteredModelCreate, Field(description="A new `RegisteredModel` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RegisteredModel:
        """Create a RegisteredModel.

        Creates a new instance of a `RegisteredModel`.

        :param registered_model_create: A new `RegisteredModel` to be created. (required)
        :type registered_model_create: RegisteredModelCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_registered_model_serialize(
            registered_model_create=registered_model_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "RegisteredModel",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_registered_model_with_http_info(
        self,
        registered_model_create: Annotated[
            RegisteredModelCreate, Field(description="A new `RegisteredModel` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RegisteredModel]:
        """Create a RegisteredModel.

        Creates a new instance of a `RegisteredModel`.

        :param registered_model_create: A new `RegisteredModel` to be created. (required)
        :type registered_model_create: RegisteredModelCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_registered_model_serialize(
            registered_model_create=registered_model_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "RegisteredModel",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_registered_model_without_preload_content(
        self,
        registered_model_create: Annotated[
            RegisteredModelCreate, Field(description="A new `RegisteredModel` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a RegisteredModel.

        Creates a new instance of a `RegisteredModel`.

        :param registered_model_create: A new `RegisteredModel` to be created. (required)
        :type registered_model_create: RegisteredModelCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_registered_model_serialize(
            registered_model_create=registered_model_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "RegisteredModel",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_registered_model_serialize(
        self,
        registered_model_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if registered_model_create is not None:
            _body_params = registered_model_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/registered_models",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_registered_model_version(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        model_version: Annotated[ModelVersion, Field(description="A new `ModelVersion` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelVersion:
        """Create a ModelVersion in RegisteredModel.

        Creates a new instance of a `ModelVersion`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param model_version: A new `ModelVersion` to be created. (required)
        :type model_version: ModelVersion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_registered_model_version_serialize(
            registeredmodel_id=registeredmodel_id,
            model_version=model_version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_registered_model_version_with_http_info(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        model_version: Annotated[ModelVersion, Field(description="A new `ModelVersion` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelVersion]:
        """Create a ModelVersion in RegisteredModel.

        Creates a new instance of a `ModelVersion`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param model_version: A new `ModelVersion` to be created. (required)
        :type model_version: ModelVersion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_registered_model_version_serialize(
            registeredmodel_id=registeredmodel_id,
            model_version=model_version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_registered_model_version_without_preload_content(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        model_version: Annotated[ModelVersion, Field(description="A new `ModelVersion` to be created.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a ModelVersion in RegisteredModel.

        Creates a new instance of a `ModelVersion`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param model_version: A new `ModelVersion` to be created. (required)
        :type model_version: ModelVersion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_registered_model_version_serialize(
            registeredmodel_id=registeredmodel_id,
            model_version=model_version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_registered_model_version_serialize(
        self,
        registeredmodel_id,
        model_version,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if registeredmodel_id is not None:
            _path_params["registeredmodelId"] = registeredmodel_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if model_version is not None:
            _body_params = model_version

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/registered_models/{registeredmodelId}/versions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def create_serving_environment(
        self,
        serving_environment_create: Annotated[
            ServingEnvironmentCreate, Field(description="A new `ServingEnvironment` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ServingEnvironment:
        """Create a ServingEnvironment.

        Creates a new instance of a `ServingEnvironment`.

        :param serving_environment_create: A new `ServingEnvironment` to be created. (required)
        :type serving_environment_create: ServingEnvironmentCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_serving_environment_serialize(
            serving_environment_create=serving_environment_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ServingEnvironment",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def create_serving_environment_with_http_info(
        self,
        serving_environment_create: Annotated[
            ServingEnvironmentCreate, Field(description="A new `ServingEnvironment` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ServingEnvironment]:
        """Create a ServingEnvironment.

        Creates a new instance of a `ServingEnvironment`.

        :param serving_environment_create: A new `ServingEnvironment` to be created. (required)
        :type serving_environment_create: ServingEnvironmentCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_serving_environment_serialize(
            serving_environment_create=serving_environment_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ServingEnvironment",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def create_serving_environment_without_preload_content(
        self,
        serving_environment_create: Annotated[
            ServingEnvironmentCreate, Field(description="A new `ServingEnvironment` to be created.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a ServingEnvironment.

        Creates a new instance of a `ServingEnvironment`.

        :param serving_environment_create: A new `ServingEnvironment` to be created. (required)
        :type serving_environment_create: ServingEnvironmentCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._create_serving_environment_serialize(
            serving_environment_create=serving_environment_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "201": "ServingEnvironment",
            "400": "Error",
            "401": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_serving_environment_serialize(
        self,
        serving_environment_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if serving_environment_create is not None:
            _body_params = serving_environment_create

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/serving_environments",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def find_artifact(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Artifact:
        """Get an Artifact that matches search parameters.

        Gets the details of a single instance of an `Artifact` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_artifact_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def find_artifact_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Artifact]:
        """Get an Artifact that matches search parameters.

        Gets the details of a single instance of an `Artifact` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_artifact_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def find_artifact_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get an Artifact that matches search parameters.

        Gets the details of a single instance of an `Artifact` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_artifact_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_artifact_serialize(
        self,
        name,
        external_id,
        parent_resource_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if parent_resource_id is not None:

            _query_params.append(("parentResourceId", parent_resource_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/artifact",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def find_experiment(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Experiment:
        """Get an Experiment that matches search parameters.

        Gets the details of a single instance of an `Experiment` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_experiment_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def find_experiment_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Experiment]:
        """Get an Experiment that matches search parameters.

        Gets the details of a single instance of an `Experiment` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_experiment_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def find_experiment_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get an Experiment that matches search parameters.

        Gets the details of a single instance of an `Experiment` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_experiment_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_experiment_serialize(
        self,
        name,
        external_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiment",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def find_experiment_run(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExperimentRun:
        """Get an ExperimentRun that matches search parameters.

        Gets the details of a single instance of an `ExperimentRun` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_experiment_run_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def find_experiment_run_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExperimentRun]:
        """Get an ExperimentRun that matches search parameters.

        Gets the details of a single instance of an `ExperimentRun` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_experiment_run_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def find_experiment_run_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get an ExperimentRun that matches search parameters.

        Gets the details of a single instance of an `ExperimentRun` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_experiment_run_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_experiment_run_serialize(
        self,
        name,
        external_id,
        parent_resource_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if parent_resource_id is not None:

            _query_params.append(("parentResourceId", parent_resource_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiment_run",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def find_inference_service(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InferenceService:
        """Get an InferenceServices that matches search parameters.

        Gets the details of a single instance of `InferenceService` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_inference_service_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def find_inference_service_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InferenceService]:
        """Get an InferenceServices that matches search parameters.

        Gets the details of a single instance of `InferenceService` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_inference_service_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def find_inference_service_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get an InferenceServices that matches search parameters.

        Gets the details of a single instance of `InferenceService` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_inference_service_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_inference_service_serialize(
        self,
        name,
        external_id,
        parent_resource_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if parent_resource_id is not None:

            _query_params.append(("parentResourceId", parent_resource_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/inference_service",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def find_model_artifact(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelArtifact:
        """Get a ModelArtifact that matches search parameters.

        Gets the details of a single instance of a `ModelArtifact` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_model_artifact_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def find_model_artifact_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelArtifact]:
        """Get a ModelArtifact that matches search parameters.

        Gets the details of a single instance of a `ModelArtifact` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_model_artifact_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def find_model_artifact_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a ModelArtifact that matches search parameters.

        Gets the details of a single instance of a `ModelArtifact` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_model_artifact_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_model_artifact_serialize(
        self,
        name,
        external_id,
        parent_resource_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if parent_resource_id is not None:

            _query_params.append(("parentResourceId", parent_resource_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/model_artifact",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def find_model_version(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelVersion:
        """Get a ModelVersion that matches search parameters.

        Gets the details of a single instance of a `ModelVersion` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_model_version_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def find_model_version_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelVersion]:
        """Get a ModelVersion that matches search parameters.

        Gets the details of a single instance of a `ModelVersion` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_model_version_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def find_model_version_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        parent_resource_id: Annotated[
            Optional[StrictStr], Field(description="ID of the parent resource to use for search.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a ModelVersion that matches search parameters.

        Gets the details of a single instance of a `ModelVersion` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param parent_resource_id: ID of the parent resource to use for search.
        :type parent_resource_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_model_version_serialize(
            name=name,
            external_id=external_id,
            parent_resource_id=parent_resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_model_version_serialize(
        self,
        name,
        external_id,
        parent_resource_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if parent_resource_id is not None:

            _query_params.append(("parentResourceId", parent_resource_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/model_version",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def find_registered_model(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RegisteredModel:
        """Get a RegisteredModel that matches search parameters.

        Gets the details of a single instance of a `RegisteredModel` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_registered_model_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def find_registered_model_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RegisteredModel]:
        """Get a RegisteredModel that matches search parameters.

        Gets the details of a single instance of a `RegisteredModel` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_registered_model_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def find_registered_model_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a RegisteredModel that matches search parameters.

        Gets the details of a single instance of a `RegisteredModel` that matches search parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_registered_model_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_registered_model_serialize(
        self,
        name,
        external_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/registered_model",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def find_serving_environment(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ServingEnvironment:
        """Find ServingEnvironment.

        Finds a `ServingEnvironment` entity that matches query parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_serving_environment_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def find_serving_environment_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ServingEnvironment]:
        """Find ServingEnvironment.

        Finds a `ServingEnvironment` entity that matches query parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_serving_environment_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def find_serving_environment_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Find ServingEnvironment.

        Finds a `ServingEnvironment` entity that matches query parameters.

        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._find_serving_environment_serialize(
            name=name,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_serving_environment_serialize(
        self,
        name,
        external_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/serving_environment",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_artifact(
        self,
        id: Annotated[StrictStr, Field(description="A unique identifier for an `Artifact`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Artifact:
        """Get an Artifact.

        Gets the details of a single instance of an `Artifact`.

        :param id: A unique identifier for an `Artifact`. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_artifact_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_artifact_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="A unique identifier for an `Artifact`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Artifact]:
        """Get an Artifact.

        Gets the details of a single instance of an `Artifact`.

        :param id: A unique identifier for an `Artifact`. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_artifact_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_artifact_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="A unique identifier for an `Artifact`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get an Artifact.

        Gets the details of a single instance of an `Artifact`.

        :param id: A unique identifier for an `Artifact`. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_artifact_serialize(
            id=id, _request_auth=_request_auth, _content_type=_content_type, _headers=_headers, _host_index=_host_index
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_artifact_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/artifacts/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_artifacts(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ArtifactList:
        r"""List All Artifacts.

        Gets a list of all `Artifact` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_artifacts_serialize(
            filter_query=filter_query,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_artifacts_with_http_info(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ArtifactList]:
        r"""List All Artifacts.

        Gets a list of all `Artifact` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_artifacts_serialize(
            filter_query=filter_query,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_artifacts_without_preload_content(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All Artifacts.

        Gets a list of all `Artifact` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_artifacts_serialize(
            filter_query=filter_query,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_artifacts_serialize(
        self,
        filter_query,
        artifact_type,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if artifact_type is not None:

            _query_params.append(("artifactType", artifact_type.value))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/artifacts",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_environment_inference_services(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InferenceServiceList:
        r"""List All ServingEnvironment's InferenceServices.

        Gets a list of all `InferenceService` entities for the `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_environment_inference_services_serialize(
            servingenvironment_id=servingenvironment_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceServiceList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_environment_inference_services_with_http_info(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InferenceServiceList]:
        r"""List All ServingEnvironment's InferenceServices.

        Gets a list of all `InferenceService` entities for the `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_environment_inference_services_serialize(
            servingenvironment_id=servingenvironment_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceServiceList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_environment_inference_services_without_preload_content(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All ServingEnvironment's InferenceServices.

        Gets a list of all `InferenceService` entities for the `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_environment_inference_services_serialize(
            servingenvironment_id=servingenvironment_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceServiceList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_environment_inference_services_serialize(
        self,
        servingenvironment_id,
        filter_query,
        name,
        external_id,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if servingenvironment_id is not None:
            _path_params["servingenvironmentId"] = servingenvironment_id
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/serving_environments/{servingenvironmentId}/inference_services",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_experiment(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Experiment:
        """Get an Experiment.

        Gets the details of a single instance of an `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_serialize(
            experiment_id=experiment_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_experiment_with_http_info(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Experiment]:
        """Get an Experiment.

        Gets the details of a single instance of an `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_serialize(
            experiment_id=experiment_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_experiment_without_preload_content(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get an Experiment.

        Gets the details of a single instance of an `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_serialize(
            experiment_id=experiment_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_experiment_serialize(
        self,
        experiment_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experiment_id is not None:
            _path_params["experimentId"] = experiment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiments/{experimentId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_experiment_experiment_runs(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExperimentRunList:
        r"""List All Experiment's ExperimentRuns.

        Gets a list of all `ExperimentRun` entities for the `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_experiment_runs_serialize(
            experiment_id=experiment_id,
            name=name,
            external_id=external_id,
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRunList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_experiment_experiment_runs_with_http_info(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExperimentRunList]:
        r"""List All Experiment's ExperimentRuns.

        Gets a list of all `ExperimentRun` entities for the `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_experiment_runs_serialize(
            experiment_id=experiment_id,
            name=name,
            external_id=external_id,
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRunList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_experiment_experiment_runs_without_preload_content(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All Experiment's ExperimentRuns.

        Gets a list of all `ExperimentRun` entities for the `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_experiment_runs_serialize(
            experiment_id=experiment_id,
            name=name,
            external_id=external_id,
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRunList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_experiment_experiment_runs_serialize(
        self,
        experiment_id,
        name,
        external_id,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experiment_id is not None:
            _path_params["experimentId"] = experiment_id
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiments/{experimentId}/experiment_runs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_experiment_run(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExperimentRun:
        """Get an ExperimentRun.

        Gets the details of a single instance of an `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_serialize(
            experimentrun_id=experimentrun_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_experiment_run_with_http_info(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExperimentRun]:
        """Get an ExperimentRun.

        Gets the details of a single instance of an `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_serialize(
            experimentrun_id=experimentrun_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_experiment_run_without_preload_content(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get an ExperimentRun.

        Gets the details of a single instance of an `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_serialize(
            experimentrun_id=experimentrun_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_experiment_run_serialize(
        self,
        experimentrun_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experimentrun_id is not None:
            _path_params["experimentrunId"] = experimentrun_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiment_runs/{experimentrunId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_experiment_run_artifacts(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ArtifactList:
        r"""List all artifacts associated with the `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_artifacts_serialize(
            experimentrun_id=experimentrun_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_experiment_run_artifacts_with_http_info(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ArtifactList]:
        r"""List all artifacts associated with the `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_artifacts_serialize(
            experimentrun_id=experimentrun_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_experiment_run_artifacts_without_preload_content(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List all artifacts associated with the `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_artifacts_serialize(
            experimentrun_id=experimentrun_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_experiment_run_artifacts_serialize(
        self,
        experimentrun_id,
        filter_query,
        name,
        external_id,
        artifact_type,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experimentrun_id is not None:
            _path_params["experimentrunId"] = experimentrun_id
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if artifact_type is not None:

            _query_params.append(("artifactType", artifact_type.value))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiment_runs/{experimentrunId}/artifacts",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_experiment_run_metric_history(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        step_ids: Annotated[
            Optional[StrictStr], Field(description="Comma-separated list of step IDs to filter metrics by.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MetricList:
        r"""Get metric history for an ExperimentRun.

        Gets the metric history for an `ExperimentRun` with optional filtering by metric name and step IDs.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param step_ids: Comma-separated list of step IDs to filter metrics by.
        :type step_ids: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_metric_history_serialize(
            experimentrun_id=experimentrun_id,
            filter_query=filter_query,
            name=name,
            step_ids=step_ids,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "MetricList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_experiment_run_metric_history_with_http_info(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        step_ids: Annotated[
            Optional[StrictStr], Field(description="Comma-separated list of step IDs to filter metrics by.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MetricList]:
        r"""Get metric history for an ExperimentRun.

        Gets the metric history for an `ExperimentRun` with optional filtering by metric name and step IDs.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param step_ids: Comma-separated list of step IDs to filter metrics by.
        :type step_ids: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_metric_history_serialize(
            experimentrun_id=experimentrun_id,
            filter_query=filter_query,
            name=name,
            step_ids=step_ids,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "MetricList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_experiment_run_metric_history_without_preload_content(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        step_ids: Annotated[
            Optional[StrictStr], Field(description="Comma-separated list of step IDs to filter metrics by.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""Get metric history for an ExperimentRun.

        Gets the metric history for an `ExperimentRun` with optional filtering by metric name and step IDs.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param step_ids: Comma-separated list of step IDs to filter metrics by.
        :type step_ids: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_run_metric_history_serialize(
            experimentrun_id=experimentrun_id,
            filter_query=filter_query,
            name=name,
            step_ids=step_ids,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "MetricList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_experiment_run_metric_history_serialize(
        self,
        experimentrun_id,
        filter_query,
        name,
        step_ids,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experimentrun_id is not None:
            _path_params["experimentrunId"] = experimentrun_id
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if name is not None:

            _query_params.append(("name", name))

        if step_ids is not None:

            _query_params.append(("stepIds", step_ids))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiment_runs/{experimentrunId}/metric_history",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_experiment_runs(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExperimentRunList:
        r"""List All ExperimentRuns.

        Gets a list of all `ExperimentRun` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_runs_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRunList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_experiment_runs_with_http_info(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExperimentRunList]:
        r"""List All ExperimentRuns.

        Gets a list of all `ExperimentRun` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_runs_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRunList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_experiment_runs_without_preload_content(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All ExperimentRuns.

        Gets a list of all `ExperimentRun` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiment_runs_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRunList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_experiment_runs_serialize(
        self,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiment_runs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_experiments(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExperimentList:
        r"""List All Experiments.

        Gets a list of all `Experiment` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiments_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_experiments_with_http_info(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExperimentList]:
        r"""List All Experiments.

        Gets a list of all `Experiment` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiments_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_experiments_without_preload_content(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All Experiments.

        Gets a list of all `Experiment` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_experiments_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_experiments_serialize(
        self,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/experiments",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_inference_service(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InferenceService:
        """Get a InferenceService.

        Gets the details of a single instance of a `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_inference_service_with_http_info(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InferenceService]:
        """Get a InferenceService.

        Gets the details of a single instance of a `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_inference_service_without_preload_content(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a InferenceService.

        Gets the details of a single instance of a `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_inference_service_serialize(
        self,
        inferenceservice_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if inferenceservice_id is not None:
            _path_params["inferenceserviceId"] = inferenceservice_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/inference_services/{inferenceserviceId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_inference_service_model(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RegisteredModel:
        """Get InferenceService's RegisteredModel.

        Gets the `RegisteredModel` entity for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_model_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_inference_service_model_with_http_info(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RegisteredModel]:
        """Get InferenceService's RegisteredModel.

        Gets the `RegisteredModel` entity for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_model_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_inference_service_model_without_preload_content(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get InferenceService's RegisteredModel.

        Gets the `RegisteredModel` entity for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_model_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_inference_service_model_serialize(
        self,
        inferenceservice_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if inferenceservice_id is not None:
            _path_params["inferenceserviceId"] = inferenceservice_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/inference_services/{inferenceserviceId}/model",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_inference_service_serves(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ServeModelList:
        r"""List All InferenceService's ServeModel actions.

        Gets a list of all `ServeModel` entities for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_serves_serialize(
            inferenceservice_id=inferenceservice_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServeModelList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_inference_service_serves_with_http_info(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ServeModelList]:
        r"""List All InferenceService's ServeModel actions.

        Gets a list of all `ServeModel` entities for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_serves_serialize(
            inferenceservice_id=inferenceservice_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServeModelList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_inference_service_serves_without_preload_content(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All InferenceService's ServeModel actions.

        Gets a list of all `ServeModel` entities for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_serves_serialize(
            inferenceservice_id=inferenceservice_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServeModelList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_inference_service_serves_serialize(
        self,
        inferenceservice_id,
        filter_query,
        name,
        external_id,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if inferenceservice_id is not None:
            _path_params["inferenceserviceId"] = inferenceservice_id
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/inference_services/{inferenceserviceId}/serves",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_inference_service_version(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelVersion:
        """Get InferenceService's ModelVersion.

        Gets the `ModelVersion` entity for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_version_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_inference_service_version_with_http_info(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelVersion]:
        """Get InferenceService's ModelVersion.

        Gets the `ModelVersion` entity for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_version_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_inference_service_version_without_preload_content(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get InferenceService's ModelVersion.

        Gets the `ModelVersion` entity for the `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_service_version_serialize(
            inferenceservice_id=inferenceservice_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_inference_service_version_serialize(
        self,
        inferenceservice_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if inferenceservice_id is not None:
            _path_params["inferenceserviceId"] = inferenceservice_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/inference_services/{inferenceserviceId}/version",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_inference_services(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InferenceServiceList:
        r"""List All InferenceServices.

        Gets a list of all `InferenceService` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_services_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceServiceList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_inference_services_with_http_info(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InferenceServiceList]:
        r"""List All InferenceServices.

        Gets a list of all `InferenceService` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_services_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceServiceList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_inference_services_without_preload_content(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All InferenceServices.

        Gets a list of all `InferenceService` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_inference_services_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceServiceList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_inference_services_serialize(
        self,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/inference_services",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_model_artifact(
        self,
        modelartifact_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelArtifact`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelArtifact:
        """Get a ModelArtifact.

        Gets the details of a single instance of a `ModelArtifact`.

        :param modelartifact_id: A unique identifier for a `ModelArtifact`. (required)
        :type modelartifact_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_artifact_serialize(
            modelartifact_id=modelartifact_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_model_artifact_with_http_info(
        self,
        modelartifact_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelArtifact`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelArtifact]:
        """Get a ModelArtifact.

        Gets the details of a single instance of a `ModelArtifact`.

        :param modelartifact_id: A unique identifier for a `ModelArtifact`. (required)
        :type modelartifact_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_artifact_serialize(
            modelartifact_id=modelartifact_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_model_artifact_without_preload_content(
        self,
        modelartifact_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelArtifact`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a ModelArtifact.

        Gets the details of a single instance of a `ModelArtifact`.

        :param modelartifact_id: A unique identifier for a `ModelArtifact`. (required)
        :type modelartifact_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_artifact_serialize(
            modelartifact_id=modelartifact_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_model_artifact_serialize(
        self,
        modelartifact_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if modelartifact_id is not None:
            _path_params["modelartifactId"] = modelartifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/model_artifacts/{modelartifactId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_model_artifacts(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelArtifactList:
        r"""List All ModelArtifacts.

        Gets a list of all `ModelArtifact` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_artifacts_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifactList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_model_artifacts_with_http_info(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelArtifactList]:
        r"""List All ModelArtifacts.

        Gets a list of all `ModelArtifact` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_artifacts_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifactList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_model_artifacts_without_preload_content(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All ModelArtifacts.

        Gets a list of all `ModelArtifact` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_artifacts_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifactList",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_model_artifacts_serialize(
        self,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/model_artifacts",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_model_version(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelVersion:
        """Get a ModelVersion.

        Gets the details of a single instance of a `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_version_serialize(
            modelversion_id=modelversion_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_model_version_with_http_info(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelVersion]:
        """Get a ModelVersion.

        Gets the details of a single instance of a `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_version_serialize(
            modelversion_id=modelversion_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_model_version_without_preload_content(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a ModelVersion.

        Gets the details of a single instance of a `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_version_serialize(
            modelversion_id=modelversion_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_model_version_serialize(
        self,
        modelversion_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if modelversion_id is not None:
            _path_params["modelversionId"] = modelversion_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/model_versions/{modelversionId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_model_version_artifacts(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ArtifactList:
        r"""List all artifacts associated with the `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_version_artifacts_serialize(
            modelversion_id=modelversion_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_model_version_artifacts_with_http_info(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ArtifactList]:
        r"""List all artifacts associated with the `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_version_artifacts_serialize(
            modelversion_id=modelversion_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_model_version_artifacts_without_preload_content(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        artifact_type: Annotated[
            Optional[ArtifactTypeQueryParam], Field(description="Specifies the artifact type for listing artifacts.")
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List all artifacts associated with the `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param artifact_type: Specifies the artifact type for listing artifacts.
        :type artifact_type: ArtifactTypeQueryParam
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_version_artifacts_serialize(
            modelversion_id=modelversion_id,
            filter_query=filter_query,
            name=name,
            external_id=external_id,
            artifact_type=artifact_type,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ArtifactList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_model_version_artifacts_serialize(
        self,
        modelversion_id,
        filter_query,
        name,
        external_id,
        artifact_type,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if modelversion_id is not None:
            _path_params["modelversionId"] = modelversion_id
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if artifact_type is not None:

            _query_params.append(("artifactType", artifact_type.value))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/model_versions/{modelversionId}/artifacts",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_model_versions(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelVersionList:
        r"""List All ModelVersions.

        Gets a list of all `ModelVersion` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_versions_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersionList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_model_versions_with_http_info(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelVersionList]:
        r"""List All ModelVersions.

        Gets a list of all `ModelVersion` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_versions_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersionList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_model_versions_without_preload_content(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All ModelVersions.

        Gets a list of all `ModelVersion` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_model_versions_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersionList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_model_versions_serialize(
        self,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/model_versions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_registered_model(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RegisteredModel:
        """Get a RegisteredModel.

        Gets the details of a single instance of a `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_model_serialize(
            registeredmodel_id=registeredmodel_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_registered_model_with_http_info(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RegisteredModel]:
        """Get a RegisteredModel.

        Gets the details of a single instance of a `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_model_serialize(
            registeredmodel_id=registeredmodel_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_registered_model_without_preload_content(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a RegisteredModel.

        Gets the details of a single instance of a `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_model_serialize(
            registeredmodel_id=registeredmodel_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_registered_model_serialize(
        self,
        registeredmodel_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if registeredmodel_id is not None:
            _path_params["registeredmodelId"] = registeredmodel_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/registered_models/{registeredmodelId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_registered_model_versions(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelVersionList:
        r"""List All RegisteredModel's ModelVersions.

        Gets a list of all `ModelVersion` entities for the `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_model_versions_serialize(
            registeredmodel_id=registeredmodel_id,
            name=name,
            external_id=external_id,
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersionList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_registered_model_versions_with_http_info(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelVersionList]:
        r"""List All RegisteredModel's ModelVersions.

        Gets a list of all `ModelVersion` entities for the `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_model_versions_serialize(
            registeredmodel_id=registeredmodel_id,
            name=name,
            external_id=external_id,
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersionList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_registered_model_versions_without_preload_content(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        name: Annotated[Optional[StrictStr], Field(description="Name of entity to search.")] = None,
        external_id: Annotated[Optional[StrictStr], Field(description="External ID of entity to search.")] = None,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All RegisteredModel's ModelVersions.

        Gets a list of all `ModelVersion` entities for the `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param name: Name of entity to search.
        :type name: str
        :param external_id: External ID of entity to search.
        :type external_id: str
        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_model_versions_serialize(
            registeredmodel_id=registeredmodel_id,
            name=name,
            external_id=external_id,
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersionList",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_registered_model_versions_serialize(
        self,
        registeredmodel_id,
        name,
        external_id,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if registeredmodel_id is not None:
            _path_params["registeredmodelId"] = registeredmodel_id
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/registered_models/{registeredmodelId}/versions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_registered_models(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RegisteredModelList:
        r"""List All RegisteredModels.

        Gets a list of all `RegisteredModel` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_models_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModelList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_registered_models_with_http_info(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RegisteredModelList]:
        r"""List All RegisteredModels.

        Gets a list of all `RegisteredModel` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_models_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModelList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_registered_models_without_preload_content(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All RegisteredModels.

        Gets a list of all `RegisteredModel` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_registered_models_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModelList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_registered_models_serialize(
        self,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/registered_models",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_serving_environment(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ServingEnvironment:
        """Get a ServingEnvironment.

        Gets the details of a single instance of a `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_serving_environment_serialize(
            servingenvironment_id=servingenvironment_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_serving_environment_with_http_info(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ServingEnvironment]:
        """Get a ServingEnvironment.

        Gets the details of a single instance of a `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_serving_environment_serialize(
            servingenvironment_id=servingenvironment_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_serving_environment_without_preload_content(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a ServingEnvironment.

        Gets the details of a single instance of a `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_serving_environment_serialize(
            servingenvironment_id=servingenvironment_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_serving_environment_serialize(
        self,
        servingenvironment_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if servingenvironment_id is not None:
            _path_params["servingenvironmentId"] = servingenvironment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/serving_environments/{servingenvironmentId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_serving_environments(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ServingEnvironmentList:
        r"""List All ServingEnvironments.

        Gets a list of all `ServingEnvironment` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_serving_environments_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironmentList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_serving_environments_with_http_info(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ServingEnvironmentList]:
        r"""List All ServingEnvironments.

        Gets a list of all `ServingEnvironment` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_serving_environments_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironmentList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_serving_environments_without_preload_content(
        self,
        filter_query: Annotated[
            Optional[StrictStr],
            Field(
                description='A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `"value"` or `\'value\'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = "my-model"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE "%tensorflow%"` - Complex: `(name = "model-a" OR name = "model-b") AND state = "LIVE"` - Custom property: `framework.string_value = "pytorch"` - Escaped property: `` `mlflow.source.type` = "notebook" `` '
            ),
        ] = None,
        page_size: Annotated[Optional[StrictStr], Field(description="Number of entities in each page.")] = None,
        order_by: Annotated[
            Optional[OrderByField], Field(description="Specifies the order by criteria for listing entities.")
        ] = None,
        sort_order: Annotated[
            Optional[SortOrder], Field(description="Specifies the sort order for listing entities, defaults to ASC.")
        ] = None,
        next_page_token: Annotated[
            Optional[StrictStr], Field(description="Token to use to retrieve next page of results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        r"""List All ServingEnvironments.

        Gets a list of all `ServingEnvironment` entities.

        :param filter_query: A SQL-like query string to filter the list of entities. The query supports rich filtering capabilities with automatic type inference.  **Supported Operators:** - Comparison: `=`, `!=`, `<>`, `>`, `<`, `>=`, `<=` - Pattern matching: `LIKE`, `ILIKE` (case-insensitive) - Set membership: `IN` - Logical: `AND`, `OR` - Grouping: `()` for complex expressions  **Data Types:** - Strings: `\"value\"` or `'value'` - Numbers: `42`, `3.14`, `1e-5` - Booleans: `true`, `false` (case-insensitive)  **Property Access:** - Standard properties: `name`, `id`, `state`, `createTimeSinceEpoch` - Custom properties: Any user-defined property name - Escaped properties: Use backticks for special characters: `` `custom-property` `` - Type-specific access: `property.string_value`, `property.double_value`, `property.int_value`, `property.bool_value`  **Examples:** - Basic: `name = \"my-model\"` - Comparison: `accuracy > 0.95` - Pattern: `name LIKE \"%tensorflow%\"` - Complex: `(name = \"model-a\" OR name = \"model-b\") AND state = \"LIVE\"` - Custom property: `framework.string_value = \"pytorch\"` - Escaped property: `` `mlflow.source.type` = \"notebook\" ``
        :type filter_query: str
        :param page_size: Number of entities in each page.
        :type page_size: str
        :param order_by: Specifies the order by criteria for listing entities.
        :type order_by: OrderByField
        :param sort_order: Specifies the sort order for listing entities, defaults to ASC.
        :type sort_order: SortOrder
        :param next_page_token: Token to use to retrieve next page of results.
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._get_serving_environments_serialize(
            filter_query=filter_query,
            page_size=page_size,
            order_by=order_by,
            sort_order=sort_order,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironmentList",
            "401": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_serving_environments_serialize(
        self,
        filter_query,
        page_size,
        order_by,
        sort_order,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter_query is not None:

            _query_params.append(("filterQuery", filter_query))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if order_by is not None:

            _query_params.append(("orderBy", order_by.value))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order.value))

        if next_page_token is not None:

            _query_params.append(("nextPageToken", next_page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/model_registry/v1alpha3/serving_environments",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def update_artifact(
        self,
        id: Annotated[StrictStr, Field(description="A unique identifier for an `Artifact`.")],
        artifact_update: Annotated[ArtifactUpdate, Field(description="Updated `Artifact` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Artifact:
        """Update an Artifact.

        Updates an existing `Artifact`.

        :param id: A unique identifier for an `Artifact`. (required)
        :type id: str
        :param artifact_update: Updated `Artifact` information. (required)
        :type artifact_update: ArtifactUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_artifact_serialize(
            id=id,
            artifact_update=artifact_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def update_artifact_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="A unique identifier for an `Artifact`.")],
        artifact_update: Annotated[ArtifactUpdate, Field(description="Updated `Artifact` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Artifact]:
        """Update an Artifact.

        Updates an existing `Artifact`.

        :param id: A unique identifier for an `Artifact`. (required)
        :type id: str
        :param artifact_update: Updated `Artifact` information. (required)
        :type artifact_update: ArtifactUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_artifact_serialize(
            id=id,
            artifact_update=artifact_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def update_artifact_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="A unique identifier for an `Artifact`.")],
        artifact_update: Annotated[ArtifactUpdate, Field(description="Updated `Artifact` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an Artifact.

        Updates an existing `Artifact`.

        :param id: A unique identifier for an `Artifact`. (required)
        :type id: str
        :param artifact_update: Updated `Artifact` information. (required)
        :type artifact_update: ArtifactUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_artifact_serialize(
            id=id,
            artifact_update=artifact_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_artifact_serialize(
        self,
        id,
        artifact_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if artifact_update is not None:
            _body_params = artifact_update

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/model_registry/v1alpha3/artifacts/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def update_experiment(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        experiment_update: Annotated[ExperimentUpdate, Field(description="Updated `Experiment` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Experiment:
        """Update an Experiment.

        Updates an existing `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param experiment_update: Updated `Experiment` information. (required)
        :type experiment_update: ExperimentUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_experiment_serialize(
            experiment_id=experiment_id,
            experiment_update=experiment_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def update_experiment_with_http_info(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        experiment_update: Annotated[ExperimentUpdate, Field(description="Updated `Experiment` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Experiment]:
        """Update an Experiment.

        Updates an existing `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param experiment_update: Updated `Experiment` information. (required)
        :type experiment_update: ExperimentUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_experiment_serialize(
            experiment_id=experiment_id,
            experiment_update=experiment_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def update_experiment_without_preload_content(
        self,
        experiment_id: Annotated[StrictStr, Field(description="A unique identifier for an `Experiment`.")],
        experiment_update: Annotated[ExperimentUpdate, Field(description="Updated `Experiment` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an Experiment.

        Updates an existing `Experiment`.

        :param experiment_id: A unique identifier for an `Experiment`. (required)
        :type experiment_id: str
        :param experiment_update: Updated `Experiment` information. (required)
        :type experiment_update: ExperimentUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_experiment_serialize(
            experiment_id=experiment_id,
            experiment_update=experiment_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Experiment",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_experiment_serialize(
        self,
        experiment_id,
        experiment_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experiment_id is not None:
            _path_params["experimentId"] = experiment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if experiment_update is not None:
            _body_params = experiment_update

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/model_registry/v1alpha3/experiments/{experimentId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def update_experiment_run(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        experiment_run_update: Annotated[
            ExperimentRunUpdate, Field(description="Updated `ExperimentRun` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExperimentRun:
        """Update an ExperimentRun.

        Updates an existing `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param experiment_run_update: Updated `ExperimentRun` information. (required)
        :type experiment_run_update: ExperimentRunUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_experiment_run_serialize(
            experimentrun_id=experimentrun_id,
            experiment_run_update=experiment_run_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def update_experiment_run_with_http_info(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        experiment_run_update: Annotated[
            ExperimentRunUpdate, Field(description="Updated `ExperimentRun` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExperimentRun]:
        """Update an ExperimentRun.

        Updates an existing `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param experiment_run_update: Updated `ExperimentRun` information. (required)
        :type experiment_run_update: ExperimentRunUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_experiment_run_serialize(
            experimentrun_id=experimentrun_id,
            experiment_run_update=experiment_run_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def update_experiment_run_without_preload_content(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        experiment_run_update: Annotated[
            ExperimentRunUpdate, Field(description="Updated `ExperimentRun` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an ExperimentRun.

        Updates an existing `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param experiment_run_update: Updated `ExperimentRun` information. (required)
        :type experiment_run_update: ExperimentRunUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_experiment_run_serialize(
            experimentrun_id=experimentrun_id,
            experiment_run_update=experiment_run_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ExperimentRun",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_experiment_run_serialize(
        self,
        experimentrun_id,
        experiment_run_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experimentrun_id is not None:
            _path_params["experimentrunId"] = experimentrun_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if experiment_run_update is not None:
            _body_params = experiment_run_update

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/model_registry/v1alpha3/experiment_runs/{experimentrunId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def update_inference_service(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        inference_service_update: Annotated[
            InferenceServiceUpdate, Field(description="Updated `InferenceService` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InferenceService:
        """Update a InferenceService.

        Updates an existing `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param inference_service_update: Updated `InferenceService` information. (required)
        :type inference_service_update: InferenceServiceUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_inference_service_serialize(
            inferenceservice_id=inferenceservice_id,
            inference_service_update=inference_service_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def update_inference_service_with_http_info(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        inference_service_update: Annotated[
            InferenceServiceUpdate, Field(description="Updated `InferenceService` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InferenceService]:
        """Update a InferenceService.

        Updates an existing `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param inference_service_update: Updated `InferenceService` information. (required)
        :type inference_service_update: InferenceServiceUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_inference_service_serialize(
            inferenceservice_id=inferenceservice_id,
            inference_service_update=inference_service_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def update_inference_service_without_preload_content(
        self,
        inferenceservice_id: Annotated[StrictStr, Field(description="A unique identifier for a `InferenceService`.")],
        inference_service_update: Annotated[
            InferenceServiceUpdate, Field(description="Updated `InferenceService` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a InferenceService.

        Updates an existing `InferenceService`.

        :param inferenceservice_id: A unique identifier for a `InferenceService`. (required)
        :type inferenceservice_id: str
        :param inference_service_update: Updated `InferenceService` information. (required)
        :type inference_service_update: InferenceServiceUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_inference_service_serialize(
            inferenceservice_id=inferenceservice_id,
            inference_service_update=inference_service_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "InferenceService",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_inference_service_serialize(
        self,
        inferenceservice_id,
        inference_service_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if inferenceservice_id is not None:
            _path_params["inferenceserviceId"] = inferenceservice_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if inference_service_update is not None:
            _body_params = inference_service_update

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/model_registry/v1alpha3/inference_services/{inferenceserviceId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def update_model_artifact(
        self,
        modelartifact_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelArtifact`.")],
        model_artifact_update: Annotated[
            ModelArtifactUpdate, Field(description="Updated `ModelArtifact` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelArtifact:
        """Update a ModelArtifact.

        Updates an existing `ModelArtifact`.

        :param modelartifact_id: A unique identifier for a `ModelArtifact`. (required)
        :type modelartifact_id: str
        :param model_artifact_update: Updated `ModelArtifact` information. (required)
        :type model_artifact_update: ModelArtifactUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_model_artifact_serialize(
            modelartifact_id=modelartifact_id,
            model_artifact_update=model_artifact_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def update_model_artifact_with_http_info(
        self,
        modelartifact_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelArtifact`.")],
        model_artifact_update: Annotated[
            ModelArtifactUpdate, Field(description="Updated `ModelArtifact` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelArtifact]:
        """Update a ModelArtifact.

        Updates an existing `ModelArtifact`.

        :param modelartifact_id: A unique identifier for a `ModelArtifact`. (required)
        :type modelartifact_id: str
        :param model_artifact_update: Updated `ModelArtifact` information. (required)
        :type model_artifact_update: ModelArtifactUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_model_artifact_serialize(
            modelartifact_id=modelartifact_id,
            model_artifact_update=model_artifact_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def update_model_artifact_without_preload_content(
        self,
        modelartifact_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelArtifact`.")],
        model_artifact_update: Annotated[
            ModelArtifactUpdate, Field(description="Updated `ModelArtifact` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a ModelArtifact.

        Updates an existing `ModelArtifact`.

        :param modelartifact_id: A unique identifier for a `ModelArtifact`. (required)
        :type modelartifact_id: str
        :param model_artifact_update: Updated `ModelArtifact` information. (required)
        :type model_artifact_update: ModelArtifactUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_model_artifact_serialize(
            modelartifact_id=modelartifact_id,
            model_artifact_update=model_artifact_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelArtifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_model_artifact_serialize(
        self,
        modelartifact_id,
        model_artifact_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if modelartifact_id is not None:
            _path_params["modelartifactId"] = modelartifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if model_artifact_update is not None:
            _body_params = model_artifact_update

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/model_registry/v1alpha3/model_artifacts/{modelartifactId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def update_model_version(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        model_version_update: Annotated[ModelVersionUpdate, Field(description="Updated `ModelVersion` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModelVersion:
        """Update a ModelVersion.

        Updates an existing `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param model_version_update: Updated `ModelVersion` information. (required)
        :type model_version_update: ModelVersionUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_model_version_serialize(
            modelversion_id=modelversion_id,
            model_version_update=model_version_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def update_model_version_with_http_info(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        model_version_update: Annotated[ModelVersionUpdate, Field(description="Updated `ModelVersion` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModelVersion]:
        """Update a ModelVersion.

        Updates an existing `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param model_version_update: Updated `ModelVersion` information. (required)
        :type model_version_update: ModelVersionUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_model_version_serialize(
            modelversion_id=modelversion_id,
            model_version_update=model_version_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def update_model_version_without_preload_content(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        model_version_update: Annotated[ModelVersionUpdate, Field(description="Updated `ModelVersion` information.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a ModelVersion.

        Updates an existing `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param model_version_update: Updated `ModelVersion` information. (required)
        :type model_version_update: ModelVersionUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_model_version_serialize(
            modelversion_id=modelversion_id,
            model_version_update=model_version_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ModelVersion",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_model_version_serialize(
        self,
        modelversion_id,
        model_version_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if modelversion_id is not None:
            _path_params["modelversionId"] = modelversion_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if model_version_update is not None:
            _body_params = model_version_update

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/model_registry/v1alpha3/model_versions/{modelversionId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def update_registered_model(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        registered_model_update: Annotated[
            RegisteredModelUpdate, Field(description="Updated `RegisteredModel` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RegisteredModel:
        """Update a RegisteredModel.

        Updates an existing `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param registered_model_update: Updated `RegisteredModel` information. (required)
        :type registered_model_update: RegisteredModelUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_registered_model_serialize(
            registeredmodel_id=registeredmodel_id,
            registered_model_update=registered_model_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def update_registered_model_with_http_info(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        registered_model_update: Annotated[
            RegisteredModelUpdate, Field(description="Updated `RegisteredModel` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RegisteredModel]:
        """Update a RegisteredModel.

        Updates an existing `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param registered_model_update: Updated `RegisteredModel` information. (required)
        :type registered_model_update: RegisteredModelUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_registered_model_serialize(
            registeredmodel_id=registeredmodel_id,
            registered_model_update=registered_model_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def update_registered_model_without_preload_content(
        self,
        registeredmodel_id: Annotated[StrictStr, Field(description="A unique identifier for a `RegisteredModel`.")],
        registered_model_update: Annotated[
            RegisteredModelUpdate, Field(description="Updated `RegisteredModel` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a RegisteredModel.

        Updates an existing `RegisteredModel`.

        :param registeredmodel_id: A unique identifier for a `RegisteredModel`. (required)
        :type registeredmodel_id: str
        :param registered_model_update: Updated `RegisteredModel` information. (required)
        :type registered_model_update: RegisteredModelUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_registered_model_serialize(
            registeredmodel_id=registeredmodel_id,
            registered_model_update=registered_model_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "RegisteredModel",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_registered_model_serialize(
        self,
        registeredmodel_id,
        registered_model_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if registeredmodel_id is not None:
            _path_params["registeredmodelId"] = registeredmodel_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if registered_model_update is not None:
            _body_params = registered_model_update

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/model_registry/v1alpha3/registered_models/{registeredmodelId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def update_serving_environment(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        serving_environment_update: Annotated[
            ServingEnvironmentUpdate, Field(description="Updated `ServingEnvironment` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ServingEnvironment:
        """Update a ServingEnvironment.

        Updates an existing `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param serving_environment_update: Updated `ServingEnvironment` information. (required)
        :type serving_environment_update: ServingEnvironmentUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_serving_environment_serialize(
            servingenvironment_id=servingenvironment_id,
            serving_environment_update=serving_environment_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def update_serving_environment_with_http_info(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        serving_environment_update: Annotated[
            ServingEnvironmentUpdate, Field(description="Updated `ServingEnvironment` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ServingEnvironment]:
        """Update a ServingEnvironment.

        Updates an existing `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param serving_environment_update: Updated `ServingEnvironment` information. (required)
        :type serving_environment_update: ServingEnvironmentUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_serving_environment_serialize(
            servingenvironment_id=servingenvironment_id,
            serving_environment_update=serving_environment_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def update_serving_environment_without_preload_content(
        self,
        servingenvironment_id: Annotated[
            StrictStr, Field(description="A unique identifier for a `ServingEnvironment`.")
        ],
        serving_environment_update: Annotated[
            ServingEnvironmentUpdate, Field(description="Updated `ServingEnvironment` information.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a ServingEnvironment.

        Updates an existing `ServingEnvironment`.

        :param servingenvironment_id: A unique identifier for a `ServingEnvironment`. (required)
        :type servingenvironment_id: str
        :param serving_environment_update: Updated `ServingEnvironment` information. (required)
        :type serving_environment_update: ServingEnvironmentUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._update_serving_environment_serialize(
            servingenvironment_id=servingenvironment_id,
            serving_environment_update=serving_environment_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "ServingEnvironment",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_serving_environment_serialize(
        self,
        servingenvironment_id,
        serving_environment_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if servingenvironment_id is not None:
            _path_params["servingenvironmentId"] = servingenvironment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if serving_environment_update is not None:
            _body_params = serving_environment_update

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/model_registry/v1alpha3/serving_environments/{servingenvironmentId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def upsert_experiment_run_artifact(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        artifact: Annotated[
            Artifact, Field(description="A new or existing `Artifact` to be associated with the `ExperimentRun`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Artifact:
        """Upsert an Artifact in an ExperimentRun.

        Creates a new instance of an Artifact if needed and associates it with `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param artifact: A new or existing `Artifact` to be associated with the `ExperimentRun`. (required)
        :type artifact: Artifact
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._upsert_experiment_run_artifact_serialize(
            experimentrun_id=experimentrun_id,
            artifact=artifact,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def upsert_experiment_run_artifact_with_http_info(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        artifact: Annotated[
            Artifact, Field(description="A new or existing `Artifact` to be associated with the `ExperimentRun`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Artifact]:
        """Upsert an Artifact in an ExperimentRun.

        Creates a new instance of an Artifact if needed and associates it with `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param artifact: A new or existing `Artifact` to be associated with the `ExperimentRun`. (required)
        :type artifact: Artifact
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._upsert_experiment_run_artifact_serialize(
            experimentrun_id=experimentrun_id,
            artifact=artifact,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def upsert_experiment_run_artifact_without_preload_content(
        self,
        experimentrun_id: Annotated[StrictStr, Field(description="A unique identifier for an `ExperimentRun`.")],
        artifact: Annotated[
            Artifact, Field(description="A new or existing `Artifact` to be associated with the `ExperimentRun`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Upsert an Artifact in an ExperimentRun.

        Creates a new instance of an Artifact if needed and associates it with `ExperimentRun`.

        :param experimentrun_id: A unique identifier for an `ExperimentRun`. (required)
        :type experimentrun_id: str
        :param artifact: A new or existing `Artifact` to be associated with the `ExperimentRun`. (required)
        :type artifact: Artifact
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._upsert_experiment_run_artifact_serialize(
            experimentrun_id=experimentrun_id,
            artifact=artifact,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _upsert_experiment_run_artifact_serialize(
        self,
        experimentrun_id,
        artifact,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if experimentrun_id is not None:
            _path_params["experimentrunId"] = experimentrun_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if artifact is not None:
            _body_params = artifact

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/experiment_runs/{experimentrunId}/artifacts",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def upsert_model_version_artifact(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        artifact: Annotated[
            Artifact, Field(description="A new or existing `Artifact` to be associated with the `ModelVersion`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Artifact:
        """Upsert an Artifact in a ModelVersion.

        Creates a new instance of an Artifact if needed and associates it with `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param artifact: A new or existing `Artifact` to be associated with the `ModelVersion`. (required)
        :type artifact: Artifact
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._upsert_model_version_artifact_serialize(
            modelversion_id=modelversion_id,
            artifact=artifact,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def upsert_model_version_artifact_with_http_info(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        artifact: Annotated[
            Artifact, Field(description="A new or existing `Artifact` to be associated with the `ModelVersion`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Artifact]:
        """Upsert an Artifact in a ModelVersion.

        Creates a new instance of an Artifact if needed and associates it with `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param artifact: A new or existing `Artifact` to be associated with the `ModelVersion`. (required)
        :type artifact: Artifact
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._upsert_model_version_artifact_serialize(
            modelversion_id=modelversion_id,
            artifact=artifact,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def upsert_model_version_artifact_without_preload_content(
        self,
        modelversion_id: Annotated[StrictStr, Field(description="A unique identifier for a `ModelVersion`.")],
        artifact: Annotated[
            Artifact, Field(description="A new or existing `Artifact` to be associated with the `ModelVersion`.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Upsert an Artifact in a ModelVersion.

        Creates a new instance of an Artifact if needed and associates it with `ModelVersion`.

        :param modelversion_id: A unique identifier for a `ModelVersion`. (required)
        :type modelversion_id: str
        :param artifact: A new or existing `Artifact` to be associated with the `ModelVersion`. (required)
        :type artifact: Artifact
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501
        _param = self._upsert_model_version_artifact_serialize(
            modelversion_id=modelversion_id,
            artifact=artifact,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, Optional[str]] = {
            "200": "Artifact",
            "201": "Artifact",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "409": "Error",
            "500": "Error",
            "503": "Error",
        }
        response_data = await self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _upsert_model_version_artifact_serialize(
        self,
        modelversion_id,
        artifact,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, Optional[str]] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if modelversion_id is not None:
            _path_params["modelversionId"] = modelversion_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if artifact is not None:
            _body_params = artifact

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: list[str] = ["Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/model_registry/v1alpha3/model_versions/{modelversionId}/artifacts",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
