"""Model Registry REST API.

REST API for Model Registry to create and manage ML model metadata

The version of the OpenAPI document: v1alpha3
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
from enum import Enum

from typing_extensions import Self


class ArtifactState(str, Enum):
    """- PENDING: A state indicating that the artifact may exist.  - LIVE: A state indicating that the artifact should exist, unless something external to the system deletes it.  - MARKED_FOR_DELETION: A state indicating that the artifact should be deleted.  - DELETED: A state indicating that the artifact has been deleted.  - ABANDONED: A state indicating that the artifact has been abandoned, which may be due to a failed or cancelled execution.  - REFERENCE: A state indicating that the artifact is a reference artifact. At execution start time, the orchestrator produces an output artifact for each output key with state PENDING. However, for an intermediate artifact, this first artifact's state will be REFERENCE. Intermediate artifacts emitted during a component's execution will copy the REFERENCE artifact's attributes. At the end of an execution, the artifact state should remain REFERENCE instead of being changed to LIVE.  See also: ml-metadata Artifact.State."""

    """
    allowed enum values
    """
    UNKNOWN = "UNKNOWN"
    PENDING = "PENDING"
    LIVE = "LIVE"
    MARKED_FOR_DELETION = "MARKED_FOR_DELETION"
    DELETED = "DELETED"
    ABANDONED = "ABANDONED"
    REFERENCE = "REFERENCE"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ArtifactState from a JSON string."""
        return cls(json.loads(json_str))
