"""Model Registry REST API.

REST API for Model Registry to create and manage ML model metadata

The version of the OpenAPI document: v1alpha3
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any

from pydantic import (
    BaseModel,
    ConfigDict,
    ValidationError,
    field_validator,
)
from typing_extensions import Self

from mr_openapi.models.data_set_update import DataSetUpdate
from mr_openapi.models.doc_artifact_update import DocArtifactUpdate
from mr_openapi.models.metric_update import MetricUpdate
from mr_openapi.models.model_artifact_update import ModelArtifactUpdate
from mr_openapi.models.parameter_update import ParameterUpdate

ARTIFACTUPDATE_ONE_OF_SCHEMAS = [
    "DataSetUpdate",
    "DocArtifactUpdate",
    "MetricUpdate",
    "ModelArtifactUpdate",
    "ParameterUpdate",
]


class ArtifactUpdate(BaseModel):
    """An Artifact to be updated."""

    # data type: ModelArtifactUpdate
    oneof_schema_1_validator: ModelArtifactUpdate | None = None
    # data type: DocArtifactUpdate
    oneof_schema_2_validator: DocArtifactUpdate | None = None
    # data type: DataSetUpdate
    oneof_schema_3_validator: DataSetUpdate | None = None
    # data type: MetricUpdate
    oneof_schema_4_validator: MetricUpdate | None = None
    # data type: ParameterUpdate
    oneof_schema_5_validator: ParameterUpdate | None = None
    actual_instance: (
        DataSetUpdate | DocArtifactUpdate | MetricUpdate | ModelArtifactUpdate | ParameterUpdate | None
    ) = None
    one_of_schemas: set[str] = {
        "DataSetUpdate",
        "DocArtifactUpdate",
        "MetricUpdate",
        "ModelArtifactUpdate",
        "ParameterUpdate",
    }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    discriminator_value_class_map: dict[str, str] = {}

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                msg = "If a position argument is used, only 1 is allowed to set `actual_instance`"
                raise ValueError(msg)
            if kwargs:
                msg = "If a position argument is used, keyword arguments cannot be used."
                raise ValueError(msg)
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        ArtifactUpdate.model_construct()
        error_messages = []
        match = 0
        # validate data type: ModelArtifactUpdate
        if not isinstance(v, ModelArtifactUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ModelArtifactUpdate`")
        else:
            match += 1
        # validate data type: DocArtifactUpdate
        if not isinstance(v, DocArtifactUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DocArtifactUpdate`")
        else:
            match += 1
        # validate data type: DataSetUpdate
        if not isinstance(v, DataSetUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DataSetUpdate`")
        else:
            match += 1
        # validate data type: MetricUpdate
        if not isinstance(v, MetricUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MetricUpdate`")
        else:
            match += 1
        # validate data type: ParameterUpdate
        if not isinstance(v, ParameterUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ParameterUpdate`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in ArtifactUpdate with oneOf schemas: DataSetUpdate, DocArtifactUpdate, MetricUpdate, ModelArtifactUpdate, ParameterUpdate. Details: "
                + ", ".join(error_messages)
            )
        if match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in ArtifactUpdate with oneOf schemas: DataSetUpdate, DocArtifactUpdate, MetricUpdate, ModelArtifactUpdate, ParameterUpdate. Details: "
                + ", ".join(error_messages)
            )
        return v

    @classmethod
    def from_dict(cls, obj: str | dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string."""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("artifactType")
        if not _data_type:
            msg = "Failed to lookup data type from the field `artifactType` in the input."
            raise ValueError(msg)

        # check if data type is `DataSetUpdate`
        if _data_type == "dataset-artifact":
            instance.actual_instance = DataSetUpdate.from_json(json_str)
            return instance

        # check if data type is `DocArtifactUpdate`
        if _data_type == "doc-artifact":
            instance.actual_instance = DocArtifactUpdate.from_json(json_str)
            return instance

        # check if data type is `MetricUpdate`
        if _data_type == "metric":
            instance.actual_instance = MetricUpdate.from_json(json_str)
            return instance

        # check if data type is `ModelArtifactUpdate`
        if _data_type == "model-artifact":
            instance.actual_instance = ModelArtifactUpdate.from_json(json_str)
            return instance

        # check if data type is `ParameterUpdate`
        if _data_type == "parameter":
            instance.actual_instance = ParameterUpdate.from_json(json_str)
            return instance

        # check if data type is `DataSetUpdate`
        if _data_type == "DataSetUpdate":
            instance.actual_instance = DataSetUpdate.from_json(json_str)
            return instance

        # check if data type is `DocArtifactUpdate`
        if _data_type == "DocArtifactUpdate":
            instance.actual_instance = DocArtifactUpdate.from_json(json_str)
            return instance

        # check if data type is `MetricUpdate`
        if _data_type == "MetricUpdate":
            instance.actual_instance = MetricUpdate.from_json(json_str)
            return instance

        # check if data type is `ModelArtifactUpdate`
        if _data_type == "ModelArtifactUpdate":
            instance.actual_instance = ModelArtifactUpdate.from_json(json_str)
            return instance

        # check if data type is `ParameterUpdate`
        if _data_type == "ParameterUpdate":
            instance.actual_instance = ParameterUpdate.from_json(json_str)
            return instance

        # deserialize data into ModelArtifactUpdate
        try:
            instance.actual_instance = ModelArtifactUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DocArtifactUpdate
        try:
            instance.actual_instance = DocArtifactUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DataSetUpdate
        try:
            instance.actual_instance = DataSetUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MetricUpdate
        try:
            instance.actual_instance = MetricUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ParameterUpdate
        try:
            instance.actual_instance = ParameterUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into ArtifactUpdate with oneOf schemas: DataSetUpdate, DocArtifactUpdate, MetricUpdate, ModelArtifactUpdate, ParameterUpdate. Details: "
                + ", ".join(error_messages)
            )
        if match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into ArtifactUpdate with oneOf schemas: DataSetUpdate, DocArtifactUpdate, MetricUpdate, ModelArtifactUpdate, ParameterUpdate. Details: "
                + ", ".join(error_messages)
            )
        return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance."""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> (
        dict[str, Any]
        | DataSetUpdate
        | DocArtifactUpdate
        | MetricUpdate
        | ModelArtifactUpdate
        | ParameterUpdate
        | None
    ):
        """Returns the dict representation of the actual instance."""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        # primitive type
        return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance."""
        return pprint.pformat(self.model_dump())
