# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPluginsCommunityResult',
    'AwaitableGetPluginsCommunityResult',
    'get_plugins_community',
    'get_plugins_community_output',
]

@pulumi.output_type
class GetPluginsCommunityResult:
    """
    A collection of values returned by getPluginsCommunity.
    """
    def __init__(__self__, id=None, instance_id=None, plugins=None, sleep=None, timeout=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, int):
            raise TypeError("Expected argument 'instance_id' to be a int")
        pulumi.set(__self__, "instance_id", instance_id)
        if plugins and not isinstance(plugins, list):
            raise TypeError("Expected argument 'plugins' to be a list")
        pulumi.set(__self__, "plugins", plugins)
        if sleep and not isinstance(sleep, int):
            raise TypeError("Expected argument 'sleep' to be a int")
        pulumi.set(__self__, "sleep", sleep)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> int:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def plugins(self) -> Sequence['outputs.GetPluginsCommunityPluginResult']:
        return pulumi.get(self, "plugins")

    @property
    @pulumi.getter
    def sleep(self) -> Optional[int]:
        return pulumi.get(self, "sleep")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        return pulumi.get(self, "timeout")


class AwaitableGetPluginsCommunityResult(GetPluginsCommunityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPluginsCommunityResult(
            id=self.id,
            instance_id=self.instance_id,
            plugins=self.plugins,
            sleep=self.sleep,
            timeout=self.timeout)


def get_plugins_community(instance_id: Optional[int] = None,
                          sleep: Optional[int] = None,
                          timeout: Optional[int] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPluginsCommunityResult:
    """
    Use this data source to retrieve information about available community plugins for the CloudAMQP instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    communit_plugins = cloudamqp.get_plugins_community(instance_id=instance["id"])
    ```

    ## Attributes reference

    All attributes reference are computed

    * `id`      - The identifier for this resource.
    * `plugins` - An array of community plugins. Each `plugins` block consists of the fields documented below.
    * `sleep` - (Optional) Configurable sleep time (seconds) for retries when requesting information
      about community plugins. Default set to 10 seconds. *Available from v1.29.0*
    * `timeout` - (Optional) - Configurable timeout time (seconds) for retries when requesting
      information about community plugins. Default set to 1800 seconds. *Available from v1.29.0*

    ***

    The `plugins` block consists of

    * `name`        - The type of the recipient.
    * `require`     - Min. required Rabbit MQ version to be used.
    * `description` - Description of what the plugin does.

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.


    :param int instance_id: The CloudAMQP instance identifier.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['sleep'] = sleep
    __args__['timeout'] = timeout
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudamqp:index/getPluginsCommunity:getPluginsCommunity', __args__, opts=opts, typ=GetPluginsCommunityResult).value

    return AwaitableGetPluginsCommunityResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        plugins=pulumi.get(__ret__, 'plugins'),
        sleep=pulumi.get(__ret__, 'sleep'),
        timeout=pulumi.get(__ret__, 'timeout'))
def get_plugins_community_output(instance_id: Optional[pulumi.Input[int]] = None,
                                 sleep: Optional[pulumi.Input[Optional[int]]] = None,
                                 timeout: Optional[pulumi.Input[Optional[int]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPluginsCommunityResult]:
    """
    Use this data source to retrieve information about available community plugins for the CloudAMQP instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    communit_plugins = cloudamqp.get_plugins_community(instance_id=instance["id"])
    ```

    ## Attributes reference

    All attributes reference are computed

    * `id`      - The identifier for this resource.
    * `plugins` - An array of community plugins. Each `plugins` block consists of the fields documented below.
    * `sleep` - (Optional) Configurable sleep time (seconds) for retries when requesting information
      about community plugins. Default set to 10 seconds. *Available from v1.29.0*
    * `timeout` - (Optional) - Configurable timeout time (seconds) for retries when requesting
      information about community plugins. Default set to 1800 seconds. *Available from v1.29.0*

    ***

    The `plugins` block consists of

    * `name`        - The type of the recipient.
    * `require`     - Min. required Rabbit MQ version to be used.
    * `description` - Description of what the plugin does.

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.


    :param int instance_id: The CloudAMQP instance identifier.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['sleep'] = sleep
    __args__['timeout'] = timeout
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudamqp:index/getPluginsCommunity:getPluginsCommunity', __args__, opts=opts, typ=GetPluginsCommunityResult)
    return __ret__.apply(lambda __response__: GetPluginsCommunityResult(
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        plugins=pulumi.get(__response__, 'plugins'),
        sleep=pulumi.get(__response__, 'sleep'),
        timeout=pulumi.get(__response__, 'timeout')))
