# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UpgradeLavinmqArgs', 'UpgradeLavinmq']

@pulumi.input_type
class UpgradeLavinmqArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[int],
                 new_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a UpgradeLavinmq resource.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        :param pulumi.Input[str] new_version: The new version to upgrade to
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if new_version is not None:
            pulumi.set(__self__, "new_version", new_version)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[int]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="newVersion")
    def new_version(self) -> Optional[pulumi.Input[str]]:
        """
        The new version to upgrade to
        """
        return pulumi.get(self, "new_version")

    @new_version.setter
    def new_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_version", value)


@pulumi.input_type
class _UpgradeLavinmqState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 new_version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UpgradeLavinmq resources.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        :param pulumi.Input[str] new_version: The new version to upgrade to
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if new_version is not None:
            pulumi.set(__self__, "new_version", new_version)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[int]]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="newVersion")
    def new_version(self) -> Optional[pulumi.Input[str]]:
        """
        The new version to upgrade to
        """
        return pulumi.get(self, "new_version")

    @new_version.setter
    def new_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_version", value)


class UpgradeLavinmq(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 new_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource allows you to upgrade LavinMQ version.

        See below example usage.

        Only available for dedicated subscription plans running ***LavinMQ***.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Upgrade LavinMQ, specify which version to upgrade to, from v1.32.0</i>
            </b>
          </summary>

        Specify the version to upgrade to. List available upgradable versions, use [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html#get-available-versions).

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="lavinmq-version-upgrade-test",
            plan="lynx-1",
            region="amazon-web-services::us-west-1")
        upgrade = cloudamqp.UpgradeLavinmq("upgrade",
            instance_id=instance.id,
            new_version="1.3.1")
        ```

        </details>

        ## Important Upgrade Information

        > - All single node upgrades will require some downtime since LavinMQ needs a restart.
        > - Auto delete queues (queues that are marked AD) will be deleted during the update.

        ## Import

        Not possible to import this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        :param pulumi.Input[str] new_version: The new version to upgrade to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UpgradeLavinmqArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to upgrade LavinMQ version.

        See below example usage.

        Only available for dedicated subscription plans running ***LavinMQ***.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Upgrade LavinMQ, specify which version to upgrade to, from v1.32.0</i>
            </b>
          </summary>

        Specify the version to upgrade to. List available upgradable versions, use [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html#get-available-versions).

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="lavinmq-version-upgrade-test",
            plan="lynx-1",
            region="amazon-web-services::us-west-1")
        upgrade = cloudamqp.UpgradeLavinmq("upgrade",
            instance_id=instance.id,
            new_version="1.3.1")
        ```

        </details>

        ## Important Upgrade Information

        > - All single node upgrades will require some downtime since LavinMQ needs a restart.
        > - Auto delete queues (queues that are marked AD) will be deleted during the update.

        ## Import

        Not possible to import this resource.

        :param str resource_name: The name of the resource.
        :param UpgradeLavinmqArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UpgradeLavinmqArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 new_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UpgradeLavinmqArgs.__new__(UpgradeLavinmqArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["new_version"] = new_version
        super(UpgradeLavinmq, __self__).__init__(
            'cloudamqp:index/upgradeLavinmq:UpgradeLavinmq',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[int]] = None,
            new_version: Optional[pulumi.Input[str]] = None) -> 'UpgradeLavinmq':
        """
        Get an existing UpgradeLavinmq resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        :param pulumi.Input[str] new_version: The new version to upgrade to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UpgradeLavinmqState.__new__(_UpgradeLavinmqState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["new_version"] = new_version
        return UpgradeLavinmq(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[int]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="newVersion")
    def new_version(self) -> pulumi.Output[Optional[str]]:
        """
        The new version to upgrade to
        """
        return pulumi.get(self, "new_version")

