# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UpgradeRabbitmqArgs', 'UpgradeRabbitmq']

@pulumi.input_type
class UpgradeRabbitmqArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[int],
                 current_version: Optional[pulumi.Input[str]] = None,
                 new_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a UpgradeRabbitmq resource.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        :param pulumi.Input[str] current_version: Helper argument to change upgrade behaviour to latest possible version
        :param pulumi.Input[str] new_version: The new version to upgrade to
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if new_version is not None:
            pulumi.set(__self__, "new_version", new_version)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[int]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        """
        Helper argument to change upgrade behaviour to latest possible version
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter(name="newVersion")
    def new_version(self) -> Optional[pulumi.Input[str]]:
        """
        The new version to upgrade to
        """
        return pulumi.get(self, "new_version")

    @new_version.setter
    def new_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_version", value)


@pulumi.input_type
class _UpgradeRabbitmqState:
    def __init__(__self__, *,
                 current_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 new_version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UpgradeRabbitmq resources.
        :param pulumi.Input[str] current_version: Helper argument to change upgrade behaviour to latest possible version
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        :param pulumi.Input[str] new_version: The new version to upgrade to
        """
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if new_version is not None:
            pulumi.set(__self__, "new_version", new_version)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        """
        Helper argument to change upgrade behaviour to latest possible version
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[int]]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="newVersion")
    def new_version(self) -> Optional[pulumi.Input[str]]:
        """
        The new version to upgrade to
        """
        return pulumi.get(self, "new_version")

    @new_version.setter
    def new_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_version", value)


class UpgradeRabbitmq(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 current_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 new_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource allows you to upgrade RabbitMQ version. Depending on initial versions of RabbitMQ and Erlang of the CloudAMQP instance, multiple runs may be needed to get to the latest or wanted version. Reason for this is certain supported RabbitMQ version will also automatically upgrade Erlang version.

        There is three different ways to trigger the version upgrade

        > - Specify RabbitMQ version to upgrade to
        > - Upgrade to latest RabbitMQ version
        > - Old behaviour to upgrade to latest RabbitMQ version

        See, below example usage for the difference.

        Only available for dedicated subscription plans running ***RabbitMQ***.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Specify version upgrade, from v1.31.0</i>
            </b>
          </summary>

        Specify the version to upgrade to. List available upgradable versions, use [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html#get-available-versions).
        After the upgrade finished, there can still be newer versions available.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="rabbitmq-version-upgrade-test",
            plan="bunny-1",
            region="amazon-web-services::us-west-1")
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade",
            instance_id=instance.id,
            new_version="3.13.2")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Upgrade to latest possible version, from v1.31.0</i>
            </b>
          </summary>

        This will upgrade RabbitMQ to the latest possible version detected by the data source `get_upgradable_versions`.
        Multiple runs can be needed to upgrade the version even further.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="rabbitmq-version-upgrade-test",
            plan="bunny-1",
            region="amazon-web-services::us-west-1")
        upgradable_versions = instance.id.apply(lambda id: cloudamqp.get_upgradable_versions_output(instance_id=id))
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade",
            instance_id=instance.id,
            current_version=instance.rmq_version,
            new_version=upgradable_versions.new_rabbitmq_version)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Upgrade to latest possible version, before v1.31.0</i>
            </b>
          </summary>

        Old behaviour of the upgrading the RabbitMQ version. No longer recommended.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Retrieve latest possible upgradable versions for RabbitMQ and Erlang
        versions = cloudamqp.get_upgradable_versions(instance_id=instance["id"])
        # Invoke automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade", instance_id=instance["id"])
        ```

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Retrieve latest possible upgradable versions for RabbitMQ and Erlang
        versions = cloudamqp.get_upgradable_versions(instance_id=instance["id"])
        ```

        If newer version is still available to be upgradable in the data source, re-run again.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Retrieve latest possible upgradable versions for RabbitMQ and Erlang
        versions = cloudamqp.get_upgradable_versions(instance_id=instance["id"])
        # Invoke automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade", instance_id=instance["id"])
        ```

        </details>

        ## Important Upgrade Information

        > - All single node upgrades will require some downtime since RabbitMQ needs a restart.
        > - From RabbitMQ version 3.9, rolling upgrades between minor versions (e.g. 3.9 to 3.10), in a multi-node cluster are possible without downtime. This means that one node is upgraded at a time while the other nodes are still running. For versions older than 3.9, patch version upgrades (e.g. 3.8.x to 3.8.y) are possible without downtime in a multi-node cluster, but minor version upgrades will require downtime.
        > - Auto delete queues (queues that are marked AD) will be deleted during the update.
        > - Any custom plugins support has installed on your behalf will be disabled and you need to contact support@cloudamqp.com and ask to have them re-installed.
        > - TLS 1.0 and 1.1 will not be supported after the update.

        ## Multiple runs

        Depending on initial versions of RabbitMQ and Erlang of the CloudAMQP instance, multiple runs may be needed to get to the latest or wanted version.

        Example steps needed when starting at RabbitMQ version 3.12.2

        |  Version         | Supported upgrading versions              | Min version to upgrade Erlang |
        |------------------|-------------------------------------------|-------------------------------|
        | 3.12.2           | 3.12.4, 3.12.6, 3.12.10, 3.12.12, 3.12.13 | 3.12.13                       |
        | 3.12.13          | 3.13.2                                    | 3.13.2                        |
        | 3.13.2           | -                                         | -                             |

        ## Import

        Not possible to import this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] current_version: Helper argument to change upgrade behaviour to latest possible version
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        :param pulumi.Input[str] new_version: The new version to upgrade to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UpgradeRabbitmqArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to upgrade RabbitMQ version. Depending on initial versions of RabbitMQ and Erlang of the CloudAMQP instance, multiple runs may be needed to get to the latest or wanted version. Reason for this is certain supported RabbitMQ version will also automatically upgrade Erlang version.

        There is three different ways to trigger the version upgrade

        > - Specify RabbitMQ version to upgrade to
        > - Upgrade to latest RabbitMQ version
        > - Old behaviour to upgrade to latest RabbitMQ version

        See, below example usage for the difference.

        Only available for dedicated subscription plans running ***RabbitMQ***.

        ## Example Usage

        <details>
          <summary>
            <b>
              <i>Specify version upgrade, from v1.31.0</i>
            </b>
          </summary>

        Specify the version to upgrade to. List available upgradable versions, use [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html#get-available-versions).
        After the upgrade finished, there can still be newer versions available.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="rabbitmq-version-upgrade-test",
            plan="bunny-1",
            region="amazon-web-services::us-west-1")
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade",
            instance_id=instance.id,
            new_version="3.13.2")
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Upgrade to latest possible version, from v1.31.0</i>
            </b>
          </summary>

        This will upgrade RabbitMQ to the latest possible version detected by the data source `get_upgradable_versions`.
        Multiple runs can be needed to upgrade the version even further.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        instance = cloudamqp.Instance("instance",
            name="rabbitmq-version-upgrade-test",
            plan="bunny-1",
            region="amazon-web-services::us-west-1")
        upgradable_versions = instance.id.apply(lambda id: cloudamqp.get_upgradable_versions_output(instance_id=id))
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade",
            instance_id=instance.id,
            current_version=instance.rmq_version,
            new_version=upgradable_versions.new_rabbitmq_version)
        ```

        </details>

        <details>
          <summary>
            <b>
              <i>Upgrade to latest possible version, before v1.31.0</i>
            </b>
          </summary>

        Old behaviour of the upgrading the RabbitMQ version. No longer recommended.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Retrieve latest possible upgradable versions for RabbitMQ and Erlang
        versions = cloudamqp.get_upgradable_versions(instance_id=instance["id"])
        # Invoke automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade", instance_id=instance["id"])
        ```

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Retrieve latest possible upgradable versions for RabbitMQ and Erlang
        versions = cloudamqp.get_upgradable_versions(instance_id=instance["id"])
        ```

        If newer version is still available to be upgradable in the data source, re-run again.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Retrieve latest possible upgradable versions for RabbitMQ and Erlang
        versions = cloudamqp.get_upgradable_versions(instance_id=instance["id"])
        # Invoke automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade", instance_id=instance["id"])
        ```

        </details>

        ## Important Upgrade Information

        > - All single node upgrades will require some downtime since RabbitMQ needs a restart.
        > - From RabbitMQ version 3.9, rolling upgrades between minor versions (e.g. 3.9 to 3.10), in a multi-node cluster are possible without downtime. This means that one node is upgraded at a time while the other nodes are still running. For versions older than 3.9, patch version upgrades (e.g. 3.8.x to 3.8.y) are possible without downtime in a multi-node cluster, but minor version upgrades will require downtime.
        > - Auto delete queues (queues that are marked AD) will be deleted during the update.
        > - Any custom plugins support has installed on your behalf will be disabled and you need to contact support@cloudamqp.com and ask to have them re-installed.
        > - TLS 1.0 and 1.1 will not be supported after the update.

        ## Multiple runs

        Depending on initial versions of RabbitMQ and Erlang of the CloudAMQP instance, multiple runs may be needed to get to the latest or wanted version.

        Example steps needed when starting at RabbitMQ version 3.12.2

        |  Version         | Supported upgrading versions              | Min version to upgrade Erlang |
        |------------------|-------------------------------------------|-------------------------------|
        | 3.12.2           | 3.12.4, 3.12.6, 3.12.10, 3.12.12, 3.12.13 | 3.12.13                       |
        | 3.12.13          | 3.13.2                                    | 3.13.2                        |
        | 3.13.2           | -                                         | -                             |

        ## Import

        Not possible to import this resource.

        :param str resource_name: The name of the resource.
        :param UpgradeRabbitmqArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UpgradeRabbitmqArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 current_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 new_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UpgradeRabbitmqArgs.__new__(UpgradeRabbitmqArgs)

            __props__.__dict__["current_version"] = current_version
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["new_version"] = new_version
        super(UpgradeRabbitmq, __self__).__init__(
            'cloudamqp:index/upgradeRabbitmq:UpgradeRabbitmq',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            current_version: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[int]] = None,
            new_version: Optional[pulumi.Input[str]] = None) -> 'UpgradeRabbitmq':
        """
        Get an existing UpgradeRabbitmq resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] current_version: Helper argument to change upgrade behaviour to latest possible version
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        :param pulumi.Input[str] new_version: The new version to upgrade to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UpgradeRabbitmqState.__new__(_UpgradeRabbitmqState)

        __props__.__dict__["current_version"] = current_version
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["new_version"] = new_version
        return UpgradeRabbitmq(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> pulumi.Output[Optional[str]]:
        """
        Helper argument to change upgrade behaviour to latest possible version
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[int]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="newVersion")
    def new_version(self) -> pulumi.Output[Optional[str]]:
        """
        The new version to upgrade to
        """
        return pulumi.get(self, "new_version")

