"""Tests for the sportsreference team model class."""
import datetime
import os
import unittest

import requests_mock
from sportsball.data.sportsreference.sportsreference_team_model import create_sportsreference_team_model
from sportsball.data.league import League
from scrapesession.scrapesession import ScrapeSession


class TestSportsReferenceTeamModel(unittest.TestCase):

    def setUp(self):
        self.session = ScrapeSession(backend="memory")
        self.session._wayback_disabled = True
        self.dir = os.path.dirname(__file__)

    def test_identifier(self):
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "2025.html"), "rb") as f:
                m.get("https://www.sports-reference.com/cbb/schools/villanova/men/2025.html", content=f.read())
            with open(os.path.join(self.dir, "kyle-neptune-1.html"), "rb") as f:
                m.get("https://www.sports-reference.com/cbb/coaches/kyle-neptune-1.html", content=f.read())
            m.get("https://news.google.com/rss/search?q=%22Villanova+Wildcats+Men%27s%22+%2B+%28sport+OR+ncaab+OR+%22NCAA+Division+I+Basketball%22%29+after%3A2010-10-08+before%3A2010-10-09&ceid=US:en&hl=en&gl=US")
            team_model = create_sportsreference_team_model(
                session=self.session,
                url="https://www.sports-reference.com/cbb/schools/villanova/men/2025.html",
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NCAAB,
                player_urls=set(),
                points=10.0,
                fg={},
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertEqual(team_model.identifier, "Villanova Wildcats Men's")

    def test_field_goals(self):
        url = "https://www.sports-reference.com/cbb/schools/villanova/men/2025.html"
        player_url = "https://www.sports-reference.com/cbb/players/eric-dixon-1.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "2025.html"), "rb") as f:
                m.get(url, content=f.read())
            with open(os.path.join(self.dir, "eric-dixon-1.html"), "rb") as f:
                m.get(player_url, content=f.read())
            with open(os.path.join(self.dir, "kyle-neptune-1.html"), "rb") as f:
                m.get("https://www.sports-reference.com/cbb/coaches/kyle-neptune-1.html", content=f.read())
            team_model = create_sportsreference_team_model(
                session=self.session,
                url=url,
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NCAAB,
                player_urls=set([player_url]),
                points=10.0,
                fg={
                    "Eric Dixon": 8,
                },
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertEqual(team_model.field_goals, 8)

    def test_field_goals_attempted(self):
        url = "https://www.sports-reference.com/cbb/schools/villanova/men/2025.html"
        player_url = "https://www.sports-reference.com/cbb/players/eric-dixon-1.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "2025.html"), "rb") as f:
                m.get(url, content=f.read())
            with open(os.path.join(self.dir, "eric-dixon-1.html"), "rb") as f:
                m.get(player_url, content=f.read())
            with open(os.path.join(self.dir, "kyle-neptune-1.html"), "rb") as f:
                m.get("https://www.sports-reference.com/cbb/coaches/kyle-neptune-1.html", content=f.read())
            team_model = create_sportsreference_team_model(
                session=self.session,
                url=url,
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NCAAB,
                player_urls=set([player_url]),
                points=10.0,
                fg={
                    "Eric Dixon": 8,
                },
                fga={
                    "Eric Dixon": 10
                },
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertEqual(team_model.field_goals_attempted, 10)

    def test_identifier_2(self):
        url = "http://www.basketball-reference.com/teams/LAC/2015.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "LAC_2015.html"), "rb") as f:
                m.get(url, content=f.read())
            with open(os.path.join(self.dir, "riverdo01c.html"), "rb") as f:
                m.get("http://www.basketball-reference.com/coaches/riverdo01c.html", content=f.read())
            team_model = create_sportsreference_team_model(
                session=self.session,
                url=url,
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NCAAB,
                player_urls=set(),
                points=10.0,
                fg={},
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertEqual(team_model.identifier, "Los Angeles Clippers")

    def test_identifier_3(self):
        url = "http://www.basketball-reference.com/teams/BRK/2014.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "BRK_2014.html"), "rb") as f:
                m.get(url, content=f.read())
            with open(os.path.join(self.dir, "kiddja01c.html"), "rb") as f:
                m.get("http://www.basketball-reference.com/coaches/kiddja01c.html", content=f.read())
            team_model = create_sportsreference_team_model(
                session=self.session,
                url=url,
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NCAAB,
                player_urls=set(),
                points=10.0,
                fg={},
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertEqual(team_model.identifier, "Brooklyn Nets")

    def test_name(self):
        url = "http://www.basketball-reference.com/teams/CLE/2016.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "CLE_2016.html"), "rb") as f:
                m.get(url, content=f.read())
            with open(os.path.join(self.dir, "luety01c.html"), "rb") as f:
                m.get("http://www.basketball-reference.com/coaches/luety01c.html", content=f.read())
            team_model = create_sportsreference_team_model(
                session=self.session,
                url=url,
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NCAAB,
                player_urls=set(),
                points=10.0,
                fg={},
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertEqual(team_model.name, "Cleveland Cavaliers")

    def test_name_2(self):
        url = "http://www.basketball-reference.com/teams/LAL/2015.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "LAL_2015.html"), "rb") as f:
                m.get(url, content=f.read())
            with open(os.path.join(self.dir, "scottby01c.html"), "rb") as f:
                m.get("http://www.basketball-reference.com/coaches/scottby01c.html", content=f.read())
            team_model = create_sportsreference_team_model(
                session=self.session,
                url=url,
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NBA,
                player_urls=set(),
                points=10.0,
                fg={},
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertEqual(team_model.name, "Los Angeles Lakers")

    def test_name_3(self):
        url = "https://www.basketball-reference.com/teams/BOS/2015.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "BOS_2015.html"), "rb") as f:
                m.get(url, content=f.read())
            with open(os.path.join(self.dir, "stevebr99c.html"), "rb") as f:
                m.get("https://www.basketball-reference.com/coaches/stevebr99c.html", content=f.read())
            team_model = create_sportsreference_team_model(
                session=self.session,
                url=url,
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NBA,
                player_urls=set(),
                points=10.0,
                fg={},
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertEqual(team_model.name, "Boston Celtics")

    def test_coach_url_null(self):
        url = "https://www.basketball-reference.com/teams/GSW/2016.html"
        with requests_mock.Mocker() as m:
            with open(os.path.join(self.dir, "GSW_2016_2.html"), "rb") as f:
                m.get(url, content=f.read())
            with open(os.path.join(self.dir, "kerrst01c.html"), "rb") as f:
                m.get("https://www.basketball-reference.com/coaches/kerrst01c.html", content=f.read())
            team_model = create_sportsreference_team_model(
                session=self.session,
                url=url,
                dt=datetime.datetime(2010, 10, 10, 10, 10, 00),
                league=League.NBA,
                player_urls=set(),
                points=10.0,
                fg={},
                fga={},
                offensive_rebounds={},
                assists={},
                turnovers={},
                team_name="",
                positions_validator={},
                minutes_played={},
                three_point_field_goals={},
                three_point_field_goals_attempted={},
                free_throws={},
                free_throws_attempted={},
                defensive_rebounds={},
                steals={},
                blocks={},
                personal_fouls={},
                player_points={},
                game_scores={},
                point_differentials={},
                goals={},
                penalties_in_minutes={},
                even_strength_goals={},
                power_play_goals={},
                short_handed_goals={},
                game_winning_goals={},
                even_strength_assists={},
                power_play_assists={},
                short_handed_assists={},
                shots_on_goal={},
                shooting_percentage={},
                shifts={},
                time_on_ice={},
                decision={},
                goals_against={},
                shots_against={},
                saves={},
                save_percentage={},
                shutouts={},
                individual_corsi_for_events={},
                on_shot_ice_for_events={},
                on_shot_ice_against_events={},
                corsi_for_percentage={},
                relative_corsi_for_percentage={},
                offensive_zone_starts={},
                defensive_zone_starts={},
                offensive_zone_start_percentage={},
                hits={},
                true_shooting_percentage={},
                at_bats={},
                runs_scored={},
                runs_batted_in={},
                bases_on_balls={},
                strikeouts={},
                plate_appearances={},
                hits_at_bats={},
                obp={},
                slg={},
                ops={},
                pitches={},
                strikes={},
                win_probability_added={},
                average_leverage_index={},
                wpa_plus={},
                wpa_minus={},
                cwpa={},
                acli={},
                re24={},
                putouts={},
                innings_pitched={},
                earned_runs={},
                home_runs={},
                era={},
                batters_faced={},
                strikes_by_contact={},
                strikes_swinging={},
                strikes_looking={},
                ground_balls={},
                fly_balls={},
                line_drives={},
                inherited_runners={},
                inherited_scores={},
                effective_field_goal_percentage={},
                penalty_kicks_made={},
                penalty_kicks_attempted={},
                shots_total={},
                shots_on_target={},
                yellow_cards={},
                red_cards={},
                touches={},
                expected_goals={},
                non_penalty_expected_goals={},
                expected_assisted_goals={},
                shot_creating_actions={},
                goal_creating_actions={},
                passes_completed={},
                passes_attempted={},
                pass_completion={},
                progressive_passes={},
                carries={},
                progressive_carries={},
                take_ons_attempted={},
                successful_take_ons={},
                total_passing_distance={},
                progressive_passing_distance={},
                passes_completed_short={},
                passes_attempted_short={},
                pass_completion_short={},
                passes_completed_medium={},
                passes_attempted_medium={},
                pass_completion_medium={},
                passes_completed_long={},
                passes_attempted_long={},
                pass_completion_long={},
                expected_assists={},
                key_passes={},
                passes_into_final_third={},
                passes_into_penalty_area={},
                crosses_into_penalty_area={},
                live_ball_passes={},
                dead_ball_passes={},
                passes_from_free_kicks={},
                through_balls={},
                switches={},
                crosses={},
                throw_ins_taken={},
                corner_kicks={},
                inswinging_corner_kicks={},
                outswinging_corner_kicks={},
                straight_corner_kicks={},
                passes_offside={},
                passes_blocked={},
                tackles_won={},
                tackles_in_defensive_third={},
                tackles_in_middle_third={},
                tackles_in_attacking_third={},
                dribblers_tackled={},
                dribbles_challenged={},
                percent_of_dribblers_tackled={},
                challenges_lost={},
                shots_blocked={},
                tackles_plus_interceptions={},
                errors={},
                touches_in_defensive_penalty_area={},
                touches_in_defensive_third={},
                touches_in_middle_third={},
                touches_in_attacking_third={},
                touches_in_attacking_penalty_area={},
                live_ball_touches={},
                successful_take_on_percentage={},
                times_tackled_during_take_ons={},
                tackled_during_take_ons_percentage={},
                total_carrying_distance={},
                progressive_carrying_distance={},
                carries_into_final_third={},
                carries_into_penalty_area={},
                miscontrols={},
                dispossessed={},
                passes_received={},
                progressive_passes_received={},
                second_yellow_card={},
                fouls_committed={},
                fouls_drawn={},
                offsides={},
                penalty_kicks_won={},
                penalty_kicks_conceded={},
                own_goals={},
                ball_recoveries={},
                aerials_won={},
                aerials_lost={},
                percentage_of_aerials_won={},
                shots_on_target_against={},
                post_shot_expected_goals={},
                passes_attempted_minus_goal_kicks={},
                throws_attempted={},
                percentage_of_passes_that_were_launched={},
                average_pass_length={},
                goal_kicks_attempted={},
                percentage_of_goal_kicks_that_were_launched={},
                average_goal_kick_length={},
                crosses_faced={},
                crosses_stopped={},
                percentage_crosses_stopped={},
                defensive_actions_outside_penalty_area={},
                average_distance_of_defensive_actions={},
                three_point_attempt_rate={},
                tackles={},
                interceptions={},
                clearances={},
            )
            self.assertListEqual(team_model.coaches, [])
