import os

def remove_face_database(db_path="face_db.json"):
    """
    Deletes the face database file if it exists.
    This allows users to reset and create a new face database.
    """
    if os.path.exists(db_path):
        os.remove(db_path)
        print(f"[INFO] Face database '{db_path}' removed successfully.")
    else:
        print(f"[WARN] No face database found at '{db_path}'. Nothing to remove.")
