# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: machine/machine.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from .. import common as _common__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ApplyConfigurationRequestMode(betterproto.Enum):
    REBOOT = 0
    AUTO = 1
    NO_REBOOT = 2
    STAGED = 3
    TRY = 4


class RebootRequestMode(betterproto.Enum):
    DEFAULT = 0
    POWERCYCLE = 1


class SequenceEventAction(betterproto.Enum):
    NOOP = 0
    START = 1
    STOP = 2


class PhaseEventAction(betterproto.Enum):
    START = 0
    STOP = 1


class TaskEventAction(betterproto.Enum):
    START = 0
    STOP = 1


class ServiceStateEventAction(betterproto.Enum):
    INITIALIZED = 0
    PREPARING = 1
    WAITING = 2
    RUNNING = 3
    STOPPING = 4
    FINISHED = 5
    FAILED = 6
    SKIPPED = 7


class MachineStatusEventMachineStage(betterproto.Enum):
    UNKNOWN = 0
    BOOTING = 1
    INSTALLING = 2
    MAINTENANCE = 3
    RUNNING = 4
    REBOOTING = 5
    SHUTTING_DOWN = 6
    RESETTING = 7
    UPGRADING = 8


class ResetRequestWipeMode(betterproto.Enum):
    ALL = 0
    SYSTEM_DISK = 1
    USER_DISKS = 2


class UpgradeRequestRebootMode(betterproto.Enum):
    DEFAULT = 0
    POWERCYCLE = 1


class ListRequestType(betterproto.Enum):
    """File type."""

    REGULAR = 0
    """Regular file (not directory, symlink, etc)."""

    DIRECTORY = 1
    """Directory."""

    SYMLINK = 2
    """Symbolic link."""


class EtcdMemberAlarmAlarmType(betterproto.Enum):
    NONE = 0
    NOSPACE = 1
    CORRUPT = 2


class MachineConfigMachineType(betterproto.Enum):
    TYPE_UNKNOWN = 0
    TYPE_INIT = 1
    TYPE_CONTROL_PLANE = 2
    TYPE_WORKER = 3


class NetstatRequestFilter(betterproto.Enum):
    ALL = 0
    CONNECTED = 1
    LISTENING = 2


class ConnectRecordState(betterproto.Enum):
    RESERVED = 0
    ESTABLISHED = 1
    SYN_SENT = 2
    SYN_RECV = 3
    FIN_WAIT1 = 4
    FIN_WAIT2 = 5
    TIME_WAIT = 6
    CLOSE = 7
    CLOSEWAIT = 8
    LASTACK = 9
    LISTEN = 10
    CLOSING = 11


class ConnectRecordTimerActive(betterproto.Enum):
    OFF = 0
    ON = 1
    KEEPALIVE = 2
    TIMEWAIT = 3
    PROBE = 4


@dataclass(eq=False, repr=False)
class ApplyConfigurationRequest(betterproto.Message):
    """
    rpc applyConfiguration ApplyConfiguration describes a request to assert a
    new configuration upon a node.
    """

    data: bytes = betterproto.bytes_field(1)
    mode: "ApplyConfigurationRequestMode" = betterproto.enum_field(4)
    dry_run: bool = betterproto.bool_field(5)
    try_mode_timeout: timedelta = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class ApplyConfiguration(betterproto.Message):
    """
    ApplyConfigurationResponse describes the response to a configuration
    request.
    """

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    warnings: List[str] = betterproto.string_field(2)
    """Configuration validation warnings."""

    mode: "ApplyConfigurationRequestMode" = betterproto.enum_field(3)
    """States which mode was actually chosen."""

    mode_details: str = betterproto.string_field(4)
    """
    Human-readable message explaining the result of the apply configuration
    call.
    """


@dataclass(eq=False, repr=False)
class ApplyConfigurationResponse(betterproto.Message):
    messages: List["ApplyConfiguration"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RebootRequest(betterproto.Message):
    """rpc reboot"""

    mode: "RebootRequestMode" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class Reboot(betterproto.Message):
    """The reboot message containing the reboot status."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    actor_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RebootResponse(betterproto.Message):
    messages: List["Reboot"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class BootstrapRequest(betterproto.Message):
    """rpc Bootstrap"""

    recover_etcd: bool = betterproto.bool_field(1)
    """
    Enable etcd recovery from the snapshot. Snapshot should be uploaded before
    this call via EtcdRecover RPC.
    """

    recover_skip_hash_check: bool = betterproto.bool_field(2)
    """
    Skip hash check on the snapshot (etcd). Enable this when recovering from
    data directory copy to skip integrity check.
    """


@dataclass(eq=False, repr=False)
class Bootstrap(betterproto.Message):
    """The bootstrap message containing the bootstrap status."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class BootstrapResponse(betterproto.Message):
    messages: List["Bootstrap"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SequenceEvent(betterproto.Message):
    """rpc events"""

    sequence: str = betterproto.string_field(1)
    action: "SequenceEventAction" = betterproto.enum_field(2)
    error: "_common__.Error" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class PhaseEvent(betterproto.Message):
    phase: str = betterproto.string_field(1)
    action: "PhaseEventAction" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class TaskEvent(betterproto.Message):
    task: str = betterproto.string_field(1)
    action: "TaskEventAction" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class ServiceStateEvent(betterproto.Message):
    service: str = betterproto.string_field(1)
    action: "ServiceStateEventAction" = betterproto.enum_field(2)
    message: str = betterproto.string_field(3)
    health: "ServiceHealth" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class RestartEvent(betterproto.Message):
    cmd: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class ConfigLoadErrorEvent(betterproto.Message):
    """ConfigLoadErrorEvent is reported when the config loading has failed."""

    error: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ConfigValidationErrorEvent(betterproto.Message):
    """
    ConfigValidationErrorEvent is reported when config validation has failed.
    """

    error: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AddressEvent(betterproto.Message):
    """
    AddressEvent reports node endpoints aggregated from k8s.Endpoints and
    network.Hostname.
    """

    hostname: str = betterproto.string_field(1)
    addresses: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MachineStatusEvent(betterproto.Message):
    """MachineStatusEvent reports changes to the MachineStatus resource."""

    stage: "MachineStatusEventMachineStage" = betterproto.enum_field(1)
    status: "MachineStatusEventMachineStatus" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MachineStatusEventMachineStatus(betterproto.Message):
    ready: bool = betterproto.bool_field(1)
    unmet_conditions: List[
        "MachineStatusEventMachineStatusUnmetCondition"
    ] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MachineStatusEventMachineStatusUnmetCondition(betterproto.Message):
    name: str = betterproto.string_field(1)
    reason: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class EventsRequest(betterproto.Message):
    tail_events: int = betterproto.int32_field(1)
    tail_id: str = betterproto.string_field(2)
    tail_seconds: int = betterproto.int32_field(3)
    with_actor_id: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    data: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    id: str = betterproto.string_field(3)
    actor_id: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class ResetPartitionSpec(betterproto.Message):
    """rpc reset"""

    label: str = betterproto.string_field(1)
    wipe: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class ResetRequest(betterproto.Message):
    graceful: bool = betterproto.bool_field(1)
    """
    Graceful indicates whether node should leave etcd before the upgrade, it
    also enforces etcd checks before leaving.
    """

    reboot: bool = betterproto.bool_field(2)
    """Reboot indicates whether node should reboot or halt after resetting."""

    system_partitions_to_wipe: List["ResetPartitionSpec"] = betterproto.message_field(3)
    """
    System_partitions_to_wipe lists specific system disk partitions to be reset
    (wiped). If system_partitions_to_wipe is empty, all the partitions are
    erased.
    """

    user_disks_to_wipe: List[str] = betterproto.string_field(4)
    """
    UserDisksToWipe lists specific connected block devices to be reset (wiped).
    """

    mode: "ResetRequestWipeMode" = betterproto.enum_field(5)
    """WipeMode defines which devices should be wiped."""


@dataclass(eq=False, repr=False)
class Reset(betterproto.Message):
    """The reset message containing the restart status."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    actor_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ResetResponse(betterproto.Message):
    messages: List["Reset"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Shutdown(betterproto.Message):
    """rpc shutdown The messages message containing the shutdown status."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    actor_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ShutdownRequest(betterproto.Message):
    force: bool = betterproto.bool_field(1)
    """
    Force indicates whether node should shutdown without first cordening and
    draining
    """


@dataclass(eq=False, repr=False)
class ShutdownResponse(betterproto.Message):
    messages: List["Shutdown"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpgradeRequest(betterproto.Message):
    """rpc upgrade"""

    image: str = betterproto.string_field(1)
    preserve: bool = betterproto.bool_field(2)
    stage: bool = betterproto.bool_field(3)
    force: bool = betterproto.bool_field(4)
    reboot_mode: "UpgradeRequestRebootMode" = betterproto.enum_field(5)


@dataclass(eq=False, repr=False)
class Upgrade(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    ack: str = betterproto.string_field(2)
    actor_id: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class UpgradeResponse(betterproto.Message):
    messages: List["Upgrade"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ServiceList(betterproto.Message):
    """rpc servicelist"""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    services: List["ServiceInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ServiceListResponse(betterproto.Message):
    messages: List["ServiceList"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ServiceInfo(betterproto.Message):
    id: str = betterproto.string_field(1)
    state: str = betterproto.string_field(2)
    events: "ServiceEvents" = betterproto.message_field(3)
    health: "ServiceHealth" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class ServiceEvents(betterproto.Message):
    events: List["ServiceEvent"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ServiceEvent(betterproto.Message):
    msg: str = betterproto.string_field(1)
    state: str = betterproto.string_field(2)
    ts: datetime = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ServiceHealth(betterproto.Message):
    unknown: bool = betterproto.bool_field(1)
    healthy: bool = betterproto.bool_field(2)
    last_message: str = betterproto.string_field(3)
    last_change: datetime = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class ServiceStartRequest(betterproto.Message):
    """rpc servicestart"""

    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ServiceStart(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    resp: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ServiceStartResponse(betterproto.Message):
    messages: List["ServiceStart"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ServiceStopRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ServiceStop(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    resp: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ServiceStopResponse(betterproto.Message):
    messages: List["ServiceStop"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ServiceRestartRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ServiceRestart(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    resp: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ServiceRestartResponse(betterproto.Message):
    messages: List["ServiceRestart"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CopyRequest(betterproto.Message):
    """
    CopyRequest describes a request to copy data out of Talos node Copy
    produces .tar.gz archive which is streamed back to the caller
    """

    root_path: str = betterproto.string_field(1)
    """
    Root path to start copying data out, it might be either a file or directory
    """


@dataclass(eq=False, repr=False)
class ListRequest(betterproto.Message):
    """ListRequest describes a request to list the contents of a directory."""

    root: str = betterproto.string_field(1)
    """
    Root indicates the root directory for the list. If not indicated, '/' is
    presumed.
    """

    recurse: bool = betterproto.bool_field(2)
    """Recurse indicates that subdirectories should be recursed."""

    recursion_depth: int = betterproto.int32_field(3)
    """
    RecursionDepth indicates how many levels of subdirectories should be
    recursed. The default (0) indicates that no limit should be enforced.
    """

    types: List["ListRequestType"] = betterproto.enum_field(4)
    """
    Types indicates what file type should be returned. If not indicated, all
    files will be returned.
    """


@dataclass(eq=False, repr=False)
class DiskUsageRequest(betterproto.Message):
    """
    DiskUsageRequest describes a request to list disk usage of directories and
    regular files
    """

    recursion_depth: int = betterproto.int32_field(1)
    """
    RecursionDepth indicates how many levels of subdirectories should be
    recursed. The default (0) indicates that no limit should be enforced.
    """

    all: bool = betterproto.bool_field(2)
    """All write sizes for all files, not just directories."""

    threshold: int = betterproto.int64_field(3)
    """
    Threshold exclude entries smaller than SIZE if positive, or entries greater
    than SIZE if negative.
    """

    paths: List[str] = betterproto.string_field(4)
    """
    DiskUsagePaths is the list of directories to calculate disk usage for.
    """


@dataclass(eq=False, repr=False)
class FileInfo(betterproto.Message):
    """FileInfo describes a file or directory's information"""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    name: str = betterproto.string_field(2)
    """Name is the name (including prefixed path) of the file or directory"""

    size: int = betterproto.int64_field(3)
    """Size indicates the number of bytes contained within the file"""

    mode: int = betterproto.uint32_field(4)
    """Mode is the bitmap of UNIX mode/permission flags of the file"""

    modified: int = betterproto.int64_field(5)
    """
    Modified indicates the UNIX timestamp at which the file was last modified
    """

    is_dir: bool = betterproto.bool_field(6)
    """IsDir indicates that the file is a directory"""

    error: str = betterproto.string_field(7)
    """
    Error describes any error encountered while trying to read the file
    information.
    """

    link: str = betterproto.string_field(8)
    """Link is filled with symlink target"""

    relative_name: str = betterproto.string_field(9)
    """
    RelativeName is the name of the file or directory relative to the RootPath
    """

    uid: int = betterproto.uint32_field(10)
    """Owner uid"""

    gid: int = betterproto.uint32_field(11)
    """Owner gid"""


@dataclass(eq=False, repr=False)
class DiskUsageInfo(betterproto.Message):
    """
    DiskUsageInfo describes a file or directory's information for du command
    """

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    name: str = betterproto.string_field(2)
    """Name is the name (including prefixed path) of the file or directory"""

    size: int = betterproto.int64_field(3)
    """Size indicates the number of bytes contained within the file"""

    error: str = betterproto.string_field(4)
    """
    Error describes any error encountered while trying to read the file
    information.
    """

    relative_name: str = betterproto.string_field(5)
    """
    RelativeName is the name of the file or directory relative to the RootPath
    """


@dataclass(eq=False, repr=False)
class Mounts(betterproto.Message):
    """The messages message containing the requested df stats."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    stats: List["MountStat"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MountsResponse(betterproto.Message):
    messages: List["Mounts"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MountStat(betterproto.Message):
    """The messages message containing the requested processes."""

    filesystem: str = betterproto.string_field(1)
    size: int = betterproto.uint64_field(2)
    available: int = betterproto.uint64_field(3)
    mounted_on: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class Version(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    version: "VersionInfo" = betterproto.message_field(2)
    platform: "PlatformInfo" = betterproto.message_field(3)
    features: "FeaturesInfo" = betterproto.message_field(4)
    """
    Features describe individual Talos features that can be switched on or off.
    """


@dataclass(eq=False, repr=False)
class VersionResponse(betterproto.Message):
    messages: List["Version"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class VersionInfo(betterproto.Message):
    tag: str = betterproto.string_field(1)
    sha: str = betterproto.string_field(2)
    built: str = betterproto.string_field(3)
    go_version: str = betterproto.string_field(4)
    os: str = betterproto.string_field(5)
    arch: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class PlatformInfo(betterproto.Message):
    name: str = betterproto.string_field(1)
    mode: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class FeaturesInfo(betterproto.Message):
    """
    FeaturesInfo describes individual Talos features that can be switched on or
    off.
    """

    rbac: bool = betterproto.bool_field(1)
    """RBAC is true if role-based access control is enabled."""


@dataclass(eq=False, repr=False)
class LogsRequest(betterproto.Message):
    """rpc logs The request message containing the process name."""

    namespace: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    driver: "_common__.ContainerDriver" = betterproto.enum_field(3)
    """driver might be default "containerd" or "cri"""

    follow: bool = betterproto.bool_field(4)
    tail_lines: int = betterproto.int32_field(5)


@dataclass(eq=False, repr=False)
class ReadRequest(betterproto.Message):
    path: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class RollbackRequest(betterproto.Message):
    """rpc rollback"""

    pass


@dataclass(eq=False, repr=False)
class Rollback(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RollbackResponse(betterproto.Message):
    messages: List["Rollback"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ContainersRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    driver: "_common__.ContainerDriver" = betterproto.enum_field(2)
    """driver might be default "containerd" or "cri"""


@dataclass(eq=False, repr=False)
class ContainerInfo(betterproto.Message):
    """The messages message containing the requested containers."""

    namespace: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    image: str = betterproto.string_field(3)
    pid: int = betterproto.uint32_field(4)
    status: str = betterproto.string_field(5)
    pod_id: str = betterproto.string_field(6)
    name: str = betterproto.string_field(7)
    network_namespace: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class Container(betterproto.Message):
    """The messages message containing the requested containers."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    containers: List["ContainerInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ContainersResponse(betterproto.Message):
    messages: List["Container"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DmesgRequest(betterproto.Message):
    """dmesg"""

    follow: bool = betterproto.bool_field(1)
    tail: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class ProcessesResponse(betterproto.Message):
    """rpc processes"""

    messages: List["Process"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Process(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    processes: List["ProcessInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ProcessInfo(betterproto.Message):
    pid: int = betterproto.int32_field(1)
    ppid: int = betterproto.int32_field(2)
    state: str = betterproto.string_field(3)
    threads: int = betterproto.int32_field(4)
    cpu_time: float = betterproto.double_field(5)
    virtual_memory: int = betterproto.uint64_field(6)
    resident_memory: int = betterproto.uint64_field(7)
    command: str = betterproto.string_field(8)
    executable: str = betterproto.string_field(9)
    args: str = betterproto.string_field(10)


@dataclass(eq=False, repr=False)
class RestartRequest(betterproto.Message):
    """rpc restart The request message containing the process to restart."""

    namespace: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    driver: "_common__.ContainerDriver" = betterproto.enum_field(3)
    """driver might be default "containerd" or "cri"""


@dataclass(eq=False, repr=False)
class Restart(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RestartResponse(betterproto.Message):
    """The messages message containing the restart status."""

    messages: List["Restart"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class StatsRequest(betterproto.Message):
    """The request message containing the containerd namespace."""

    namespace: str = betterproto.string_field(1)
    driver: "_common__.ContainerDriver" = betterproto.enum_field(2)
    """driver might be default "containerd" or "cri"""


@dataclass(eq=False, repr=False)
class Stats(betterproto.Message):
    """The messages message containing the requested stats."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    stats: List["Stat"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class StatsResponse(betterproto.Message):
    messages: List["Stats"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Stat(betterproto.Message):
    """The messages message containing the requested stat."""

    namespace: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    memory_usage: int = betterproto.uint64_field(4)
    cpu_usage: int = betterproto.uint64_field(5)
    pod_id: str = betterproto.string_field(6)
    name: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class Memory(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    meminfo: "MemInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MemoryResponse(betterproto.Message):
    messages: List["Memory"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MemInfo(betterproto.Message):
    memtotal: int = betterproto.uint64_field(1)
    memfree: int = betterproto.uint64_field(2)
    memavailable: int = betterproto.uint64_field(3)
    buffers: int = betterproto.uint64_field(4)
    cached: int = betterproto.uint64_field(5)
    swapcached: int = betterproto.uint64_field(6)
    active: int = betterproto.uint64_field(7)
    inactive: int = betterproto.uint64_field(8)
    activeanon: int = betterproto.uint64_field(9)
    inactiveanon: int = betterproto.uint64_field(10)
    activefile: int = betterproto.uint64_field(11)
    inactivefile: int = betterproto.uint64_field(12)
    unevictable: int = betterproto.uint64_field(13)
    mlocked: int = betterproto.uint64_field(14)
    swaptotal: int = betterproto.uint64_field(15)
    swapfree: int = betterproto.uint64_field(16)
    dirty: int = betterproto.uint64_field(17)
    writeback: int = betterproto.uint64_field(18)
    anonpages: int = betterproto.uint64_field(19)
    mapped: int = betterproto.uint64_field(20)
    shmem: int = betterproto.uint64_field(21)
    slab: int = betterproto.uint64_field(22)
    sreclaimable: int = betterproto.uint64_field(23)
    sunreclaim: int = betterproto.uint64_field(24)
    kernelstack: int = betterproto.uint64_field(25)
    pagetables: int = betterproto.uint64_field(26)
    nfsunstable: int = betterproto.uint64_field(27)
    bounce: int = betterproto.uint64_field(28)
    writebacktmp: int = betterproto.uint64_field(29)
    commitlimit: int = betterproto.uint64_field(30)
    committedas: int = betterproto.uint64_field(31)
    vmalloctotal: int = betterproto.uint64_field(32)
    vmallocused: int = betterproto.uint64_field(33)
    vmallocchunk: int = betterproto.uint64_field(34)
    hardwarecorrupted: int = betterproto.uint64_field(35)
    anonhugepages: int = betterproto.uint64_field(36)
    shmemhugepages: int = betterproto.uint64_field(37)
    shmempmdmapped: int = betterproto.uint64_field(38)
    cmatotal: int = betterproto.uint64_field(39)
    cmafree: int = betterproto.uint64_field(40)
    hugepagestotal: int = betterproto.uint64_field(41)
    hugepagesfree: int = betterproto.uint64_field(42)
    hugepagesrsvd: int = betterproto.uint64_field(43)
    hugepagessurp: int = betterproto.uint64_field(44)
    hugepagesize: int = betterproto.uint64_field(45)
    directmap4_k: int = betterproto.uint64_field(46)
    directmap2_m: int = betterproto.uint64_field(47)
    directmap1_g: int = betterproto.uint64_field(48)


@dataclass(eq=False, repr=False)
class HostnameResponse(betterproto.Message):
    messages: List["Hostname"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Hostname(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    hostname: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class LoadAvgResponse(betterproto.Message):
    messages: List["LoadAvg"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class LoadAvg(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    load1: float = betterproto.double_field(2)
    load5: float = betterproto.double_field(3)
    load15: float = betterproto.double_field(4)


@dataclass(eq=False, repr=False)
class SystemStatResponse(betterproto.Message):
    messages: List["SystemStat"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SystemStat(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    boot_time: int = betterproto.uint64_field(2)
    cpu_total: "CpuStat" = betterproto.message_field(3)
    cpu: List["CpuStat"] = betterproto.message_field(4)
    irq_total: int = betterproto.uint64_field(5)
    irq: List[int] = betterproto.uint64_field(6)
    context_switches: int = betterproto.uint64_field(7)
    process_created: int = betterproto.uint64_field(8)
    process_running: int = betterproto.uint64_field(9)
    process_blocked: int = betterproto.uint64_field(10)
    soft_irq_total: int = betterproto.uint64_field(11)
    soft_irq: "SoftIrqStat" = betterproto.message_field(12)


@dataclass(eq=False, repr=False)
class CpuStat(betterproto.Message):
    user: float = betterproto.double_field(1)
    nice: float = betterproto.double_field(2)
    system: float = betterproto.double_field(3)
    idle: float = betterproto.double_field(4)
    iowait: float = betterproto.double_field(5)
    irq: float = betterproto.double_field(6)
    soft_irq: float = betterproto.double_field(7)
    steal: float = betterproto.double_field(8)
    guest: float = betterproto.double_field(9)
    guest_nice: float = betterproto.double_field(10)


@dataclass(eq=False, repr=False)
class SoftIrqStat(betterproto.Message):
    hi: int = betterproto.uint64_field(1)
    timer: int = betterproto.uint64_field(2)
    net_tx: int = betterproto.uint64_field(3)
    net_rx: int = betterproto.uint64_field(4)
    block: int = betterproto.uint64_field(5)
    block_io_poll: int = betterproto.uint64_field(6)
    tasklet: int = betterproto.uint64_field(7)
    sched: int = betterproto.uint64_field(8)
    hrtimer: int = betterproto.uint64_field(9)
    rcu: int = betterproto.uint64_field(10)


@dataclass(eq=False, repr=False)
class CpuInfoResponse(betterproto.Message):
    messages: List["CpUsInfo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CpUsInfo(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    cpu_info: List["CpuInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CpuInfo(betterproto.Message):
    processor: int = betterproto.uint32_field(1)
    vendor_id: str = betterproto.string_field(2)
    cpu_family: str = betterproto.string_field(3)
    model: str = betterproto.string_field(4)
    model_name: str = betterproto.string_field(5)
    stepping: str = betterproto.string_field(6)
    microcode: str = betterproto.string_field(7)
    cpu_mhz: float = betterproto.double_field(8)
    cache_size: str = betterproto.string_field(9)
    physical_id: str = betterproto.string_field(10)
    siblings: int = betterproto.uint32_field(11)
    core_id: str = betterproto.string_field(12)
    cpu_cores: int = betterproto.uint32_field(13)
    apic_id: str = betterproto.string_field(14)
    initial_apic_id: str = betterproto.string_field(15)
    fpu: str = betterproto.string_field(16)
    fpu_exception: str = betterproto.string_field(17)
    cpu_id_level: int = betterproto.uint32_field(18)
    wp: str = betterproto.string_field(19)
    flags: List[str] = betterproto.string_field(20)
    bugs: List[str] = betterproto.string_field(21)
    bogo_mips: float = betterproto.double_field(22)
    cl_flush_size: int = betterproto.uint32_field(23)
    cache_alignment: int = betterproto.uint32_field(24)
    address_sizes: str = betterproto.string_field(25)
    power_management: str = betterproto.string_field(26)


@dataclass(eq=False, repr=False)
class NetworkDeviceStatsResponse(betterproto.Message):
    messages: List["NetworkDeviceStats"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class NetworkDeviceStats(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    total: "NetDev" = betterproto.message_field(2)
    devices: List["NetDev"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class NetDev(betterproto.Message):
    name: str = betterproto.string_field(1)
    rx_bytes: int = betterproto.uint64_field(2)
    rx_packets: int = betterproto.uint64_field(3)
    rx_errors: int = betterproto.uint64_field(4)
    rx_dropped: int = betterproto.uint64_field(5)
    rx_fifo: int = betterproto.uint64_field(6)
    rx_frame: int = betterproto.uint64_field(7)
    rx_compressed: int = betterproto.uint64_field(8)
    rx_multicast: int = betterproto.uint64_field(9)
    tx_bytes: int = betterproto.uint64_field(10)
    tx_packets: int = betterproto.uint64_field(11)
    tx_errors: int = betterproto.uint64_field(12)
    tx_dropped: int = betterproto.uint64_field(13)
    tx_fifo: int = betterproto.uint64_field(14)
    tx_collisions: int = betterproto.uint64_field(15)
    tx_carrier: int = betterproto.uint64_field(16)
    tx_compressed: int = betterproto.uint64_field(17)


@dataclass(eq=False, repr=False)
class DiskStatsResponse(betterproto.Message):
    messages: List["DiskStats"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DiskStats(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    total: "DiskStat" = betterproto.message_field(2)
    devices: List["DiskStat"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class DiskStat(betterproto.Message):
    name: str = betterproto.string_field(1)
    read_completed: int = betterproto.uint64_field(2)
    read_merged: int = betterproto.uint64_field(3)
    read_sectors: int = betterproto.uint64_field(4)
    read_time_ms: int = betterproto.uint64_field(5)
    write_completed: int = betterproto.uint64_field(6)
    write_merged: int = betterproto.uint64_field(7)
    write_sectors: int = betterproto.uint64_field(8)
    write_time_ms: int = betterproto.uint64_field(9)
    io_in_progress: int = betterproto.uint64_field(10)
    io_time_ms: int = betterproto.uint64_field(11)
    io_time_weighted_ms: int = betterproto.uint64_field(12)
    discard_completed: int = betterproto.uint64_field(13)
    discard_merged: int = betterproto.uint64_field(14)
    discard_sectors: int = betterproto.uint64_field(15)
    discard_time_ms: int = betterproto.uint64_field(16)


@dataclass(eq=False, repr=False)
class EtcdLeaveClusterRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class EtcdLeaveCluster(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdLeaveClusterResponse(betterproto.Message):
    messages: List["EtcdLeaveCluster"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdRemoveMemberRequest(betterproto.Message):
    member: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class EtcdRemoveMember(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdRemoveMemberResponse(betterproto.Message):
    messages: List["EtcdRemoveMember"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdRemoveMemberByIdRequest(betterproto.Message):
    member_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class EtcdRemoveMemberById(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdRemoveMemberByIdResponse(betterproto.Message):
    messages: List["EtcdRemoveMemberById"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdForfeitLeadershipRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class EtcdForfeitLeadership(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    member: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class EtcdForfeitLeadershipResponse(betterproto.Message):
    messages: List["EtcdForfeitLeadership"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdMemberListRequest(betterproto.Message):
    query_local: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class EtcdMember(betterproto.Message):
    """EtcdMember describes a single etcd member."""

    id: int = betterproto.uint64_field(2)
    """member ID."""

    hostname: str = betterproto.string_field(3)
    """human-readable name of the member."""

    peer_urls: List[str] = betterproto.string_field(4)
    """the list of URLs the member exposes to clients for communication."""

    client_urls: List[str] = betterproto.string_field(5)
    """
    the list of URLs the member exposes to the cluster for communication.
    """

    is_learner: bool = betterproto.bool_field(6)
    """learner flag"""


@dataclass(eq=False, repr=False)
class EtcdMembers(betterproto.Message):
    """EtcdMembers contains the list of members registered on the host."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    legacy_members: List[str] = betterproto.string_field(2)
    """list of member hostnames."""

    members: List["EtcdMember"] = betterproto.message_field(3)
    """the list of etcd members registered on the node."""


@dataclass(eq=False, repr=False)
class EtcdMemberListResponse(betterproto.Message):
    messages: List["EtcdMembers"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdSnapshotRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class EtcdRecover(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdRecoverResponse(betterproto.Message):
    messages: List["EtcdRecover"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdAlarmListResponse(betterproto.Message):
    messages: List["EtcdAlarm"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdAlarm(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    member_alarms: List["EtcdMemberAlarm"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EtcdMemberAlarm(betterproto.Message):
    member_id: int = betterproto.uint64_field(1)
    alarm: "EtcdMemberAlarmAlarmType" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class EtcdAlarmDisarmResponse(betterproto.Message):
    messages: List["EtcdAlarmDisarm"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdAlarmDisarm(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    member_alarms: List["EtcdMemberAlarm"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EtcdDefragmentResponse(betterproto.Message):
    messages: List["EtcdDefragment"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdDefragment(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdStatusResponse(betterproto.Message):
    messages: List["EtcdStatus"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EtcdStatus(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    member_status: "EtcdMemberStatus" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EtcdMemberStatus(betterproto.Message):
    member_id: int = betterproto.uint64_field(10)
    protocol_version: str = betterproto.string_field(1)
    db_size: int = betterproto.int64_field(2)
    db_size_in_use: int = betterproto.int64_field(3)
    leader: int = betterproto.uint64_field(4)
    raft_index: int = betterproto.uint64_field(5)
    raft_term: int = betterproto.uint64_field(6)
    raft_applied_index: int = betterproto.uint64_field(7)
    errors: List[str] = betterproto.string_field(8)
    is_learner: bool = betterproto.bool_field(9)


@dataclass(eq=False, repr=False)
class RouteConfig(betterproto.Message):
    network: str = betterproto.string_field(1)
    gateway: str = betterproto.string_field(2)
    metric: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class DhcpOptionsConfig(betterproto.Message):
    route_metric: int = betterproto.uint32_field(1)


@dataclass(eq=False, repr=False)
class NetworkDeviceConfig(betterproto.Message):
    interface: str = betterproto.string_field(1)
    cidr: str = betterproto.string_field(2)
    mtu: int = betterproto.int32_field(3)
    dhcp: bool = betterproto.bool_field(4)
    ignore: bool = betterproto.bool_field(5)
    dhcp_options: "DhcpOptionsConfig" = betterproto.message_field(6)
    routes: List["RouteConfig"] = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class NetworkConfig(betterproto.Message):
    hostname: str = betterproto.string_field(1)
    interfaces: List["NetworkDeviceConfig"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class InstallConfig(betterproto.Message):
    install_disk: str = betterproto.string_field(1)
    install_image: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MachineConfig(betterproto.Message):
    type: "MachineConfigMachineType" = betterproto.enum_field(1)
    install_config: "InstallConfig" = betterproto.message_field(2)
    network_config: "NetworkConfig" = betterproto.message_field(3)
    kubernetes_version: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class ControlPlaneConfig(betterproto.Message):
    endpoint: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CniConfig(betterproto.Message):
    name: str = betterproto.string_field(1)
    urls: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ClusterNetworkConfig(betterproto.Message):
    dns_domain: str = betterproto.string_field(1)
    cni_config: "CniConfig" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ClusterConfig(betterproto.Message):
    name: str = betterproto.string_field(1)
    control_plane: "ControlPlaneConfig" = betterproto.message_field(2)
    cluster_network: "ClusterNetworkConfig" = betterproto.message_field(3)
    allow_scheduling_on_control_planes: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class GenerateConfigurationRequest(betterproto.Message):
    """
    GenerateConfigurationRequest describes a request to generate a new
    configuration on a node.
    """

    config_version: str = betterproto.string_field(1)
    cluster_config: "ClusterConfig" = betterproto.message_field(2)
    machine_config: "MachineConfig" = betterproto.message_field(3)
    override_time: datetime = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class GenerateConfiguration(betterproto.Message):
    """
    GenerateConfiguration describes the response to a generate configuration
    request.
    """

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    data: List[bytes] = betterproto.bytes_field(2)
    talosconfig: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class GenerateConfigurationResponse(betterproto.Message):
    messages: List["GenerateConfiguration"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GenerateClientConfigurationRequest(betterproto.Message):
    roles: List[str] = betterproto.string_field(1)
    """Roles in the generated client certificate."""

    crt_ttl: timedelta = betterproto.message_field(2)
    """Client certificate TTL."""


@dataclass(eq=False, repr=False)
class GenerateClientConfiguration(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    ca: bytes = betterproto.bytes_field(2)
    """PEM-encoded CA certificate."""

    crt: bytes = betterproto.bytes_field(3)
    """PEM-encoded generated client certificate."""

    key: bytes = betterproto.bytes_field(4)
    """PEM-encoded generated client key."""

    talosconfig: bytes = betterproto.bytes_field(5)
    """Client configuration (talosconfig) file content."""


@dataclass(eq=False, repr=False)
class GenerateClientConfigurationResponse(betterproto.Message):
    messages: List["GenerateClientConfiguration"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class PacketCaptureRequest(betterproto.Message):
    interface: str = betterproto.string_field(1)
    """Interface name to perform packet capture on."""

    promiscuous: bool = betterproto.bool_field(2)
    """Enable promiscuous mode."""

    snap_len: int = betterproto.uint32_field(3)
    """Snap length in bytes."""

    bpf_filter: List["BpfInstruction"] = betterproto.message_field(4)
    """BPF filter."""


@dataclass(eq=False, repr=False)
class BpfInstruction(betterproto.Message):
    op: int = betterproto.uint32_field(1)
    jt: int = betterproto.uint32_field(2)
    jf: int = betterproto.uint32_field(3)
    k: int = betterproto.uint32_field(4)


@dataclass(eq=False, repr=False)
class NetstatRequest(betterproto.Message):
    filter: "NetstatRequestFilter" = betterproto.enum_field(1)
    feature: "NetstatRequestFeature" = betterproto.message_field(2)
    l4_proto: "NetstatRequestL4Proto" = betterproto.message_field(3)
    netns: "NetstatRequestNetNs" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class NetstatRequestFeature(betterproto.Message):
    pid: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class NetstatRequestL4Proto(betterproto.Message):
    tcp: bool = betterproto.bool_field(1)
    tcp6: bool = betterproto.bool_field(2)
    udp: bool = betterproto.bool_field(3)
    udp6: bool = betterproto.bool_field(4)
    udplite: bool = betterproto.bool_field(5)
    udplite6: bool = betterproto.bool_field(6)
    raw: bool = betterproto.bool_field(7)
    raw6: bool = betterproto.bool_field(8)


@dataclass(eq=False, repr=False)
class NetstatRequestNetNs(betterproto.Message):
    hostnetwork: bool = betterproto.bool_field(1)
    netns: List[str] = betterproto.string_field(2)
    allnetns: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class ConnectRecord(betterproto.Message):
    l4_proto: str = betterproto.string_field(1)
    localip: str = betterproto.string_field(2)
    localport: int = betterproto.uint32_field(3)
    remoteip: str = betterproto.string_field(4)
    remoteport: int = betterproto.uint32_field(5)
    state: "ConnectRecordState" = betterproto.enum_field(6)
    txqueue: int = betterproto.uint64_field(7)
    rxqueue: int = betterproto.uint64_field(8)
    tr: "ConnectRecordTimerActive" = betterproto.enum_field(9)
    timerwhen: int = betterproto.uint64_field(10)
    retrnsmt: int = betterproto.uint64_field(11)
    uid: int = betterproto.uint32_field(12)
    timeout: int = betterproto.uint64_field(13)
    inode: int = betterproto.uint64_field(14)
    ref: int = betterproto.uint64_field(15)
    pointer: int = betterproto.uint64_field(16)
    process: "ConnectRecordProcess" = betterproto.message_field(17)
    netns: str = betterproto.string_field(18)


@dataclass(eq=False, repr=False)
class ConnectRecordProcess(betterproto.Message):
    pid: int = betterproto.uint32_field(1)
    name: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Netstat(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    connectrecord: List["ConnectRecord"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class NetstatResponse(betterproto.Message):
    messages: List["Netstat"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MetaWriteRequest(betterproto.Message):
    key: int = betterproto.uint32_field(1)
    value: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class MetaWrite(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MetaWriteResponse(betterproto.Message):
    messages: List["MetaWrite"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MetaDeleteRequest(betterproto.Message):
    key: int = betterproto.uint32_field(1)


@dataclass(eq=False, repr=False)
class MetaDelete(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MetaDeleteResponse(betterproto.Message):
    messages: List["MetaDelete"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ImageListRequest(betterproto.Message):
    namespace: "_common__.ContainerdNamespace" = betterproto.enum_field(1)
    """Containerd namespace to use."""


@dataclass(eq=False, repr=False)
class ImageListResponse(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)
    name: str = betterproto.string_field(2)
    digest: str = betterproto.string_field(3)
    size: int = betterproto.int64_field(4)
    created_at: datetime = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class ImagePullRequest(betterproto.Message):
    namespace: "_common__.ContainerdNamespace" = betterproto.enum_field(1)
    """Containerd namespace to use."""

    reference: str = betterproto.string_field(2)
    """Image reference to pull."""


@dataclass(eq=False, repr=False)
class ImagePull(betterproto.Message):
    metadata: "_common__.Metadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ImagePullResponse(betterproto.Message):
    messages: List["ImagePull"] = betterproto.message_field(1)


class MachineServiceStub(betterproto.ServiceStub):
    async def apply_configuration(
        self,
        apply_configuration_request: "ApplyConfigurationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ApplyConfigurationResponse":
        return await self._unary_unary(
            "/machine.MachineService/ApplyConfiguration",
            apply_configuration_request,
            ApplyConfigurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def bootstrap(
        self,
        bootstrap_request: "BootstrapRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "BootstrapResponse":
        return await self._unary_unary(
            "/machine.MachineService/Bootstrap",
            bootstrap_request,
            BootstrapResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def containers(
        self,
        containers_request: "ContainersRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ContainersResponse":
        return await self._unary_unary(
            "/machine.MachineService/Containers",
            containers_request,
            ContainersResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def copy(
        self,
        copy_request: "CopyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["_common__.Data"]:
        async for response in self._unary_stream(
            "/machine.MachineService/Copy",
            copy_request,
            _common__.Data,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def cpu_info(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CpuInfoResponse":
        return await self._unary_unary(
            "/machine.MachineService/CPUInfo",
            betterproto_lib_google_protobuf_empty,
            CpuInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def disk_stats(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DiskStatsResponse":
        return await self._unary_unary(
            "/machine.MachineService/DiskStats",
            betterproto_lib_google_protobuf_empty,
            DiskStatsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def dmesg(
        self,
        dmesg_request: "DmesgRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["_common__.Data"]:
        async for response in self._unary_stream(
            "/machine.MachineService/Dmesg",
            dmesg_request,
            _common__.Data,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def events(
        self,
        events_request: "EventsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["Event"]:
        async for response in self._unary_stream(
            "/machine.MachineService/Events",
            events_request,
            Event,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def etcd_member_list(
        self,
        etcd_member_list_request: "EtcdMemberListRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdMemberListResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdMemberList",
            etcd_member_list_request,
            EtcdMemberListResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_remove_member(
        self,
        etcd_remove_member_request: "EtcdRemoveMemberRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdRemoveMemberResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdRemoveMember",
            etcd_remove_member_request,
            EtcdRemoveMemberResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_remove_member_by_id(
        self,
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdRemoveMemberByIdResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdRemoveMemberByID",
            etcd_remove_member_by_id_request,
            EtcdRemoveMemberByIdResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_leave_cluster(
        self,
        etcd_leave_cluster_request: "EtcdLeaveClusterRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdLeaveClusterResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdLeaveCluster",
            etcd_leave_cluster_request,
            EtcdLeaveClusterResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_forfeit_leadership(
        self,
        etcd_forfeit_leadership_request: "EtcdForfeitLeadershipRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdForfeitLeadershipResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdForfeitLeadership",
            etcd_forfeit_leadership_request,
            EtcdForfeitLeadershipResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_recover(
        self,
        common_data_iterator: Union[
            AsyncIterable["_common__.Data"], Iterable["_common__.Data"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdRecoverResponse":
        return await self._stream_unary(
            "/machine.MachineService/EtcdRecover",
            common_data_iterator,
            _common__.Data,
            EtcdRecoverResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_snapshot(
        self,
        etcd_snapshot_request: "EtcdSnapshotRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["_common__.Data"]:
        async for response in self._unary_stream(
            "/machine.MachineService/EtcdSnapshot",
            etcd_snapshot_request,
            _common__.Data,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def etcd_alarm_list(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdAlarmListResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdAlarmList",
            betterproto_lib_google_protobuf_empty,
            EtcdAlarmListResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_alarm_disarm(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdAlarmDisarmResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdAlarmDisarm",
            betterproto_lib_google_protobuf_empty,
            EtcdAlarmDisarmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_defragment(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdDefragmentResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdDefragment",
            betterproto_lib_google_protobuf_empty,
            EtcdDefragmentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def etcd_status(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EtcdStatusResponse":
        return await self._unary_unary(
            "/machine.MachineService/EtcdStatus",
            betterproto_lib_google_protobuf_empty,
            EtcdStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def generate_configuration(
        self,
        generate_configuration_request: "GenerateConfigurationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GenerateConfigurationResponse":
        return await self._unary_unary(
            "/machine.MachineService/GenerateConfiguration",
            generate_configuration_request,
            GenerateConfigurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def hostname(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "HostnameResponse":
        return await self._unary_unary(
            "/machine.MachineService/Hostname",
            betterproto_lib_google_protobuf_empty,
            HostnameResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def kubeconfig(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["_common__.Data"]:
        async for response in self._unary_stream(
            "/machine.MachineService/Kubeconfig",
            betterproto_lib_google_protobuf_empty,
            _common__.Data,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def list(
        self,
        list_request: "ListRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["FileInfo"]:
        async for response in self._unary_stream(
            "/machine.MachineService/List",
            list_request,
            FileInfo,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def disk_usage(
        self,
        disk_usage_request: "DiskUsageRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DiskUsageInfo"]:
        async for response in self._unary_stream(
            "/machine.MachineService/DiskUsage",
            disk_usage_request,
            DiskUsageInfo,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def load_avg(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "LoadAvgResponse":
        return await self._unary_unary(
            "/machine.MachineService/LoadAvg",
            betterproto_lib_google_protobuf_empty,
            LoadAvgResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def logs(
        self,
        logs_request: "LogsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["_common__.Data"]:
        async for response in self._unary_stream(
            "/machine.MachineService/Logs",
            logs_request,
            _common__.Data,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def memory(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MemoryResponse":
        return await self._unary_unary(
            "/machine.MachineService/Memory",
            betterproto_lib_google_protobuf_empty,
            MemoryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def mounts(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MountsResponse":
        return await self._unary_unary(
            "/machine.MachineService/Mounts",
            betterproto_lib_google_protobuf_empty,
            MountsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def network_device_stats(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "NetworkDeviceStatsResponse":
        return await self._unary_unary(
            "/machine.MachineService/NetworkDeviceStats",
            betterproto_lib_google_protobuf_empty,
            NetworkDeviceStatsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def processes(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ProcessesResponse":
        return await self._unary_unary(
            "/machine.MachineService/Processes",
            betterproto_lib_google_protobuf_empty,
            ProcessesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def read(
        self,
        read_request: "ReadRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["_common__.Data"]:
        async for response in self._unary_stream(
            "/machine.MachineService/Read",
            read_request,
            _common__.Data,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def reboot(
        self,
        reboot_request: "RebootRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RebootResponse":
        return await self._unary_unary(
            "/machine.MachineService/Reboot",
            reboot_request,
            RebootResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def restart(
        self,
        restart_request: "RestartRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RestartResponse":
        return await self._unary_unary(
            "/machine.MachineService/Restart",
            restart_request,
            RestartResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def rollback(
        self,
        rollback_request: "RollbackRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RollbackResponse":
        return await self._unary_unary(
            "/machine.MachineService/Rollback",
            rollback_request,
            RollbackResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def reset(
        self,
        reset_request: "ResetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResetResponse":
        return await self._unary_unary(
            "/machine.MachineService/Reset",
            reset_request,
            ResetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def service_list(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ServiceListResponse":
        return await self._unary_unary(
            "/machine.MachineService/ServiceList",
            betterproto_lib_google_protobuf_empty,
            ServiceListResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def service_restart(
        self,
        service_restart_request: "ServiceRestartRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ServiceRestartResponse":
        return await self._unary_unary(
            "/machine.MachineService/ServiceRestart",
            service_restart_request,
            ServiceRestartResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def service_start(
        self,
        service_start_request: "ServiceStartRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ServiceStartResponse":
        return await self._unary_unary(
            "/machine.MachineService/ServiceStart",
            service_start_request,
            ServiceStartResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def service_stop(
        self,
        service_stop_request: "ServiceStopRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ServiceStopResponse":
        return await self._unary_unary(
            "/machine.MachineService/ServiceStop",
            service_stop_request,
            ServiceStopResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def shutdown(
        self,
        shutdown_request: "ShutdownRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ShutdownResponse":
        return await self._unary_unary(
            "/machine.MachineService/Shutdown",
            shutdown_request,
            ShutdownResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def stats(
        self,
        stats_request: "StatsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StatsResponse":
        return await self._unary_unary(
            "/machine.MachineService/Stats",
            stats_request,
            StatsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def system_stat(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SystemStatResponse":
        return await self._unary_unary(
            "/machine.MachineService/SystemStat",
            betterproto_lib_google_protobuf_empty,
            SystemStatResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def upgrade(
        self,
        upgrade_request: "UpgradeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpgradeResponse":
        return await self._unary_unary(
            "/machine.MachineService/Upgrade",
            upgrade_request,
            UpgradeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def version(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "VersionResponse":
        return await self._unary_unary(
            "/machine.MachineService/Version",
            betterproto_lib_google_protobuf_empty,
            VersionResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def generate_client_configuration(
        self,
        generate_client_configuration_request: "GenerateClientConfigurationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GenerateClientConfigurationResponse":
        return await self._unary_unary(
            "/machine.MachineService/GenerateClientConfiguration",
            generate_client_configuration_request,
            GenerateClientConfigurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_capture(
        self,
        packet_capture_request: "PacketCaptureRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["_common__.Data"]:
        async for response in self._unary_stream(
            "/machine.MachineService/PacketCapture",
            packet_capture_request,
            _common__.Data,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def netstat(
        self,
        netstat_request: "NetstatRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "NetstatResponse":
        return await self._unary_unary(
            "/machine.MachineService/Netstat",
            netstat_request,
            NetstatResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def meta_write(
        self,
        meta_write_request: "MetaWriteRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MetaWriteResponse":
        return await self._unary_unary(
            "/machine.MachineService/MetaWrite",
            meta_write_request,
            MetaWriteResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def meta_delete(
        self,
        meta_delete_request: "MetaDeleteRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MetaDeleteResponse":
        return await self._unary_unary(
            "/machine.MachineService/MetaDelete",
            meta_delete_request,
            MetaDeleteResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def image_list(
        self,
        image_list_request: "ImageListRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["ImageListResponse"]:
        async for response in self._unary_stream(
            "/machine.MachineService/ImageList",
            image_list_request,
            ImageListResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def image_pull(
        self,
        image_pull_request: "ImagePullRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ImagePullResponse":
        return await self._unary_unary(
            "/machine.MachineService/ImagePull",
            image_pull_request,
            ImagePullResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MachineServiceBase(ServiceBase):
    async def apply_configuration(
        self, apply_configuration_request: "ApplyConfigurationRequest"
    ) -> "ApplyConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def bootstrap(
        self, bootstrap_request: "BootstrapRequest"
    ) -> "BootstrapResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def containers(
        self, containers_request: "ContainersRequest"
    ) -> "ContainersResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def copy(
        self, copy_request: "CopyRequest"
    ) -> AsyncIterator["_common__.Data"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def cpu_info(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "CpuInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def disk_stats(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "DiskStatsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def dmesg(
        self, dmesg_request: "DmesgRequest"
    ) -> AsyncIterator["_common__.Data"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def events(self, events_request: "EventsRequest") -> AsyncIterator["Event"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_member_list(
        self, etcd_member_list_request: "EtcdMemberListRequest"
    ) -> "EtcdMemberListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_remove_member(
        self, etcd_remove_member_request: "EtcdRemoveMemberRequest"
    ) -> "EtcdRemoveMemberResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_remove_member_by_id(self) -> "EtcdRemoveMemberByIdResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_leave_cluster(
        self, etcd_leave_cluster_request: "EtcdLeaveClusterRequest"
    ) -> "EtcdLeaveClusterResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_forfeit_leadership(
        self, etcd_forfeit_leadership_request: "EtcdForfeitLeadershipRequest"
    ) -> "EtcdForfeitLeadershipResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_recover(
        self, common_data_iterator: AsyncIterator["_common__.Data"]
    ) -> "EtcdRecoverResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_snapshot(
        self, etcd_snapshot_request: "EtcdSnapshotRequest"
    ) -> AsyncIterator["_common__.Data"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_alarm_list(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "EtcdAlarmListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_alarm_disarm(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "EtcdAlarmDisarmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_defragment(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "EtcdDefragmentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def etcd_status(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "EtcdStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def generate_configuration(
        self, generate_configuration_request: "GenerateConfigurationRequest"
    ) -> "GenerateConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def hostname(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "HostnameResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def kubeconfig(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> AsyncIterator["_common__.Data"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list(self, list_request: "ListRequest") -> AsyncIterator["FileInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def disk_usage(
        self, disk_usage_request: "DiskUsageRequest"
    ) -> AsyncIterator["DiskUsageInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def load_avg(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "LoadAvgResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def logs(
        self, logs_request: "LogsRequest"
    ) -> AsyncIterator["_common__.Data"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def memory(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "MemoryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def mounts(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "MountsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def network_device_stats(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "NetworkDeviceStatsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def processes(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "ProcessesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def read(
        self, read_request: "ReadRequest"
    ) -> AsyncIterator["_common__.Data"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def reboot(self, reboot_request: "RebootRequest") -> "RebootResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def restart(self, restart_request: "RestartRequest") -> "RestartResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def rollback(self, rollback_request: "RollbackRequest") -> "RollbackResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def reset(self, reset_request: "ResetRequest") -> "ResetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def service_list(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "ServiceListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def service_restart(
        self, service_restart_request: "ServiceRestartRequest"
    ) -> "ServiceRestartResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def service_start(
        self, service_start_request: "ServiceStartRequest"
    ) -> "ServiceStartResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def service_stop(
        self, service_stop_request: "ServiceStopRequest"
    ) -> "ServiceStopResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def shutdown(self, shutdown_request: "ShutdownRequest") -> "ShutdownResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def stats(self, stats_request: "StatsRequest") -> "StatsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def system_stat(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "SystemStatResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def upgrade(self, upgrade_request: "UpgradeRequest") -> "UpgradeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def version(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "VersionResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def generate_client_configuration(
        self,
        generate_client_configuration_request: "GenerateClientConfigurationRequest",
    ) -> "GenerateClientConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_capture(
        self, packet_capture_request: "PacketCaptureRequest"
    ) -> AsyncIterator["_common__.Data"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def netstat(self, netstat_request: "NetstatRequest") -> "NetstatResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def meta_write(
        self, meta_write_request: "MetaWriteRequest"
    ) -> "MetaWriteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def meta_delete(
        self, meta_delete_request: "MetaDeleteRequest"
    ) -> "MetaDeleteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def image_list(
        self, image_list_request: "ImageListRequest"
    ) -> AsyncIterator["ImageListResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def image_pull(
        self, image_pull_request: "ImagePullRequest"
    ) -> "ImagePullResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_apply_configuration(
        self,
        stream: "grpclib.server.Stream[ApplyConfigurationRequest, ApplyConfigurationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.apply_configuration(request)
        await stream.send_message(response)

    async def __rpc_bootstrap(
        self, stream: "grpclib.server.Stream[BootstrapRequest, BootstrapResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.bootstrap(request)
        await stream.send_message(response)

    async def __rpc_containers(
        self, stream: "grpclib.server.Stream[ContainersRequest, ContainersResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.containers(request)
        await stream.send_message(response)

    async def __rpc_copy(
        self, stream: "grpclib.server.Stream[CopyRequest, _common__.Data]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.copy,
            stream,
            request,
        )

    async def __rpc_cpu_info(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, CpuInfoResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.cpu_info(request)
        await stream.send_message(response)

    async def __rpc_disk_stats(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, DiskStatsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.disk_stats(request)
        await stream.send_message(response)

    async def __rpc_dmesg(
        self, stream: "grpclib.server.Stream[DmesgRequest, _common__.Data]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.dmesg,
            stream,
            request,
        )

    async def __rpc_events(
        self, stream: "grpclib.server.Stream[EventsRequest, Event]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.events,
            stream,
            request,
        )

    async def __rpc_etcd_member_list(
        self,
        stream: "grpclib.server.Stream[EtcdMemberListRequest, EtcdMemberListResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_member_list(request)
        await stream.send_message(response)

    async def __rpc_etcd_remove_member(
        self,
        stream: "grpclib.server.Stream[EtcdRemoveMemberRequest, EtcdRemoveMemberResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_remove_member(request)
        await stream.send_message(response)

    async def __rpc_etcd_remove_member_by_id(
        self,
        stream: "grpclib.server.Stream[EtcdRemoveMemberByIdRequest, EtcdRemoveMemberByIdResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_remove_member_by_id(request)
        await stream.send_message(response)

    async def __rpc_etcd_leave_cluster(
        self,
        stream: "grpclib.server.Stream[EtcdLeaveClusterRequest, EtcdLeaveClusterResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_leave_cluster(request)
        await stream.send_message(response)

    async def __rpc_etcd_forfeit_leadership(
        self,
        stream: "grpclib.server.Stream[EtcdForfeitLeadershipRequest, EtcdForfeitLeadershipResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_forfeit_leadership(request)
        await stream.send_message(response)

    async def __rpc_etcd_recover(
        self, stream: "grpclib.server.Stream[_common__.Data, EtcdRecoverResponse]"
    ) -> None:
        request = stream.__aiter__()
        response = await self.etcd_recover(request)
        await stream.send_message(response)

    async def __rpc_etcd_snapshot(
        self, stream: "grpclib.server.Stream[EtcdSnapshotRequest, _common__.Data]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.etcd_snapshot,
            stream,
            request,
        )

    async def __rpc_etcd_alarm_list(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, EtcdAlarmListResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_alarm_list(request)
        await stream.send_message(response)

    async def __rpc_etcd_alarm_disarm(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, EtcdAlarmDisarmResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_alarm_disarm(request)
        await stream.send_message(response)

    async def __rpc_etcd_defragment(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, EtcdDefragmentResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_defragment(request)
        await stream.send_message(response)

    async def __rpc_etcd_status(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, EtcdStatusResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.etcd_status(request)
        await stream.send_message(response)

    async def __rpc_generate_configuration(
        self,
        stream: "grpclib.server.Stream[GenerateConfigurationRequest, GenerateConfigurationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.generate_configuration(request)
        await stream.send_message(response)

    async def __rpc_hostname(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, HostnameResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.hostname(request)
        await stream.send_message(response)

    async def __rpc_kubeconfig(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, _common__.Data]",
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.kubeconfig,
            stream,
            request,
        )

    async def __rpc_list(
        self, stream: "grpclib.server.Stream[ListRequest, FileInfo]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.list,
            stream,
            request,
        )

    async def __rpc_disk_usage(
        self, stream: "grpclib.server.Stream[DiskUsageRequest, DiskUsageInfo]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.disk_usage,
            stream,
            request,
        )

    async def __rpc_load_avg(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, LoadAvgResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.load_avg(request)
        await stream.send_message(response)

    async def __rpc_logs(
        self, stream: "grpclib.server.Stream[LogsRequest, _common__.Data]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.logs,
            stream,
            request,
        )

    async def __rpc_memory(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, MemoryResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.memory(request)
        await stream.send_message(response)

    async def __rpc_mounts(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, MountsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.mounts(request)
        await stream.send_message(response)

    async def __rpc_network_device_stats(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, NetworkDeviceStatsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.network_device_stats(request)
        await stream.send_message(response)

    async def __rpc_processes(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, ProcessesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.processes(request)
        await stream.send_message(response)

    async def __rpc_read(
        self, stream: "grpclib.server.Stream[ReadRequest, _common__.Data]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.read,
            stream,
            request,
        )

    async def __rpc_reboot(
        self, stream: "grpclib.server.Stream[RebootRequest, RebootResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.reboot(request)
        await stream.send_message(response)

    async def __rpc_restart(
        self, stream: "grpclib.server.Stream[RestartRequest, RestartResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.restart(request)
        await stream.send_message(response)

    async def __rpc_rollback(
        self, stream: "grpclib.server.Stream[RollbackRequest, RollbackResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.rollback(request)
        await stream.send_message(response)

    async def __rpc_reset(
        self, stream: "grpclib.server.Stream[ResetRequest, ResetResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.reset(request)
        await stream.send_message(response)

    async def __rpc_service_list(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, ServiceListResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.service_list(request)
        await stream.send_message(response)

    async def __rpc_service_restart(
        self,
        stream: "grpclib.server.Stream[ServiceRestartRequest, ServiceRestartResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.service_restart(request)
        await stream.send_message(response)

    async def __rpc_service_start(
        self, stream: "grpclib.server.Stream[ServiceStartRequest, ServiceStartResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.service_start(request)
        await stream.send_message(response)

    async def __rpc_service_stop(
        self, stream: "grpclib.server.Stream[ServiceStopRequest, ServiceStopResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.service_stop(request)
        await stream.send_message(response)

    async def __rpc_shutdown(
        self, stream: "grpclib.server.Stream[ShutdownRequest, ShutdownResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.shutdown(request)
        await stream.send_message(response)

    async def __rpc_stats(
        self, stream: "grpclib.server.Stream[StatsRequest, StatsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.stats(request)
        await stream.send_message(response)

    async def __rpc_system_stat(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, SystemStatResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.system_stat(request)
        await stream.send_message(response)

    async def __rpc_upgrade(
        self, stream: "grpclib.server.Stream[UpgradeRequest, UpgradeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.upgrade(request)
        await stream.send_message(response)

    async def __rpc_version(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, VersionResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.version(request)
        await stream.send_message(response)

    async def __rpc_generate_client_configuration(
        self,
        stream: "grpclib.server.Stream[GenerateClientConfigurationRequest, GenerateClientConfigurationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.generate_client_configuration(request)
        await stream.send_message(response)

    async def __rpc_packet_capture(
        self, stream: "grpclib.server.Stream[PacketCaptureRequest, _common__.Data]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.packet_capture,
            stream,
            request,
        )

    async def __rpc_netstat(
        self, stream: "grpclib.server.Stream[NetstatRequest, NetstatResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.netstat(request)
        await stream.send_message(response)

    async def __rpc_meta_write(
        self, stream: "grpclib.server.Stream[MetaWriteRequest, MetaWriteResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.meta_write(request)
        await stream.send_message(response)

    async def __rpc_meta_delete(
        self, stream: "grpclib.server.Stream[MetaDeleteRequest, MetaDeleteResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.meta_delete(request)
        await stream.send_message(response)

    async def __rpc_image_list(
        self, stream: "grpclib.server.Stream[ImageListRequest, ImageListResponse]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.image_list,
            stream,
            request,
        )

    async def __rpc_image_pull(
        self, stream: "grpclib.server.Stream[ImagePullRequest, ImagePullResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.image_pull(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/machine.MachineService/ApplyConfiguration": grpclib.const.Handler(
                self.__rpc_apply_configuration,
                grpclib.const.Cardinality.UNARY_UNARY,
                ApplyConfigurationRequest,
                ApplyConfigurationResponse,
            ),
            "/machine.MachineService/Bootstrap": grpclib.const.Handler(
                self.__rpc_bootstrap,
                grpclib.const.Cardinality.UNARY_UNARY,
                BootstrapRequest,
                BootstrapResponse,
            ),
            "/machine.MachineService/Containers": grpclib.const.Handler(
                self.__rpc_containers,
                grpclib.const.Cardinality.UNARY_UNARY,
                ContainersRequest,
                ContainersResponse,
            ),
            "/machine.MachineService/Copy": grpclib.const.Handler(
                self.__rpc_copy,
                grpclib.const.Cardinality.UNARY_STREAM,
                CopyRequest,
                _common__.Data,
            ),
            "/machine.MachineService/CPUInfo": grpclib.const.Handler(
                self.__rpc_cpu_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                CpuInfoResponse,
            ),
            "/machine.MachineService/DiskStats": grpclib.const.Handler(
                self.__rpc_disk_stats,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                DiskStatsResponse,
            ),
            "/machine.MachineService/Dmesg": grpclib.const.Handler(
                self.__rpc_dmesg,
                grpclib.const.Cardinality.UNARY_STREAM,
                DmesgRequest,
                _common__.Data,
            ),
            "/machine.MachineService/Events": grpclib.const.Handler(
                self.__rpc_events,
                grpclib.const.Cardinality.UNARY_STREAM,
                EventsRequest,
                Event,
            ),
            "/machine.MachineService/EtcdMemberList": grpclib.const.Handler(
                self.__rpc_etcd_member_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                EtcdMemberListRequest,
                EtcdMemberListResponse,
            ),
            "/machine.MachineService/EtcdRemoveMember": grpclib.const.Handler(
                self.__rpc_etcd_remove_member,
                grpclib.const.Cardinality.UNARY_UNARY,
                EtcdRemoveMemberRequest,
                EtcdRemoveMemberResponse,
            ),
            "/machine.MachineService/EtcdRemoveMemberByID": grpclib.const.Handler(
                self.__rpc_etcd_remove_member_by_id,
                grpclib.const.Cardinality.UNARY_UNARY,
                EtcdRemoveMemberByIdRequest,
                EtcdRemoveMemberByIdResponse,
            ),
            "/machine.MachineService/EtcdLeaveCluster": grpclib.const.Handler(
                self.__rpc_etcd_leave_cluster,
                grpclib.const.Cardinality.UNARY_UNARY,
                EtcdLeaveClusterRequest,
                EtcdLeaveClusterResponse,
            ),
            "/machine.MachineService/EtcdForfeitLeadership": grpclib.const.Handler(
                self.__rpc_etcd_forfeit_leadership,
                grpclib.const.Cardinality.UNARY_UNARY,
                EtcdForfeitLeadershipRequest,
                EtcdForfeitLeadershipResponse,
            ),
            "/machine.MachineService/EtcdRecover": grpclib.const.Handler(
                self.__rpc_etcd_recover,
                grpclib.const.Cardinality.STREAM_UNARY,
                _common__.Data,
                EtcdRecoverResponse,
            ),
            "/machine.MachineService/EtcdSnapshot": grpclib.const.Handler(
                self.__rpc_etcd_snapshot,
                grpclib.const.Cardinality.UNARY_STREAM,
                EtcdSnapshotRequest,
                _common__.Data,
            ),
            "/machine.MachineService/EtcdAlarmList": grpclib.const.Handler(
                self.__rpc_etcd_alarm_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                EtcdAlarmListResponse,
            ),
            "/machine.MachineService/EtcdAlarmDisarm": grpclib.const.Handler(
                self.__rpc_etcd_alarm_disarm,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                EtcdAlarmDisarmResponse,
            ),
            "/machine.MachineService/EtcdDefragment": grpclib.const.Handler(
                self.__rpc_etcd_defragment,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                EtcdDefragmentResponse,
            ),
            "/machine.MachineService/EtcdStatus": grpclib.const.Handler(
                self.__rpc_etcd_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                EtcdStatusResponse,
            ),
            "/machine.MachineService/GenerateConfiguration": grpclib.const.Handler(
                self.__rpc_generate_configuration,
                grpclib.const.Cardinality.UNARY_UNARY,
                GenerateConfigurationRequest,
                GenerateConfigurationResponse,
            ),
            "/machine.MachineService/Hostname": grpclib.const.Handler(
                self.__rpc_hostname,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                HostnameResponse,
            ),
            "/machine.MachineService/Kubeconfig": grpclib.const.Handler(
                self.__rpc_kubeconfig,
                grpclib.const.Cardinality.UNARY_STREAM,
                betterproto_lib_google_protobuf.Empty,
                _common__.Data,
            ),
            "/machine.MachineService/List": grpclib.const.Handler(
                self.__rpc_list,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListRequest,
                FileInfo,
            ),
            "/machine.MachineService/DiskUsage": grpclib.const.Handler(
                self.__rpc_disk_usage,
                grpclib.const.Cardinality.UNARY_STREAM,
                DiskUsageRequest,
                DiskUsageInfo,
            ),
            "/machine.MachineService/LoadAvg": grpclib.const.Handler(
                self.__rpc_load_avg,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                LoadAvgResponse,
            ),
            "/machine.MachineService/Logs": grpclib.const.Handler(
                self.__rpc_logs,
                grpclib.const.Cardinality.UNARY_STREAM,
                LogsRequest,
                _common__.Data,
            ),
            "/machine.MachineService/Memory": grpclib.const.Handler(
                self.__rpc_memory,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                MemoryResponse,
            ),
            "/machine.MachineService/Mounts": grpclib.const.Handler(
                self.__rpc_mounts,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                MountsResponse,
            ),
            "/machine.MachineService/NetworkDeviceStats": grpclib.const.Handler(
                self.__rpc_network_device_stats,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                NetworkDeviceStatsResponse,
            ),
            "/machine.MachineService/Processes": grpclib.const.Handler(
                self.__rpc_processes,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                ProcessesResponse,
            ),
            "/machine.MachineService/Read": grpclib.const.Handler(
                self.__rpc_read,
                grpclib.const.Cardinality.UNARY_STREAM,
                ReadRequest,
                _common__.Data,
            ),
            "/machine.MachineService/Reboot": grpclib.const.Handler(
                self.__rpc_reboot,
                grpclib.const.Cardinality.UNARY_UNARY,
                RebootRequest,
                RebootResponse,
            ),
            "/machine.MachineService/Restart": grpclib.const.Handler(
                self.__rpc_restart,
                grpclib.const.Cardinality.UNARY_UNARY,
                RestartRequest,
                RestartResponse,
            ),
            "/machine.MachineService/Rollback": grpclib.const.Handler(
                self.__rpc_rollback,
                grpclib.const.Cardinality.UNARY_UNARY,
                RollbackRequest,
                RollbackResponse,
            ),
            "/machine.MachineService/Reset": grpclib.const.Handler(
                self.__rpc_reset,
                grpclib.const.Cardinality.UNARY_UNARY,
                ResetRequest,
                ResetResponse,
            ),
            "/machine.MachineService/ServiceList": grpclib.const.Handler(
                self.__rpc_service_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                ServiceListResponse,
            ),
            "/machine.MachineService/ServiceRestart": grpclib.const.Handler(
                self.__rpc_service_restart,
                grpclib.const.Cardinality.UNARY_UNARY,
                ServiceRestartRequest,
                ServiceRestartResponse,
            ),
            "/machine.MachineService/ServiceStart": grpclib.const.Handler(
                self.__rpc_service_start,
                grpclib.const.Cardinality.UNARY_UNARY,
                ServiceStartRequest,
                ServiceStartResponse,
            ),
            "/machine.MachineService/ServiceStop": grpclib.const.Handler(
                self.__rpc_service_stop,
                grpclib.const.Cardinality.UNARY_UNARY,
                ServiceStopRequest,
                ServiceStopResponse,
            ),
            "/machine.MachineService/Shutdown": grpclib.const.Handler(
                self.__rpc_shutdown,
                grpclib.const.Cardinality.UNARY_UNARY,
                ShutdownRequest,
                ShutdownResponse,
            ),
            "/machine.MachineService/Stats": grpclib.const.Handler(
                self.__rpc_stats,
                grpclib.const.Cardinality.UNARY_UNARY,
                StatsRequest,
                StatsResponse,
            ),
            "/machine.MachineService/SystemStat": grpclib.const.Handler(
                self.__rpc_system_stat,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                SystemStatResponse,
            ),
            "/machine.MachineService/Upgrade": grpclib.const.Handler(
                self.__rpc_upgrade,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpgradeRequest,
                UpgradeResponse,
            ),
            "/machine.MachineService/Version": grpclib.const.Handler(
                self.__rpc_version,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                VersionResponse,
            ),
            "/machine.MachineService/GenerateClientConfiguration": grpclib.const.Handler(
                self.__rpc_generate_client_configuration,
                grpclib.const.Cardinality.UNARY_UNARY,
                GenerateClientConfigurationRequest,
                GenerateClientConfigurationResponse,
            ),
            "/machine.MachineService/PacketCapture": grpclib.const.Handler(
                self.__rpc_packet_capture,
                grpclib.const.Cardinality.UNARY_STREAM,
                PacketCaptureRequest,
                _common__.Data,
            ),
            "/machine.MachineService/Netstat": grpclib.const.Handler(
                self.__rpc_netstat,
                grpclib.const.Cardinality.UNARY_UNARY,
                NetstatRequest,
                NetstatResponse,
            ),
            "/machine.MachineService/MetaWrite": grpclib.const.Handler(
                self.__rpc_meta_write,
                grpclib.const.Cardinality.UNARY_UNARY,
                MetaWriteRequest,
                MetaWriteResponse,
            ),
            "/machine.MachineService/MetaDelete": grpclib.const.Handler(
                self.__rpc_meta_delete,
                grpclib.const.Cardinality.UNARY_UNARY,
                MetaDeleteRequest,
                MetaDeleteResponse,
            ),
            "/machine.MachineService/ImageList": grpclib.const.Handler(
                self.__rpc_image_list,
                grpclib.const.Cardinality.UNARY_STREAM,
                ImageListRequest,
                ImageListResponse,
            ),
            "/machine.MachineService/ImagePull": grpclib.const.Handler(
                self.__rpc_image_pull,
                grpclib.const.Cardinality.UNARY_UNARY,
                ImagePullRequest,
                ImagePullResponse,
            ),
        }
