# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: security/security.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class CertificateRequest(betterproto.Message):
    """The request message containing the certificate signing request."""

    csr: bytes = betterproto.bytes_field(1)
    """Certificate Signing Request in PEM format."""


@dataclass(eq=False, repr=False)
class CertificateResponse(betterproto.Message):
    """The response message containing signed certificate."""

    ca: bytes = betterproto.bytes_field(1)
    """
    Certificate of the CA that signed the requested certificate in PEM format.
    """

    crt: bytes = betterproto.bytes_field(2)
    """Signed X.509 requested certificate in PEM format."""


class SecurityServiceStub(betterproto.ServiceStub):
    async def certificate(
        self,
        certificate_request: "CertificateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CertificateResponse":
        return await self._unary_unary(
            "/securityapi.SecurityService/Certificate",
            certificate_request,
            CertificateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class SecurityServiceBase(ServiceBase):
    async def certificate(
        self, certificate_request: "CertificateRequest"
    ) -> "CertificateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_certificate(
        self, stream: "grpclib.server.Stream[CertificateRequest, CertificateResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.certificate(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/securityapi.SecurityService/Certificate": grpclib.const.Handler(
                self.__rpc_certificate,
                grpclib.const.Cardinality.UNARY_UNARY,
                CertificateRequest,
                CertificateResponse,
            ),
        }
