# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: storage/storage.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from .. import common as _common__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class DiskDiskType(betterproto.Enum):
    UNKNOWN = 0
    SSD = 1
    HDD = 2
    NVME = 3
    SD = 4


@dataclass(eq=False, repr=False)
class Disk(betterproto.Message):
    """Disk represents a disk."""

    size: int = betterproto.uint64_field(1)
    """Size indicates the disk size in bytes."""

    model: str = betterproto.string_field(2)
    """Model idicates the disk model."""

    device_name: str = betterproto.string_field(3)
    """DeviceName indicates the disk name (e.g. `sda`)."""

    name: str = betterproto.string_field(4)
    """Name as in `/sys/block/<dev>/device/name`."""

    serial: str = betterproto.string_field(5)
    """Serial as in `/sys/block/<dev>/device/serial`."""

    modalias: str = betterproto.string_field(6)
    """Modalias as in `/sys/block/<dev>/device/modalias`."""

    uuid: str = betterproto.string_field(7)
    """Uuid as in `/sys/block/<dev>/device/uuid`."""

    wwid: str = betterproto.string_field(8)
    """Wwid as in `/sys/block/<dev>/device/wwid`."""

    type: "DiskDiskType" = betterproto.enum_field(9)
    """Type is a type of the disk: nvme, ssd, hdd, sd card."""

    bus_path: str = betterproto.string_field(10)
    """BusPath is the bus path of the disk."""

    system_disk: bool = betterproto.bool_field(11)
    """SystemDisk indicates that the disk is used as Talos system disk."""

    subsystem: str = betterproto.string_field(12)
    """Subsystem is the symlink path in the `/sys/block/<dev>/subsystem`."""


@dataclass(eq=False, repr=False)
class Disks(betterproto.Message):
    """DisksResponse represents the response of the `Disks` RPC."""

    metadata: "_common__.Metadata" = betterproto.message_field(1)
    disks: List["Disk"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class DisksResponse(betterproto.Message):
    messages: List["Disks"] = betterproto.message_field(1)


class StorageServiceStub(betterproto.ServiceStub):
    async def disks(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DisksResponse":
        return await self._unary_unary(
            "/storage.StorageService/Disks",
            betterproto_lib_google_protobuf_empty,
            DisksResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class StorageServiceBase(ServiceBase):
    async def disks(
        self,
        betterproto_lib_google_protobuf_empty: "betterproto_lib_google_protobuf.Empty",
    ) -> "DisksResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_disks(
        self,
        stream: "grpclib.server.Stream[betterproto_lib_google_protobuf.Empty, DisksResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.disks(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/storage.StorageService/Disks": grpclib.const.Handler(
                self.__rpc_disks,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                DisksResponse,
            ),
        }
