# type: ignore
"""TEMPORARY Create all missing optimization items for testing

Revision ID: 0d73f7467dab
Revises: c29289ced488
Create Date: 2024-07-08 14:09:49.174145

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# Revision identifiers, used by Alembic.
revision = "0d73f7467dab"
down_revision = "c29289ced488"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "optimization_equation",
        sa.Column("run__id", sa.Integer(), nullable=False),
        sa.Column(
            "data",
            sa.JSON().with_variant(
                postgresql.JSONB(astext_type=sa.Text()), "postgresql"
            ),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("created_by", sa.String(length=255), nullable=True),
        sa.ForeignKeyConstraint(
            ["run__id"], ["run.id"], name=op.f("fk_optimization_equation_run__id_run")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_optimization_equation")),
        sa.UniqueConstraint(
            "name", "run__id", name=op.f("uq_optimization_equation_name_run__id")
        ),
    )
    with op.batch_alter_table("optimization_equation", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_equation_run__id"), ["run__id"], unique=False
        )

    op.create_table(
        "optimization_optimizationvariable",
        sa.Column("run__id", sa.Integer(), nullable=False),
        sa.Column(
            "data",
            sa.JSON().with_variant(
                postgresql.JSONB(astext_type=sa.Text()), "postgresql"
            ),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("created_by", sa.String(length=255), nullable=True),
        sa.ForeignKeyConstraint(
            ["run__id"],
            ["run.id"],
            name=op.f("fk_optimization_optimizationvariable_run__id_run"),
        ),
        sa.PrimaryKeyConstraint(
            "id", name=op.f("pk_optimization_optimizationvariable")
        ),
        sa.UniqueConstraint(
            "name",
            "run__id",
            name=op.f("uq_optimization_optimizationvariable_name_run__id"),
        ),
    )
    with op.batch_alter_table(
        "optimization_optimizationvariable", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_optimizationvariable_run__id"),
            ["run__id"],
            unique=False,
        )

    op.create_table(
        "optimization_parameter",
        sa.Column("run__id", sa.Integer(), nullable=False),
        sa.Column(
            "data",
            sa.JSON().with_variant(
                postgresql.JSONB(astext_type=sa.Text()), "postgresql"
            ),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("created_by", sa.String(length=255), nullable=True),
        sa.ForeignKeyConstraint(
            ["run__id"], ["run.id"], name=op.f("fk_optimization_parameter_run__id_run")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_optimization_parameter")),
        sa.UniqueConstraint(
            "name", "run__id", name=op.f("uq_optimization_parameter_name_run__id")
        ),
    )
    with op.batch_alter_table("optimization_parameter", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_parameter_run__id"), ["run__id"], unique=False
        )

    op.create_table(
        "optimization_equation_docs",
        sa.Column("description", sa.Text(), nullable=False),
        sa.Column("dimension__id", sa.Integer(), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["dimension__id"],
            ["optimization_equation.id"],
            name=op.f(
                "fk_optimization_equation_docs_dimension__id_optimization_equation"
            ),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_optimization_equation_docs")),
        sa.UniqueConstraint(
            "dimension__id", name=op.f("uq_optimization_equation_docs_dimension__id")
        ),
    )
    op.create_table(
        "optimization_optimizationvariable_docs",
        sa.Column("description", sa.Text(), nullable=False),
        sa.Column("dimension__id", sa.Integer(), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["dimension__id"],
            ["optimization_optimizationvariable.id"],
            name=op.f(
                "fk_optimization_optimizationvariable_docs_dimension__id_optimization_optimizationvariable"
            ),
        ),
        sa.PrimaryKeyConstraint(
            "id", name=op.f("pk_optimization_optimizationvariable_docs")
        ),
        sa.UniqueConstraint(
            "dimension__id",
            name=op.f("uq_optimization_optimizationvariable_docs_dimension__id"),
        ),
    )
    op.create_table(
        "optimization_parameter_docs",
        sa.Column("description", sa.Text(), nullable=False),
        sa.Column("dimension__id", sa.Integer(), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["dimension__id"],
            ["optimization_parameter.id"],
            name=op.f(
                "fk_optimization_parameter_docs_dimension__id_optimization_parameter"
            ),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_optimization_parameter_docs")),
        sa.UniqueConstraint(
            "dimension__id", name=op.f("uq_optimization_parameter_docs_dimension__id")
        ),
    )
    with op.batch_alter_table("optimization_column", schema=None) as batch_op:
        batch_op.add_column(sa.Column("equation__id", sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column("parameter__id", sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column("variable__id", sa.Integer(), nullable=True))
        batch_op.alter_column("table__id", existing_type=sa.INTEGER(), nullable=True)
        batch_op.drop_index("ix_optimization_column_table__id")
        batch_op.create_foreign_key(
            batch_op.f(
                "fk_optimization_column_variable__id_optimization_optimizationvariable"
            ),
            "optimization_optimizationvariable",
            ["variable__id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_optimization_column_parameter__id_optimization_parameter"),
            "optimization_parameter",
            ["parameter__id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_optimization_column_equation__id_optimization_equation"),
            "optimization_equation",
            ["equation__id"],
            ["id"],
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("optimization_column", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_optimization_column_equation__id_optimization_equation"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("fk_optimization_column_parameter__id_optimization_parameter"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f(
                "fk_optimization_column_variable__id_optimization_optimizationvariable"
            ),
            type_="foreignkey",
        )
        batch_op.create_index(
            "ix_optimization_column_table__id", ["table__id"], unique=False
        )
        batch_op.alter_column("table__id", existing_type=sa.INTEGER(), nullable=False)
        batch_op.drop_column("variable__id")
        batch_op.drop_column("parameter__id")
        batch_op.drop_column("equation__id")

    op.drop_table("optimization_parameter_docs")
    op.drop_table("optimization_optimizationvariable_docs")
    op.drop_table("optimization_equation_docs")
    with op.batch_alter_table("optimization_parameter", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_optimization_parameter_run__id"))

    op.drop_table("optimization_parameter")
    with op.batch_alter_table(
        "optimization_optimizationvariable", schema=None
    ) as batch_op:
        batch_op.drop_index(batch_op.f("ix_optimization_optimizationvariable_run__id"))

    op.drop_table("optimization_optimizationvariable")
    with op.batch_alter_table("optimization_equation", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_optimization_equation_run__id"))

    op.drop_table("optimization_equation")
    # ### end Alembic commands ###
