# type: ignore
"""Create optimization_indexset table

Revision ID: da1fba23f206
Revises: c71efc396d2b
Create Date: 2023-08-30 12:29:50.037072

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# Revision identifiers, used by Alembic.
revision = "da1fba23f206"
down_revision = "c71efc396d2b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "optimization_indexset",
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column(
            "elements",
            sa.JSON().with_variant(
                postgresql.JSONB(astext_type=sa.Text()), "postgresql"
            ),
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("created_by", sa.String(length=255), nullable=True),
        sa.Column("run__id", sa.Integer(), nullable=False),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["run__id"],
            ["run.id"],
            name=op.f("fk_optimization_indexset_run__id_run"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_optimization_indexset")),
        sa.UniqueConstraint("name", name=op.f("uq_optimization_indexset_name")),
    )
    with op.batch_alter_table("optimization_indexset", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_indexset_run__id"),
            ["run__id"],
            unique=False,
        )

    op.create_table(
        "optimization_indexset_docs",
        sa.Column("description", sa.Text(), nullable=False),
        sa.Column("dimension__id", sa.Integer(), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["dimension__id"],
            ["optimization_indexset.id"],
            name=op.f(
                "fk_optimization_indexset_docs_dimension__id_optimization_indexset"
            ),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_optimization_indexset_docs")),
        sa.UniqueConstraint(
            "dimension__id",
            name=op.f("uq_optimization_indexset_docs_dimension__id"),
        ),
    )
    with op.batch_alter_table("iamc_datapoint_oracle", schema=None) as batch_op:
        batch_op.drop_index("ix_iamc_datapoint_oracle_step_category")
        batch_op.drop_index("ix_iamc_datapoint_oracle_step_datetime")
        batch_op.drop_index("ix_iamc_datapoint_oracle_step_year")
        batch_op.drop_index("ix_iamc_datapoint_oracle_time_series__id")
        batch_op.drop_index("ix_iamc_datapoint_oracle_type")

    op.drop_table("iamc_datapoint_oracle")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "iamc_datapoint_oracle",
        sa.Column("value", sa.FLOAT(), nullable=True),
        sa.Column("type", sa.VARCHAR(length=255), nullable=False),
        sa.Column("step_category", sa.VARCHAR(length=1023), nullable=True),
        sa.Column("step_year", sa.INTEGER(), nullable=True),
        sa.Column("step_datetime", sa.DATETIME(), nullable=True),
        sa.Column("time_series__id", sa.INTEGER(), nullable=False),
        sa.Column("id", sa.INTEGER(), nullable=False),
        sa.ForeignKeyConstraint(
            ["time_series__id"],
            ["iamc_timeseries.id"],
            name="fk_iamc_datapoint_oracle_time_series__id_iamc_timeseries",
        ),
        sa.PrimaryKeyConstraint("id", name="pk_iamc_datapoint_oracle"),
        sa.UniqueConstraint(
            "time_series__id",
            "step_year",
            "step_category",
            "step_datetime",
            name="uq_iamc_datapoint_oracle_time_series__id_step_year_step_category_step_datetime",
        ),
    )
    with op.batch_alter_table("iamc_datapoint_oracle", schema=None) as batch_op:
        batch_op.create_index("ix_iamc_datapoint_oracle_type", ["type"], unique=False)
        batch_op.create_index(
            "ix_iamc_datapoint_oracle_time_series__id",
            ["time_series__id"],
            unique=False,
        )
        batch_op.create_index(
            "ix_iamc_datapoint_oracle_step_year", ["step_year"], unique=False
        )
        batch_op.create_index(
            "ix_iamc_datapoint_oracle_step_datetime",
            ["step_datetime"],
            unique=False,
        )
        batch_op.create_index(
            "ix_iamc_datapoint_oracle_step_category",
            ["step_category"],
            unique=False,
        )

    op.drop_table("optimization_indexset_docs")
    with op.batch_alter_table("optimization_indexset", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_optimization_indexset_run__id"))

    op.drop_table("optimization_indexset")
    # ### end Alembic commands ###
