# Contributing to Quillmark MCP

Thank you for your interest in contributing to the Quillmark MCP server!

## Development Setup

1. Clone the repository:
```bash
git clone https://github.com/nibsbin/quillmark-mcp.git
cd quillmark-mcp
```

2. Install dependencies:
```bash
pip install -e ".[dev]"
```

3. Run tests:
```bash
pytest
```

## Code Style

- Follow PEP 8 guidelines
- Use type hints for all functions
- Run `ruff check` before committing
- Run `mypy` for type checking

## Testing

- Write tests for all new features
- Ensure existing tests pass
- Use pytest for testing

## Pull Requests

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Run tests and linting
5. Submit a pull request

## Issues

Please report bugs and feature requests via GitHub Issues.
