---
icon: octicons/people-24
---

首先，感谢您抽出宝贵时间做出贡献！❤️

所有类型的贡献都是值得鼓励和重视的。请参阅下面的目录，了解不同的贡献方式及如何处理它们的详细信息。请务必在贡献前阅读相关部分，这将使我们的维护人员更容易，并使所有相关人员的体验更加顺畅。我们期待您的贡献！

!!! tip "提示"

    如果你喜欢这个项目，但只是没有时间做出贡献，那也没关系。还有其他简单的方法可以支持该项目并表达您的感激之情，我们也非常高兴，例如给这个项目加星标！⭐

## 有个问题

### 议题

如果您想提出问题，我们假设您已经阅读了可用的文档。如果仍然没有找到您满意的答案，您可以发起一个 issue，我们将尽可能快地给出答复。但在发起 issue 之前，请先搜索是否存在已有 issue 与你的问题相关，以避免发起内容重复的 issue。

### 讨论

如果你有什么建议等，你可以在讨论区发起一个讨论。比如你可以发起关于某项功能的讨论，与别人或者项目维护者进行相关的讨论，我们会根据讨论结果对项目进行相关改进，当然，也可能不会采纳相关建议。

## 想要贡献

!!! warning "警告"

    在为本项目做出贡献时，您必须同意您创作了 **100%** 的内容，您对内容拥有必要的权利，并且您贡献的内容可以在项目许可下提供。

### 源代码

* 必须保证能在最新稳定版本的编程环境下稳定运行；
* 内容必须与项目相关；
* 代码风格符合要求（见下文）；
* 包含适当的注释；
* 全部使用英语，包括文档字符串；

### 文档

* 正确、详细且通俗易懂；
* 符合一定的规范；
* 如果可能，请翻译为中英双语；

### 教程

* 准确无误；
* 包含可运行的示例代码；
* 代码必须包含适当的注释；
* 如果可能，代码尽量不要使用外部资源（如图片等）；
* 如果可能，请加上用于解释说明的图片；
* 如果可能，请翻译为中英双语；

### 其他内容

* 符合某些规范即可，具体视情况而定；

## 风格指南

### 检查和测试

我们对所有的提交都设置了检查和测试。检查要求你的代码不能存在重大错误（如语法错误等），且代码的评分必须大于 9.0 分。测试要求你的代码能通过，不会产生过多的错误。

* Lint: <https://github.com/pylint-dev/pylint>
* Test: <https://github.com/pytest-dev/pytest>

### 代码风格

如果你想要你的 PR 被合并，我们希望你的代码风格尽量符合官方的风格，如果可以，我们更希望你的代码可以符合本项目的代码风格。

### 其它风格

其它内容，如 issues 等，我们不对风格做任何要求。

## 加入团队

如果你想加入项目团队，请联系项目团队的维护人员，下面是本项目作者的一些信息：

* 作者: @Xiaokang2022
* 邮箱: <2951256653@qq.com>

## 参见

这个贡献指南是基于 <https://contributing.md/example/> 改写的。
