from typing import Any, ClassVar, Optional

from typing import overload

class AlreadySent(RuntimeError): ...

class Consumer:
    def __init__(self, stream_name: str, cancel_event: object = ..., polling_interval: float = ..., context: str = ...) -> None: ...
    def receive(self, minimum_ts: int = ..., blocking: bool = ...) -> ReadBuffer: ...
    def receive_string(self, minimum_ts: int = ..., blocking: bool = ...) -> Optional[str]: ...
    @property
    def buffer_count(self) -> int: ...
    @property
    def buffer_size(self) -> int: ...
    @property
    def fd(self) -> int: ...
    @property
    def has_next(self) -> bool: ...
    @property
    def is_ended(self) -> bool: ...
    @property
    def is_sync(self) -> bool: ...
    @property
    def name(self) -> str: ...

class Control:
    def __init__(self, *args, **kwargs) -> None: ...

class ControlSnapshot:
    def __init__(self, *args, **kwargs) -> None: ...

class DataOverflow(IndexError): ...

class Inspector:
    def __init__(self, arg0: str) -> None: ...
    def control_snapshot(self, timeout: float = ...) -> str: ...

class LogLevel:
    __members__: ClassVar[dict] = ...  # read-only
    DEBUG: ClassVar[LogLevel] = ...
    ERROR: ClassVar[LogLevel] = ...
    INFO: ClassVar[LogLevel] = ...
    WARNING: ClassVar[LogLevel] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Producer:
    def __init__(self, stream_name: str, buffer_size: int, buffer_count: int, sync: bool = ..., cancel_event: object = ..., polling_interval: float = ..., context: str = ...) -> None: ...
    def end(self) -> None: ...
    def next_to_send(self, blocking: bool = ...) -> WriteBuffer: ...
    def send_string(self, *args, **kwargs) -> Any: ...
    @property
    def buffer_count(self) -> int: ...
    @property
    def buffer_size(self) -> int: ...
    @property
    def fd(self) -> int: ...
    @property
    def is_ended(self) -> bool: ...
    @property
    def is_sync(self) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def subscriber_count(self) -> int: ...

class ReadBuffer:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def read(self) -> bytes: ...
    @overload
    def read(self, count: int) -> bytes: ...
    def release(self) -> None: ...
    def seek(self, index: int) -> int: ...
    def tell(self) -> int: ...
    @overload
    def __getitem__(self, index: int) -> int: ...
    @overload
    def __getitem__(self, slice: slice) -> bytes: ...
    @property
    def buffer_count(self) -> int: ...
    @property
    def buffer_id(self) -> int: ...
    @property
    def buffer_size(self) -> int: ...
    @property
    def data_size(self) -> int: ...
    @property
    def data_timestamp(self) -> int: ...
    @property
    def iteration(self) -> int: ...

class ReleasedBuffer(RuntimeError): ...

class StreamExists(RuntimeError): ...

class StreamUnavailable(RuntimeError): ...

class ThreadingEventWrapper:
    def __init__(self, cancel_event: object) -> None: ...
    def is_set(self) -> bool: ...

class WriteBuffer:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def read(self) -> bytes: ...
    @overload
    def read(self, count: int) -> bytes: ...
    def seek(self, index: int) -> int: ...
    def send(self, *args, **kwargs) -> Any: ...
    def tell(self) -> int: ...
    @overload
    def truncate(self) -> int: ...
    @overload
    def truncate(self, index: int) -> int: ...
    def write(self, value: bytes) -> None: ...
    @overload
    def __getitem__(self, index: int) -> int: ...
    @overload
    def __getitem__(self, slice: slice) -> bytes: ...
    @overload
    def __setitem__(self, index: int, value: int) -> None: ...
    @overload
    def __setitem__(self, slice: slice, value: bytes) -> None: ...
    @property
    def buffer_count(self) -> int: ...
    @property
    def buffer_id(self) -> int: ...
    @property
    def buffer_size(self) -> int: ...
    @property
    def data_size(self) -> int: ...
    @property
    def data_timestamp(self) -> int: ...
    @property
    def iteration(self) -> int: ...

def get_log_level() -> LogLevel: ...
def set_log_level(level: LogLevel) -> None: ...
