# Generated by Django 3.2.6 on 2021-09-10 16:11
from django.core.exceptions import ObjectDoesNotExist
from django.db import migrations
from django.db.migrations import RunPython


def convert_actions_required_to_fk(apps, schema_editor):
    model_cls = apps.get_model("meta_prn", "protocoldeviationviolation")
    list_model_cls = apps.get_model("edc_protocol_violation", "actionsrequired")
    for obj in model_cls.objects.all():
        try:
            action_required = list_model_cls.objects.get(name=obj.action_required_old)
        except ObjectDoesNotExist as e:
            raise ObjectDoesNotExist(f"{e}. Got name={obj.action_required_old}")

        obj.action_required = action_required
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ("meta_prn", "0010_auto_20210910_1906"),
    ]

    operations = [RunPython(convert_actions_required_to_fk)]
