# Generated by Django 2.2.6 on 2019-10-18 19:24

import uuid

import _socket
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_crypto_fields.fields.encrypted_char_field
import django_revision.revision_field
import edc_sites.models
import edc_utils.date
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="SubjectScreening",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        unique=True,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=50,
                        unique=True,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined",
                        null=True,
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                (
                    "calculated_bmi",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="system calculated",
                        max_digits=8,
                        null=True,
                        verbose_name="BMI",
                    ),
                ),
                (
                    "calculated_egfr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mL/min/1.73m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "converted_creatinine",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="μmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine",
                    ),
                ),
                (
                    "converted_ogtt_two_hr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose levels 2-hours",
                    ),
                ),
                (
                    "inclusion_a",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired fasting glucose (6.1 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_b",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired glucose tolerance at 2 hours (7.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "inclusion_c",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired fasting glucose (6.3 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_d",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired glucose tolerance at 2 hours (9.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "eligible_part_one",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_one",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_two",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_two",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_three",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_three",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "screening_consent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the subject given his/her verbal consent to be screened for the META trial?",
                    ),
                ),
                (
                    "hospital_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                        unique=True,
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "ethnicity",
                    models.CharField(
                        choices=[("black", "Black"), ("OTHER", "Other")],
                        help_text="Used for eGFR calculation",
                        max_length=15,
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient HIV positive",
                    ),
                ),
                (
                    "art_six_months",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Has the patient been on anti-retroviral therapy for at least 6 months",
                    ),
                ),
                (
                    "on_rx_stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="in regular attendance for care",
                        max_length=15,
                        verbose_name="Is the patient considered to be stable on treatment ",
                    ),
                ),
                (
                    "lives_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient living within the catchment population of the facility",
                    ),
                ),
                (
                    "staying_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
                    ),
                ),
                (
                    "pregnant",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        max_length=15,
                        verbose_name="Is the patient pregnant?",
                    ),
                ),
                (
                    "part_two_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "urine_bhcg_performed",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        default="N/A",
                        help_text="(Pregnancy test)",
                        max_length=15,
                        verbose_name="Was a Urine or serum βhCG performed?",
                    ),
                ),
                (
                    "urine_bhcg",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Urine or serum βhCG result",
                    ),
                ),
                (
                    "urine_bhcg_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Urine or serum βhCG date"
                    ),
                ),
                (
                    "congestive_heart_failure",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
                    ),
                ),
                (
                    "liver_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                        max_length=15,
                        null=True,
                        verbose_name="Is there clinical evidence of liver disease",
                    ),
                ),
                (
                    "alcoholism",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
                    ),
                ),
                (
                    "acute_metabolic_acidosis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="lactic acidosis and/or diabetic ketoacidosis",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
                    ),
                ),
                (
                    "renal_function_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
                    ),
                ),
                (
                    "tissue_hypoxia_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
                    ),
                ),
                (
                    "acute_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
                    ),
                ),
                (
                    "metformin_sensitivity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
                    ),
                ),
                (
                    "advised_to_fast",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            (
                                "N/A",
                                "Not applicable, subject is not eligible based on the criteria above",
                            ),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been advised to return fasted for the second stage of the screening?",
                    ),
                ),
                (
                    "appt_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Appointment date for second stage of screening",
                    ),
                ),
                (
                    "part_three_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Second stage report date and time",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="in kgs",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(15),
                            django.core.validators.MaxValueValidator(135),
                        ],
                    ),
                ),
                (
                    "height",
                    models.IntegerField(
                        help_text="in centimeters",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(100),
                            django.core.validators.MaxValueValidator(230),
                        ],
                    ),
                ),
                (
                    "fasted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasted_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasted_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "hba1c_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the HbA1c performed?",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="in %",
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "creatinine_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the serum creatinine performed?",
                    ),
                ),
                (
                    "creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine levels",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (creatinine)",
                    ),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Fasting glucose levels",
                    ),
                ),
                (
                    "fasting_glucose_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time fasting glucose level measured",
                    ),
                ),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        verbose_name="Time oral glucose tolerance test was performed",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(300),
                        ],
                        verbose_name="Blood glucose levels 2-hours after glucose solution given",
                    ),
                ),
                (
                    "ogtt_two_hr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (Blood glucose)",
                    ),
                ),
                (
                    "ogtt_two_hr_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time blood glucose levels tested after glucose solution given",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Subject Screening",
                "verbose_name_plural": "Subject Screening",
            },
            managers=[("on_site", edc_sites.models.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="IcpReferral",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        max_length=25,
                        unique=True,
                        verbose_name="META Screening Identifier",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                ("hospital_identifier", models.CharField(max_length=25, unique=True)),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                ("age_in_years", models.IntegerField()),
                ("initials", models.CharField(max_length=3)),
                (
                    "ethnicity",
                    models.CharField(
                        choices=[("black", "Black"), ("OTHER", "Other")],
                        help_text="Used for eGFR calculation",
                        max_length=15,
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="HIV positive",
                    ),
                ),
                (
                    "art_six_months",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="On anti-retroviral therapy for at least 6 months",
                    ),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        verbose_name="Fasting glucose levels",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="in %",
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose levels 2-hours after glucose solution given",
                    ),
                ),
                ("meta_eligible", models.BooleanField(verbose_name="META eligibile")),
                (
                    "meta_eligibility_datetime",
                    models.DateTimeField(
                        help_text="Date and time META eligibility was determined",
                        null=True,
                    ),
                ),
                (
                    "referred",
                    models.DateTimeField(help_text="Date and time of referral", null=True),
                ),
                ("referral_reasons", models.TextField(null=True)),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_screening",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_screening.SubjectScreening",
                    ),
                ),
            ],
            managers=[("on_site", edc_sites.models.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="HistoricalSubjectScreening",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        max_length=50,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined",
                        null=True,
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "calculated_bmi",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="system calculated",
                        max_digits=8,
                        null=True,
                        verbose_name="BMI",
                    ),
                ),
                (
                    "calculated_egfr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mL/min/1.73m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "converted_creatinine",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="μmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine",
                    ),
                ),
                (
                    "converted_ogtt_two_hr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose levels 2-hours",
                    ),
                ),
                (
                    "inclusion_a",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired fasting glucose (6.1 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_b",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired glucose tolerance at 2 hours (7.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "inclusion_c",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired fasting glucose (6.3 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_d",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired glucose tolerance at 2 hours (9.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "eligible_part_one",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_one",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_two",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_two",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_three",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_three",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "screening_consent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the subject given his/her verbal consent to be screened for the META trial?",
                    ),
                ),
                (
                    "hospital_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        db_index=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "ethnicity",
                    models.CharField(
                        choices=[("black", "Black"), ("OTHER", "Other")],
                        help_text="Used for eGFR calculation",
                        max_length=15,
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient HIV positive",
                    ),
                ),
                (
                    "art_six_months",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Has the patient been on anti-retroviral therapy for at least 6 months",
                    ),
                ),
                (
                    "on_rx_stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="in regular attendance for care",
                        max_length=15,
                        verbose_name="Is the patient considered to be stable on treatment ",
                    ),
                ),
                (
                    "lives_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient living within the catchment population of the facility",
                    ),
                ),
                (
                    "staying_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
                    ),
                ),
                (
                    "pregnant",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        max_length=15,
                        verbose_name="Is the patient pregnant?",
                    ),
                ),
                (
                    "part_two_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "urine_bhcg_performed",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        default="N/A",
                        help_text="(Pregnancy test)",
                        max_length=15,
                        verbose_name="Was a Urine or serum βhCG performed?",
                    ),
                ),
                (
                    "urine_bhcg",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Urine or serum βhCG result",
                    ),
                ),
                (
                    "urine_bhcg_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Urine or serum βhCG date"
                    ),
                ),
                (
                    "congestive_heart_failure",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
                    ),
                ),
                (
                    "liver_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                        max_length=15,
                        null=True,
                        verbose_name="Is there clinical evidence of liver disease",
                    ),
                ),
                (
                    "alcoholism",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
                    ),
                ),
                (
                    "acute_metabolic_acidosis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="lactic acidosis and/or diabetic ketoacidosis",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
                    ),
                ),
                (
                    "renal_function_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
                    ),
                ),
                (
                    "tissue_hypoxia_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
                    ),
                ),
                (
                    "acute_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
                    ),
                ),
                (
                    "metformin_sensitivity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
                    ),
                ),
                (
                    "advised_to_fast",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            (
                                "N/A",
                                "Not applicable, subject is not eligible based on the criteria above",
                            ),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been advised to return fasted for the second stage of the screening?",
                    ),
                ),
                (
                    "appt_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Appointment date for second stage of screening",
                    ),
                ),
                (
                    "part_three_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Second stage report date and time",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="in kgs",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(15),
                            django.core.validators.MaxValueValidator(135),
                        ],
                    ),
                ),
                (
                    "height",
                    models.IntegerField(
                        help_text="in centimeters",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(100),
                            django.core.validators.MaxValueValidator(230),
                        ],
                    ),
                ),
                (
                    "fasted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasted_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasted_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "hba1c_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the HbA1c performed?",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="in %",
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "creatinine_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the serum creatinine performed?",
                    ),
                ),
                (
                    "creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine levels",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (creatinine)",
                    ),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Fasting glucose levels",
                    ),
                ),
                (
                    "fasting_glucose_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time fasting glucose level measured",
                    ),
                ),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        verbose_name="Time oral glucose tolerance test was performed",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(300),
                        ],
                        verbose_name="Blood glucose levels 2-hours after glucose solution given",
                    ),
                ),
                (
                    "ogtt_two_hr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (Blood glucose)",
                    ),
                ),
                (
                    "ogtt_two_hr_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time blood glucose levels tested after glucose solution given",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Screening",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalScreeningPartTwo",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        max_length=50,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined",
                        null=True,
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "calculated_bmi",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="system calculated",
                        max_digits=8,
                        null=True,
                        verbose_name="BMI",
                    ),
                ),
                (
                    "calculated_egfr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mL/min/1.73m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "converted_creatinine",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="μmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine",
                    ),
                ),
                (
                    "converted_ogtt_two_hr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose levels 2-hours",
                    ),
                ),
                (
                    "inclusion_a",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired fasting glucose (6.1 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_b",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired glucose tolerance at 2 hours (7.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "inclusion_c",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired fasting glucose (6.3 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_d",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired glucose tolerance at 2 hours (9.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "eligible_part_one",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_one",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_two",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_two",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_three",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_three",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "screening_consent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the subject given his/her verbal consent to be screened for the META trial?",
                    ),
                ),
                (
                    "hospital_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        db_index=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "ethnicity",
                    models.CharField(
                        choices=[("black", "Black"), ("OTHER", "Other")],
                        help_text="Used for eGFR calculation",
                        max_length=15,
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient HIV positive",
                    ),
                ),
                (
                    "art_six_months",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Has the patient been on anti-retroviral therapy for at least 6 months",
                    ),
                ),
                (
                    "on_rx_stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="in regular attendance for care",
                        max_length=15,
                        verbose_name="Is the patient considered to be stable on treatment ",
                    ),
                ),
                (
                    "lives_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient living within the catchment population of the facility",
                    ),
                ),
                (
                    "staying_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
                    ),
                ),
                (
                    "pregnant",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        max_length=15,
                        verbose_name="Is the patient pregnant?",
                    ),
                ),
                (
                    "part_two_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "urine_bhcg_performed",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        default="N/A",
                        help_text="(Pregnancy test)",
                        max_length=15,
                        verbose_name="Was a Urine or serum βhCG performed?",
                    ),
                ),
                (
                    "urine_bhcg",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Urine or serum βhCG result",
                    ),
                ),
                (
                    "urine_bhcg_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Urine or serum βhCG date"
                    ),
                ),
                (
                    "congestive_heart_failure",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
                    ),
                ),
                (
                    "liver_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                        max_length=15,
                        null=True,
                        verbose_name="Is there clinical evidence of liver disease",
                    ),
                ),
                (
                    "alcoholism",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
                    ),
                ),
                (
                    "acute_metabolic_acidosis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="lactic acidosis and/or diabetic ketoacidosis",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
                    ),
                ),
                (
                    "renal_function_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
                    ),
                ),
                (
                    "tissue_hypoxia_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
                    ),
                ),
                (
                    "acute_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
                    ),
                ),
                (
                    "metformin_sensitivity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
                    ),
                ),
                (
                    "advised_to_fast",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            (
                                "N/A",
                                "Not applicable, subject is not eligible based on the criteria above",
                            ),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been advised to return fasted for the second stage of the screening?",
                    ),
                ),
                (
                    "appt_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Appointment date for second stage of screening",
                    ),
                ),
                (
                    "part_three_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Second stage report date and time",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="in kgs",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(15),
                            django.core.validators.MaxValueValidator(135),
                        ],
                    ),
                ),
                (
                    "height",
                    models.IntegerField(
                        help_text="in centimeters",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(100),
                            django.core.validators.MaxValueValidator(230),
                        ],
                    ),
                ),
                (
                    "fasted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasted_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasted_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "hba1c_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the HbA1c performed?",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="in %",
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "creatinine_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the serum creatinine performed?",
                    ),
                ),
                (
                    "creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine levels",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (creatinine)",
                    ),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Fasting glucose levels",
                    ),
                ),
                (
                    "fasting_glucose_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time fasting glucose level measured",
                    ),
                ),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        verbose_name="Time oral glucose tolerance test was performed",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(300),
                        ],
                        verbose_name="Blood glucose levels 2-hours after glucose solution given",
                    ),
                ),
                (
                    "ogtt_two_hr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (Blood glucose)",
                    ),
                ),
                (
                    "ogtt_two_hr_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time blood glucose levels tested after glucose solution given",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Screening: Part Two",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalScreeningPartThree",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        max_length=50,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined",
                        null=True,
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "calculated_bmi",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="system calculated",
                        max_digits=8,
                        null=True,
                        verbose_name="BMI",
                    ),
                ),
                (
                    "calculated_egfr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mL/min/1.73m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "converted_creatinine",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="μmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine",
                    ),
                ),
                (
                    "converted_ogtt_two_hr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose levels 2-hours",
                    ),
                ),
                (
                    "inclusion_a",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired fasting glucose (6.1 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_b",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired glucose tolerance at 2 hours (7.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "inclusion_c",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired fasting glucose (6.3 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_d",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired glucose tolerance at 2 hours (9.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "eligible_part_one",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_one",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_two",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_two",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_three",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_three",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "screening_consent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the subject given his/her verbal consent to be screened for the META trial?",
                    ),
                ),
                (
                    "hospital_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        db_index=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "ethnicity",
                    models.CharField(
                        choices=[("black", "Black"), ("OTHER", "Other")],
                        help_text="Used for eGFR calculation",
                        max_length=15,
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient HIV positive",
                    ),
                ),
                (
                    "art_six_months",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Has the patient been on anti-retroviral therapy for at least 6 months",
                    ),
                ),
                (
                    "on_rx_stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="in regular attendance for care",
                        max_length=15,
                        verbose_name="Is the patient considered to be stable on treatment ",
                    ),
                ),
                (
                    "lives_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient living within the catchment population of the facility",
                    ),
                ),
                (
                    "staying_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
                    ),
                ),
                (
                    "pregnant",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        max_length=15,
                        verbose_name="Is the patient pregnant?",
                    ),
                ),
                (
                    "part_two_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "urine_bhcg_performed",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        default="N/A",
                        help_text="(Pregnancy test)",
                        max_length=15,
                        verbose_name="Was a Urine or serum βhCG performed?",
                    ),
                ),
                (
                    "urine_bhcg",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Urine or serum βhCG result",
                    ),
                ),
                (
                    "urine_bhcg_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Urine or serum βhCG date"
                    ),
                ),
                (
                    "congestive_heart_failure",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
                    ),
                ),
                (
                    "liver_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                        max_length=15,
                        null=True,
                        verbose_name="Is there clinical evidence of liver disease",
                    ),
                ),
                (
                    "alcoholism",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
                    ),
                ),
                (
                    "acute_metabolic_acidosis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="lactic acidosis and/or diabetic ketoacidosis",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
                    ),
                ),
                (
                    "renal_function_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
                    ),
                ),
                (
                    "tissue_hypoxia_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
                    ),
                ),
                (
                    "acute_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
                    ),
                ),
                (
                    "metformin_sensitivity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
                    ),
                ),
                (
                    "advised_to_fast",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            (
                                "N/A",
                                "Not applicable, subject is not eligible based on the criteria above",
                            ),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been advised to return fasted for the second stage of the screening?",
                    ),
                ),
                (
                    "appt_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Appointment date for second stage of screening",
                    ),
                ),
                (
                    "part_three_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Second stage report date and time",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="in kgs",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(15),
                            django.core.validators.MaxValueValidator(135),
                        ],
                    ),
                ),
                (
                    "height",
                    models.IntegerField(
                        help_text="in centimeters",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(100),
                            django.core.validators.MaxValueValidator(230),
                        ],
                    ),
                ),
                (
                    "fasted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasted_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasted_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "hba1c_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the HbA1c performed?",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="in %",
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "creatinine_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the serum creatinine performed?",
                    ),
                ),
                (
                    "creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine levels",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (creatinine)",
                    ),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Fasting glucose levels",
                    ),
                ),
                (
                    "fasting_glucose_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time fasting glucose level measured",
                    ),
                ),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        verbose_name="Time oral glucose tolerance test was performed",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(300),
                        ],
                        verbose_name="Blood glucose levels 2-hours after glucose solution given",
                    ),
                ),
                (
                    "ogtt_two_hr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (Blood glucose)",
                    ),
                ),
                (
                    "ogtt_two_hr_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time blood glucose levels tested after glucose solution given",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Screening: Part Three",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalScreeningPartOne",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        max_length=50,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Participant or legal guardian/representative able and willing to give informed consent.",
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined",
                        null=True,
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "calculated_bmi",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="system calculated",
                        max_digits=8,
                        null=True,
                        verbose_name="BMI",
                    ),
                ),
                (
                    "calculated_egfr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mL/min/1.73m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "converted_creatinine",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="μmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine",
                    ),
                ),
                (
                    "converted_ogtt_two_hr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L (system converted)",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose levels 2-hours",
                    ),
                ),
                (
                    "inclusion_a",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired fasting glucose (6.1 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_b",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI>30 combined with impaired glucose tolerance at 2 hours (7.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "inclusion_c",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired fasting glucose (6.3 to 6.9 mmol/L)",
                    ),
                ),
                (
                    "inclusion_d",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        help_text="system calculated",
                        max_length=15,
                        verbose_name="BMI<=30 combined with impaired glucose tolerance at 2 hours (9.0 to 11.10 mmol/L)",
                    ),
                ),
                (
                    "eligible_part_one",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_one",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_two",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_two",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "eligible_part_three",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("tbd", "To be determined"),
                        ],
                        default="tbd",
                        editable=False,
                        help_text="system calculated value",
                        max_length=15,
                    ),
                ),
                (
                    "reasons_ineligible_part_three",
                    models.TextField(editable=False, max_length=150, null=True),
                ),
                (
                    "screening_consent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the subject given his/her verbal consent to be screened for the META trial?",
                    ),
                ),
                (
                    "hospital_identifier",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        db_index=True,
                        help_text=" (Encryption: RSA local)",
                        max_length=71,
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "ethnicity",
                    models.CharField(
                        choices=[("black", "Black"), ("OTHER", "Other")],
                        help_text="Used for eGFR calculation",
                        max_length=15,
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient HIV positive",
                    ),
                ),
                (
                    "art_six_months",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Has the patient been on anti-retroviral therapy for at least 6 months",
                    ),
                ),
                (
                    "on_rx_stable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="in regular attendance for care",
                        max_length=15,
                        verbose_name="Is the patient considered to be stable on treatment ",
                    ),
                ),
                (
                    "lives_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient living within the catchment population of the facility",
                    ),
                ),
                (
                    "staying_nearby",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient planning to remain in the catchment area for at least 6 months",
                    ),
                ),
                (
                    "pregnant",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        max_length=15,
                        verbose_name="Is the patient pregnant?",
                    ),
                ),
                (
                    "part_two_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "urine_bhcg_performed",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male, post-menopausal"),
                        ],
                        default="N/A",
                        help_text="(Pregnancy test)",
                        max_length=15,
                        verbose_name="Was a Urine or serum βhCG performed?",
                    ),
                ),
                (
                    "urine_bhcg",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Urine or serum βhCG result",
                    ),
                ),
                (
                    "urine_bhcg_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Urine or serum βhCG date"
                    ),
                ),
                (
                    "congestive_heart_failure",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have congestive heart failure requiring pharmacologic therapy",
                    ),
                ),
                (
                    "liver_disease",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of chronic liver disease: Jaundice, pruritus, hepatomegaly, ascites, spider naevi and flapping tremors.",
                        max_length=15,
                        null=True,
                        verbose_name="Is there clinical evidence of liver disease",
                    ),
                ),
                (
                    "alcoholism",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Evidence of alcoholism or acute alcohol intoxication: flushing, amnesia, mental confusion, nausea or vomiting, slurred speech, dehydration, dry skin and brittle hair.",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any evidence of alcoholism or acute alcohol intoxication",
                    ),
                ),
                (
                    "acute_metabolic_acidosis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="lactic acidosis and/or diabetic ketoacidosis",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any signs or symptoms of acute metabolic acidosis",
                    ),
                ),
                (
                    "renal_function_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can alter renal function including: dehydration, severe infection or shock",
                    ),
                ),
                (
                    "tissue_hypoxia_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Including: decompensated heart failure, respiratory failure, recent myocardial infarction or shock",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition which can cause tissue hypoxia",
                    ),
                ),
                (
                    "acute_condition",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any acute condition requiring immediate hospital care/admission",
                    ),
                ),
                (
                    "metformin_sensitivity",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="For example: Magnesium stearate, sodium carboxymethylcellulose, hypromellose",
                        max_length=15,
                        null=True,
                        verbose_name="Does the patient have any known hypersensitivity to metformin or any excipients associated with its preparation",
                    ),
                ),
                (
                    "advised_to_fast",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            (
                                "N/A",
                                "Not applicable, subject is not eligible based on the criteria above",
                            ),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been advised to return fasted for the second stage of the screening?",
                    ),
                ),
                (
                    "appt_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Appointment date for second stage of screening",
                    ),
                ),
                (
                    "part_three_report_datetime",
                    models.DateTimeField(
                        help_text="Date and time of report.",
                        null=True,
                        verbose_name="Second stage report date and time",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="in kgs",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(15),
                            django.core.validators.MaxValueValidator(135),
                        ],
                    ),
                ),
                (
                    "height",
                    models.IntegerField(
                        help_text="in centimeters",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(100),
                            django.core.validators.MaxValueValidator(230),
                        ],
                    ),
                ),
                (
                    "fasted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasted_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasted_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "hba1c_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the HbA1c performed?",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="in %",
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "creatinine_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Was the serum creatinine performed?",
                    ),
                ),
                (
                    "creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Serum creatinine levels",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (creatinine)",
                    ),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Fasting glucose levels",
                    ),
                ),
                (
                    "fasting_glucose_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time fasting glucose level measured",
                    ),
                ),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        verbose_name="Time oral glucose tolerance test was performed",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(300),
                        ],
                        verbose_name="Blood glucose levels 2-hours after glucose solution given",
                    ),
                ),
                (
                    "ogtt_two_hr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (Blood glucose)",
                    ),
                ),
                (
                    "ogtt_two_hr_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Time blood glucose levels tested after glucose solution given",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Screening: Part One",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalIcpReferral",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        db_index=True,
                        max_length=25,
                        verbose_name="META Screening Identifier",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                ("hospital_identifier", models.CharField(db_index=True, max_length=25)),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                ("age_in_years", models.IntegerField()),
                ("initials", models.CharField(max_length=3)),
                (
                    "ethnicity",
                    models.CharField(
                        choices=[("black", "Black"), ("OTHER", "Other")],
                        help_text="Used for eGFR calculation",
                        max_length=15,
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="HIV positive",
                    ),
                ),
                (
                    "art_six_months",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="On anti-retroviral therapy for at least 6 months",
                    ),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        verbose_name="Fasting glucose levels",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="in %",
                        max_digits=8,
                        null=True,
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        decimal_places=4,
                        help_text="mmol/L",
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose levels 2-hours after glucose solution given",
                    ),
                ),
                ("meta_eligible", models.BooleanField(verbose_name="META eligibile")),
                (
                    "meta_eligibility_datetime",
                    models.DateTimeField(
                        help_text="Date and time META eligibility was determined",
                        null=True,
                    ),
                ),
                (
                    "referred",
                    models.DateTimeField(help_text="Date and time of referral", null=True),
                ),
                ("referral_reasons", models.TextField(null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_screening",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_screening.SubjectScreening",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical icp referral",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="ScreeningPartOne",
            fields=[],
            options={
                "verbose_name": "Subject Screening: Part One",
                "verbose_name_plural": "Subject Screening: Part One",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("meta_screening.subjectscreening",),
            managers=[("on_site", edc_sites.models.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="ScreeningPartThree",
            fields=[],
            options={
                "verbose_name": "Subject Screening: Part Three",
                "verbose_name_plural": "Subject Screening: Part Three",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("meta_screening.subjectscreening",),
            managers=[("on_site", edc_sites.models.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="ScreeningPartTwo",
            fields=[],
            options={
                "verbose_name": "Subject Screening: Part Two",
                "verbose_name_plural": "Subject Screening: Part Two",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("meta_screening.subjectscreening",),
            managers=[("on_site", edc_sites.models.CurrentSiteManager())],
        ),
    ]
