# Generated by Django 3.0.4 on 2020-04-19 20:05

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("meta_subject", "0022_auto_20200419_2223"),
    ]

    operations = [
        migrations.AddField(
            model_name="coronakap",
            name="severity_diabetes_hypertension",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                default="true",
                max_length=25,
                verbose_name="The disease caused by the coronavirus is more severe in people with <u>diabetes</u> and/or <u>hypertension</u>",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="coronakap",
            name="severity_hiv",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                default="true",
                max_length=25,
                verbose_name="The disease caused by the coronavirus is more severe in people with <u>HIV infection</u>",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalcoronakap",
            name="severity_diabetes_hypertension",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                default="true",
                max_length=25,
                verbose_name="The disease caused by the coronavirus is more severe in people with <u>diabetes</u> and/or <u>hypertension</u>",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalcoronakap",
            name="severity_hiv",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                default="true",
                max_length=25,
                verbose_name="The disease caused by the coronavirus is more severe in people with <u>HIV infection</u>",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="diabetic",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                max_length=25,
                verbose_name="Does the patient have <u>diabetes</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="education",
            field=models.CharField(
                choices=[
                    ("primary", "Up to primary"),
                    ("secondary", "Up to high school"),
                    ("tertiary", "University, college"),
                    ("no_education", "No education"),
                ],
                max_length=25,
                verbose_name="What is your highest completed education level?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="employment",
            field=models.CharField(
                choices=[
                    ("professional", "Professional (e.g. office"),
                    ("labourer", "Labourer"),
                    ("housewife_retired", "Housewife, Retired"),
                    ("self_employed", "Small business, self-employed"),
                    ("OTHER", "Other, specify below"),
                ],
                max_length=25,
                verbose_name="What type of employment are you involved in?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="employment_status",
            field=models.CharField(
                choices=[
                    ("working_for_pay", "Working for pay"),
                    ("unemployed", "Unemployed"),
                    (
                        "not_working_for_pay",
                        "Not working for pay (housewife, retired...)",
                    ),
                ],
                max_length=25,
                verbose_name="Are you employed?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="family_infection_likelihood",
            field=models.CharField(
                choices=[
                    ("very", "Very likely"),
                    ("somewhat", "Somewhat likely"),
                    ("unlikely", "Not very likely, unlikely"),
                    ("not_at_all", "Not at all"),
                ],
                max_length=25,
                verbose_name="How likely do you think it is that <u>someone in your family</u> will get sick from the coronavirus?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="health_insurance",
            field=models.CharField(
                choices=[
                    ("work_scheme", "Work scheme health insurance"),
                    ("private", "Private health insurance"),
                    ("no_insurance", "No insurance, I pay"),
                    ("OTHER", "Other, please specify below"),
                ],
                max_length=25,
                verbose_name="How are you covered for your health care expenses?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="hiv_pos",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                max_length=25,
                verbose_name="Does the patient have <u>HIV</u> infection?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="hot_climate",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The coronavirus does not survive in the hot climate",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="hypertensive",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                max_length=25,
                verbose_name="Does the patient have <u>hypertension</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="know_other_symptoms",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Do you know of any other symptoms of the coronavirus?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="lives_on_materials",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The coronavirus can live on clothes, plastics, cardboard for a day or more",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="perc_die",
            field=models.IntegerField(
                help_text="On a scale from 0-100",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
                verbose_name="Out of every 100 people who get infected with coronavirus, how many do you think <u>will die</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="perc_mild_symptom",
            field=models.IntegerField(
                help_text="On a scale from 0-100",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
                verbose_name="Out of every 100 people who get infected with coronavirus, how many do you think <u>will have only mild symptoms</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="perceived_threat",
            field=models.IntegerField(
                help_text="On a scale from 1-10",
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(10),
                ],
                verbose_name="On a scale from 1-10, how serious of a public health threat is coronavirus?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="personal_infection_likelihood",
            field=models.CharField(
                choices=[
                    ("very", "Very likely"),
                    ("somewhat", "Somewhat likely"),
                    ("unlikely", "Not very likely, unlikely"),
                    ("not_at_all", "Not at all"),
                ],
                max_length=25,
                verbose_name="How likely do you think it is that <u>you</u> will get sick from the coronavirus?",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="severity_age",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The disease caused by the coronavirus is more severe in older people than children",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="shared_housing_two",
            field=models.IntegerField(
                verbose_name="In a typical month, how many different people spend more than one night at your current dwelling?"
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="spread_asymptomatic",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="People can transmit the coronavirus even when they do not appear to be sick",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="spread_droplets",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The coronavirus spreads by droplets from cough and sneezes from people infected with coronavirus",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="spread_sick",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="People can transmit the coronavirus when they are sick ",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="spread_touch",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The coronavirus can spread by people touching each other",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="spread_touch2",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="You can catch the coronavirus if you touch an infected area and then touch your face or eyes",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="symptoms_other",
            field=models.TextField(
                blank=True,
                max_length=250,
                null=True,
                verbose_name="Please list any other symptoms of the coronavirus infection that you are aware of",
            ),
        ),
        migrations.AlterField(
            model_name="coronakap",
            name="wash_hands",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="Wash hands with soap and warm water",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="diabetic",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                max_length=25,
                verbose_name="Does the patient have <u>diabetes</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="education",
            field=models.CharField(
                choices=[
                    ("primary", "Up to primary"),
                    ("secondary", "Up to high school"),
                    ("tertiary", "University, college"),
                    ("no_education", "No education"),
                ],
                max_length=25,
                verbose_name="What is your highest completed education level?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="employment",
            field=models.CharField(
                choices=[
                    ("professional", "Professional (e.g. office"),
                    ("labourer", "Labourer"),
                    ("housewife_retired", "Housewife, Retired"),
                    ("self_employed", "Small business, self-employed"),
                    ("OTHER", "Other, specify below"),
                ],
                max_length=25,
                verbose_name="What type of employment are you involved in?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="employment_status",
            field=models.CharField(
                choices=[
                    ("working_for_pay", "Working for pay"),
                    ("unemployed", "Unemployed"),
                    (
                        "not_working_for_pay",
                        "Not working for pay (housewife, retired...)",
                    ),
                ],
                max_length=25,
                verbose_name="Are you employed?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="family_infection_likelihood",
            field=models.CharField(
                choices=[
                    ("very", "Very likely"),
                    ("somewhat", "Somewhat likely"),
                    ("unlikely", "Not very likely, unlikely"),
                    ("not_at_all", "Not at all"),
                ],
                max_length=25,
                verbose_name="How likely do you think it is that <u>someone in your family</u> will get sick from the coronavirus?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="health_insurance",
            field=models.CharField(
                choices=[
                    ("work_scheme", "Work scheme health insurance"),
                    ("private", "Private health insurance"),
                    ("no_insurance", "No insurance, I pay"),
                    ("OTHER", "Other, please specify below"),
                ],
                max_length=25,
                verbose_name="How are you covered for your health care expenses?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="hiv_pos",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                max_length=25,
                verbose_name="Does the patient have <u>HIV</u> infection?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="hot_climate",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The coronavirus does not survive in the hot climate",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="hypertensive",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                max_length=25,
                verbose_name="Does the patient have <u>hypertension</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="know_other_symptoms",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Do you know of any other symptoms of the coronavirus?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="lives_on_materials",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The coronavirus can live on clothes, plastics, cardboard for a day or more",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="perc_die",
            field=models.IntegerField(
                help_text="On a scale from 0-100",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
                verbose_name="Out of every 100 people who get infected with coronavirus, how many do you think <u>will die</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="perc_mild_symptom",
            field=models.IntegerField(
                help_text="On a scale from 0-100",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
                verbose_name="Out of every 100 people who get infected with coronavirus, how many do you think <u>will have only mild symptoms</u>?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="perceived_threat",
            field=models.IntegerField(
                help_text="On a scale from 1-10",
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(10),
                ],
                verbose_name="On a scale from 1-10, how serious of a public health threat is coronavirus?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="personal_infection_likelihood",
            field=models.CharField(
                choices=[
                    ("very", "Very likely"),
                    ("somewhat", "Somewhat likely"),
                    ("unlikely", "Not very likely, unlikely"),
                    ("not_at_all", "Not at all"),
                ],
                max_length=25,
                verbose_name="How likely do you think it is that <u>you</u> will get sick from the coronavirus?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="severity_age",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The disease caused by the coronavirus is more severe in older people than children",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="shared_housing_two",
            field=models.IntegerField(
                verbose_name="In a typical month, how many different people spend more than one night at your current dwelling?"
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="spread_asymptomatic",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="People can transmit the coronavirus even when they do not appear to be sick",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="spread_droplets",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The coronavirus spreads by droplets from cough and sneezes from people infected with coronavirus",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="spread_sick",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="People can transmit the coronavirus when they are sick ",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="spread_touch",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="The coronavirus can spread by people touching each other",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="spread_touch2",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="You can catch the coronavirus if you touch an infected area and then touch your face or eyes",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="symptoms_other",
            field=models.TextField(
                blank=True,
                max_length=250,
                null=True,
                verbose_name="Please list any other symptoms of the coronavirus infection that you are aware of",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcoronakap",
            name="wash_hands",
            field=models.CharField(
                choices=[
                    ("true", "True"),
                    ("false", "False"),
                    ("dont_know", "Don't know"),
                ],
                max_length=25,
                verbose_name="Wash hands with soap and warm water",
            ),
        ),
    ]
