# Generated by Django 3.2.13 on 2022-07-14 20:03

from django.db import migrations
from edc_lab_panel.panels import (
    blood_glucose_panel,
    fbc_panel,
    hba1c_panel,
    insulin_panel,
    lft_panel,
    lipids_panel,
    rft_panel,
)
from edc_lab_results.calculate_missing import calculate_missing
from tqdm import tqdm


def update_bloodresults(apps, schema_editor):
    app_label = "meta_subject"
    for suffix, panel in {
        "fbc": fbc_panel,
        "glu": blood_glucose_panel,
        "hba1c": hba1c_panel,
        "ins": insulin_panel,
        "lft": lft_panel,
        "lipid": lipids_panel,
        "rft": rft_panel,
    }.items():
        model_cls = apps.get_model(f"{app_label}.bloodresults{suffix}")
        cnt = model_cls.objects.all().count()
        print(model_cls._meta.label_lower)
        for obj in tqdm(model_cls.objects.all(), total=cnt):
            obj.missing_count, obj.missing = calculate_missing(obj, panel)
            obj.save_base(update_fields=["missing_count", "missing"])


class Migration(migrations.Migration):

    dependencies = [
        ("meta_subject", "0123_auto_20220714_2136"),
    ]

    operations = [migrations.RunPython(update_bloodresults)]
