# This an autogenerated file
# 
# Generated with DiffractedWaveVelocity
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.diffractedwavevelocity import DiffractedWaveVelocityBlueprint
from numpy import ndarray,asarray
from sima.hydro.directiondependentcomplexvalues import DirectionDependentComplexValues
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class DiffractedWaveVelocity(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    directions : ndarray
    frequencies : ndarray
    u : DirectionDependentComplexValues
    v : DirectionDependentComplexValues
    w : DirectionDependentComplexValues
    """

    def __init__(self , name="", description="", _id="", **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.directions = ndarray(1)
        self.frequencies = ndarray(1)
        self.u = None
        self.v = None
        self.w = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DiffractedWaveVelocityBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def directions(self) -> ndarray:
        """"""
        return self.__directions

    @directions.setter
    def directions(self, value: ndarray):
        """Set directions"""
        self.__directions = asarray(value)

    @property
    def frequencies(self) -> ndarray:
        """"""
        return self.__frequencies

    @frequencies.setter
    def frequencies(self, value: ndarray):
        """Set frequencies"""
        self.__frequencies = asarray(value)

    @property
    def u(self) -> DirectionDependentComplexValues:
        """"""
        return self.__u

    @u.setter
    def u(self, value: DirectionDependentComplexValues):
        """Set u"""
        self.__u = value

    @property
    def v(self) -> DirectionDependentComplexValues:
        """"""
        return self.__v

    @v.setter
    def v(self, value: DirectionDependentComplexValues):
        """Set v"""
        self.__v = value

    @property
    def w(self) -> DirectionDependentComplexValues:
        """"""
        return self.__w

    @w.setter
    def w(self, value: DirectionDependentComplexValues):
        """Set w"""
        self.__w = value
