# This an autogenerated file
# 
# Generated with SuperNode
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.supernode import SuperNodeBlueprint
from typing import Dict
from sima.riflex.boundarycondition import BoundaryCondition
from sima.riflex.boundaryconditionframe import BoundaryConditionFrame
from sima.riflex.nodeconstraint import NodeConstraint
from sima.sima.namedobject import NamedObject
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.supernodereference import SuperNodeReference
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.referenceframe import ReferenceFrame
    from sima.riflex.supportvessel import SupportVessel
    from sima.simo.supernodereference import SuperNodeReference
    from sima.riflex.arline import ARLine

class SuperNode(NamedObject,SuperNodeReference):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    constraint : NodeConstraint
         Supernode type.
    referenceFrame : ReferenceFrame
         Reference frame for local coordinates.
    supportVessel : SupportVessel
         Support body reference.
    automaticInitialPosition : bool
         Initial position calculated using stress free reference line length, stress free coordinate of the other super node and static coordinates of both super nodes.(default False)
    masterNode : SuperNodeReference
         Master node for Slaved / Fixed Relative Orientation nodes.
    xConstraint : BoundaryCondition
         Boundary condition for translation in X-direction.
    yConstraint : BoundaryCondition
         Boundary condition for translation in Y-direction.
    zConstraint : BoundaryCondition
         Boundary condition for translation in Z-direction.
    rxConstraint : BoundaryCondition
         Boundary condition for rotation about X-axis
    ryConstraint : BoundaryCondition
         Boundary condition for rotation about Y-axis
    rzConstraint : BoundaryCondition
         Boundary condition for rotation about Z-axis
    xGInitial : float
         Initial (stress-free) global coordinate X(default 0.0)
    yGInitial : float
         Initial (stress-free) global coordinate Y(default 0.0)
    zGInitial : float
         Initial (stress-free) global coordinate Z(default 0.0)
    xGStatic : float
         Static global coordinate X(default 0.0)
    yGStatic : float
         Static global coordinate Y(default 0.0)
    zGStatic : float
         Static global coordinate Z(default 0.0)
    rotation : float
         Specified rotation of supernode from stress free position \nto static equilibrium position.(default 0.0)
    direction : float
         Direction of axis for specified rotation.(default 0.0)
    referenceLine : ARLine
         Used for automatic calculation of initial super node position
    beta : float
         Direction to horisontal if set. Rotation is about 'local y-axis' i.e. positive downwards.(default 0.0)
    radial : bool
         Used to define the supernode position relative to \nthe x axis spanned by the reference supernodes(default False)
    radialReference1 : SuperNode
         Master node for Slaved / Fixed Relative Orientation nodes.
    radialReference2 : SuperNode
         Master node for Slaved / Fixed Relative Orientation nodes.
    radialAngle : float
         (default 0.0)
    verticalOffset : float
         (default 0.0)
    radialDistance : float
         (default 0.0)
    boundaryConditionFrame : BoundaryConditionFrame
         Boundary condition reference co-ordinate system
    xx : float
         Skew x-axis x-component in reference system(default 0.0)
    xy : float
         Skew x-axis y-component in reference system(default 0.0)
    xz : float
         Skew x-axis z-component in reference system(default 0.0)
    xp : float
         XY-plane reference vector x-component  in reference system(default 0.0)
    yp : float
         XY-plane reference vector y-component  in reference system(default 0.0)
    zp : float
         XY-plane reference vector z-component  in reference system(default 0.0)
    """

    def __init__(self , name="", description="", _id="", constraint: NodeConstraint =NodeConstraint.FIXED_PRESCRIBED, automaticInitialPosition=False, xConstraint=BoundaryCondition.FREE, yConstraint=BoundaryCondition.FREE, zConstraint=BoundaryCondition.FREE, rxConstraint=BoundaryCondition.FREE, ryConstraint=BoundaryCondition.FREE, rzConstraint=BoundaryCondition.FREE, xGInitial=0.0, yGInitial=0.0, zGInitial=0.0, xGStatic=0.0, yGStatic=0.0, zGStatic=0.0, rotation=0.0, direction=0.0, beta=0.0, radial=False, radialAngle=0.0, verticalOffset=0.0, radialDistance=0.0, boundaryConditionFrame=BoundaryConditionFrame.GLOBAL, xx=0.0, xy=0.0, xz=0.0, xp=0.0, yp=0.0, zp=0.0, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.constraint = constraint
        self.referenceFrame = None
        self.supportVessel = None
        self.automaticInitialPosition = automaticInitialPosition
        self.masterNode = None
        self.xConstraint = xConstraint
        self.yConstraint = yConstraint
        self.zConstraint = zConstraint
        self.rxConstraint = rxConstraint
        self.ryConstraint = ryConstraint
        self.rzConstraint = rzConstraint
        self.xGInitial = xGInitial
        self.yGInitial = yGInitial
        self.zGInitial = zGInitial
        self.xGStatic = xGStatic
        self.yGStatic = yGStatic
        self.zGStatic = zGStatic
        self.rotation = rotation
        self.direction = direction
        self.referenceLine = None
        self.beta = beta
        self.radial = radial
        self.radialReference1 = None
        self.radialReference2 = None
        self.radialAngle = radialAngle
        self.verticalOffset = verticalOffset
        self.radialDistance = radialDistance
        self.boundaryConditionFrame = boundaryConditionFrame
        self.xx = xx
        self.xy = xy
        self.xz = xz
        self.xp = xp
        self.yp = yp
        self.zp = zp
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SuperNodeBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def constraint(self) -> NodeConstraint:
        """Supernode type."""
        return self.__constraint

    @constraint.setter
    def constraint(self, value: NodeConstraint):
        """Set constraint"""
        self.__constraint = value

    @property
    def referenceFrame(self) -> ReferenceFrame:
        """Reference frame for local coordinates."""
        return self.__referenceFrame

    @referenceFrame.setter
    def referenceFrame(self, value: ReferenceFrame):
        """Set referenceFrame"""
        self.__referenceFrame = value

    @property
    def supportVessel(self) -> SupportVessel:
        """Support body reference."""
        return self.__supportVessel

    @supportVessel.setter
    def supportVessel(self, value: SupportVessel):
        """Set supportVessel"""
        self.__supportVessel = value

    @property
    def automaticInitialPosition(self) -> bool:
        """Initial position calculated using stress free reference line length, stress free coordinate of the other super node and static coordinates of both super nodes."""
        return self.__automaticInitialPosition

    @automaticInitialPosition.setter
    def automaticInitialPosition(self, value: bool):
        """Set automaticInitialPosition"""
        self.__automaticInitialPosition = bool(value)

    @property
    def masterNode(self) -> SuperNodeReference:
        """Master node for Slaved / Fixed Relative Orientation nodes."""
        return self.__masterNode

    @masterNode.setter
    def masterNode(self, value: SuperNodeReference):
        """Set masterNode"""
        self.__masterNode = value

    @property
    def xConstraint(self) -> BoundaryCondition:
        """Boundary condition for translation in X-direction."""
        return self.__xConstraint

    @xConstraint.setter
    def xConstraint(self, value: BoundaryCondition):
        """Set xConstraint"""
        self.__xConstraint = value

    @property
    def yConstraint(self) -> BoundaryCondition:
        """Boundary condition for translation in Y-direction."""
        return self.__yConstraint

    @yConstraint.setter
    def yConstraint(self, value: BoundaryCondition):
        """Set yConstraint"""
        self.__yConstraint = value

    @property
    def zConstraint(self) -> BoundaryCondition:
        """Boundary condition for translation in Z-direction."""
        return self.__zConstraint

    @zConstraint.setter
    def zConstraint(self, value: BoundaryCondition):
        """Set zConstraint"""
        self.__zConstraint = value

    @property
    def rxConstraint(self) -> BoundaryCondition:
        """Boundary condition for rotation about X-axis"""
        return self.__rxConstraint

    @rxConstraint.setter
    def rxConstraint(self, value: BoundaryCondition):
        """Set rxConstraint"""
        self.__rxConstraint = value

    @property
    def ryConstraint(self) -> BoundaryCondition:
        """Boundary condition for rotation about Y-axis"""
        return self.__ryConstraint

    @ryConstraint.setter
    def ryConstraint(self, value: BoundaryCondition):
        """Set ryConstraint"""
        self.__ryConstraint = value

    @property
    def rzConstraint(self) -> BoundaryCondition:
        """Boundary condition for rotation about Z-axis"""
        return self.__rzConstraint

    @rzConstraint.setter
    def rzConstraint(self, value: BoundaryCondition):
        """Set rzConstraint"""
        self.__rzConstraint = value

    @property
    def xGInitial(self) -> float:
        """Initial (stress-free) global coordinate X"""
        return self.__xGInitial

    @xGInitial.setter
    def xGInitial(self, value: float):
        """Set xGInitial"""
        self.__xGInitial = float(value)

    @property
    def yGInitial(self) -> float:
        """Initial (stress-free) global coordinate Y"""
        return self.__yGInitial

    @yGInitial.setter
    def yGInitial(self, value: float):
        """Set yGInitial"""
        self.__yGInitial = float(value)

    @property
    def zGInitial(self) -> float:
        """Initial (stress-free) global coordinate Z"""
        return self.__zGInitial

    @zGInitial.setter
    def zGInitial(self, value: float):
        """Set zGInitial"""
        self.__zGInitial = float(value)

    @property
    def xGStatic(self) -> float:
        """Static global coordinate X"""
        return self.__xGStatic

    @xGStatic.setter
    def xGStatic(self, value: float):
        """Set xGStatic"""
        self.__xGStatic = float(value)

    @property
    def yGStatic(self) -> float:
        """Static global coordinate Y"""
        return self.__yGStatic

    @yGStatic.setter
    def yGStatic(self, value: float):
        """Set yGStatic"""
        self.__yGStatic = float(value)

    @property
    def zGStatic(self) -> float:
        """Static global coordinate Z"""
        return self.__zGStatic

    @zGStatic.setter
    def zGStatic(self, value: float):
        """Set zGStatic"""
        self.__zGStatic = float(value)

    @property
    def rotation(self) -> float:
        """Specified rotation of supernode from stress free position 
to static equilibrium position."""
        return self.__rotation

    @rotation.setter
    def rotation(self, value: float):
        """Set rotation"""
        self.__rotation = float(value)

    @property
    def direction(self) -> float:
        """Direction of axis for specified rotation."""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def referenceLine(self) -> ARLine:
        """Used for automatic calculation of initial super node position"""
        return self.__referenceLine

    @referenceLine.setter
    def referenceLine(self, value: ARLine):
        """Set referenceLine"""
        self.__referenceLine = value

    @property
    def beta(self) -> float:
        """Direction to horisontal if set. Rotation is about 'local y-axis' i.e. positive downwards."""
        return self.__beta

    @beta.setter
    def beta(self, value: float):
        """Set beta"""
        self.__beta = float(value)

    @property
    def radial(self) -> bool:
        """Used to define the supernode position relative to 
the x axis spanned by the reference supernodes"""
        return self.__radial

    @radial.setter
    def radial(self, value: bool):
        """Set radial"""
        self.__radial = bool(value)

    @property
    def radialReference1(self) -> SuperNode:
        """Master node for Slaved / Fixed Relative Orientation nodes."""
        return self.__radialReference1

    @radialReference1.setter
    def radialReference1(self, value: SuperNode):
        """Set radialReference1"""
        self.__radialReference1 = value

    @property
    def radialReference2(self) -> SuperNode:
        """Master node for Slaved / Fixed Relative Orientation nodes."""
        return self.__radialReference2

    @radialReference2.setter
    def radialReference2(self, value: SuperNode):
        """Set radialReference2"""
        self.__radialReference2 = value

    @property
    def radialAngle(self) -> float:
        """"""
        return self.__radialAngle

    @radialAngle.setter
    def radialAngle(self, value: float):
        """Set radialAngle"""
        self.__radialAngle = float(value)

    @property
    def verticalOffset(self) -> float:
        """"""
        return self.__verticalOffset

    @verticalOffset.setter
    def verticalOffset(self, value: float):
        """Set verticalOffset"""
        self.__verticalOffset = float(value)

    @property
    def radialDistance(self) -> float:
        """"""
        return self.__radialDistance

    @radialDistance.setter
    def radialDistance(self, value: float):
        """Set radialDistance"""
        self.__radialDistance = float(value)

    @property
    def boundaryConditionFrame(self) -> BoundaryConditionFrame:
        """Boundary condition reference co-ordinate system"""
        return self.__boundaryConditionFrame

    @boundaryConditionFrame.setter
    def boundaryConditionFrame(self, value: BoundaryConditionFrame):
        """Set boundaryConditionFrame"""
        self.__boundaryConditionFrame = value

    @property
    def xx(self) -> float:
        """Skew x-axis x-component in reference system"""
        return self.__xx

    @xx.setter
    def xx(self, value: float):
        """Set xx"""
        self.__xx = float(value)

    @property
    def xy(self) -> float:
        """Skew x-axis y-component in reference system"""
        return self.__xy

    @xy.setter
    def xy(self, value: float):
        """Set xy"""
        self.__xy = float(value)

    @property
    def xz(self) -> float:
        """Skew x-axis z-component in reference system"""
        return self.__xz

    @xz.setter
    def xz(self, value: float):
        """Set xz"""
        self.__xz = float(value)

    @property
    def xp(self) -> float:
        """XY-plane reference vector x-component  in reference system"""
        return self.__xp

    @xp.setter
    def xp(self, value: float):
        """Set xp"""
        self.__xp = float(value)

    @property
    def yp(self) -> float:
        """XY-plane reference vector y-component  in reference system"""
        return self.__yp

    @yp.setter
    def yp(self, value: float):
        """Set yp"""
        self.__yp = float(value)

    @property
    def zp(self) -> float:
        """XY-plane reference vector z-component  in reference system"""
        return self.__zp

    @zp.setter
    def zp(self, value: float):
        """Set zp"""
        self.__zp = float(value)
