# This an autogenerated file
# 
# Generated with AllocationSystem
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.allocationsystem import AllocationSystemBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.formulation import Formulation
from sima.simo.thrusterallocation import ThrusterAllocation
from sima.simo.thrusterallocationmethod import ThrusterAllocationMethod
from sima.simo.thrustercontrol import ThrusterControl

class AllocationSystem(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    surgeAllocation : bool
         Force allocation in surge(default True)
    swayAllocation : bool
         Force allocation in sway(default True)
    yawAllocation : bool
         Force allocation in yaw(default True)
    thrusters : List[ThrusterAllocation]
    manual : bool
         Manual input of force to allocation system(default False)
    allocationMethod : ThrusterAllocationMethod
         Thrust allocation method
    thrusterControls : List[ThrusterControl]
    formulation : Formulation
    dpOff : bool
         Turn control system off(default False)
    """

    def __init__(self , name="", description="", _id="", surgeAllocation=True, swayAllocation=True, yawAllocation=True, manual=False, allocationMethod=ThrusterAllocationMethod.ORDINARY, formulation=Formulation.SIMO_41, dpOff=False, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.surgeAllocation = surgeAllocation
        self.swayAllocation = swayAllocation
        self.yawAllocation = yawAllocation
        self.thrusters = list()
        self.manual = manual
        self.allocationMethod = allocationMethod
        self.thrusterControls = list()
        self.formulation = formulation
        self.dpOff = dpOff
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return AllocationSystemBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def surgeAllocation(self) -> bool:
        """Force allocation in surge"""
        return self.__surgeAllocation

    @surgeAllocation.setter
    def surgeAllocation(self, value: bool):
        """Set surgeAllocation"""
        self.__surgeAllocation = bool(value)

    @property
    def swayAllocation(self) -> bool:
        """Force allocation in sway"""
        return self.__swayAllocation

    @swayAllocation.setter
    def swayAllocation(self, value: bool):
        """Set swayAllocation"""
        self.__swayAllocation = bool(value)

    @property
    def yawAllocation(self) -> bool:
        """Force allocation in yaw"""
        return self.__yawAllocation

    @yawAllocation.setter
    def yawAllocation(self, value: bool):
        """Set yawAllocation"""
        self.__yawAllocation = bool(value)

    @property
    def thrusters(self) -> List[ThrusterAllocation]:
        """"""
        return self.__thrusters

    @thrusters.setter
    def thrusters(self, value: List[ThrusterAllocation]):
        """Set thrusters"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__thrusters = value

    @property
    def manual(self) -> bool:
        """Manual input of force to allocation system"""
        return self.__manual

    @manual.setter
    def manual(self, value: bool):
        """Set manual"""
        self.__manual = bool(value)

    @property
    def allocationMethod(self) -> ThrusterAllocationMethod:
        """Thrust allocation method"""
        return self.__allocationMethod

    @allocationMethod.setter
    def allocationMethod(self, value: ThrusterAllocationMethod):
        """Set allocationMethod"""
        self.__allocationMethod = value

    @property
    def thrusterControls(self) -> List[ThrusterControl]:
        """"""
        return self.__thrusterControls

    @thrusterControls.setter
    def thrusterControls(self, value: List[ThrusterControl]):
        """Set thrusterControls"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__thrusterControls = value

    @property
    def formulation(self) -> Formulation:
        """"""
        return self.__formulation

    @formulation.setter
    def formulation(self, value: Formulation):
        """Set formulation"""
        self.__formulation = value

    @property
    def dpOff(self) -> bool:
        """Turn control system off"""
        return self.__dpOff

    @dpOff.setter
    def dpOff(self, value: bool):
        """Set dpOff"""
        self.__dpOff = bool(value)
