# This an autogenerated file
# 
# Generated with BallastTank
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.ballasttank import BallastTankBlueprint
from typing import Dict
from sima.sima.namedobject import NamedObject
from sima.sima.position import Position
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.ballastquantitytype import BallastQuantityType
from sima.simo.ballasttankstate import BallastTankState

class BallastTank(NamedObject):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    tag : str
         (default "")
    x : float
         x position in body local coordinate system(default 0.0)
    y : float
         y position in body local coordinate system(default 0.0)
    z : float
         z position in body local coordinate system(default 0.0)
    volumeTolerance : float
         Precision that should be reached by volume computation(default 0.001)
    permeabilityFactor : float
         Fraction of the tank volume that can be used to fill it with ballast fluid(default 1.0)
    initialBallastQuantity : float
         Initial ballast quantity.(default 0.0)
    quantityType : BallastQuantityType
    ballastFluidDensity : float
         Density of the fluid used as ballast(default 1025.0)
    geometryPosition : Position
    geometryFile : str
         Geometry definition file ( STL or GDF)(default "")
    state : BallastTankState
         State of ballast tank
    """

    def __init__(self , name="", description="", _id="", tag="", x=0.0, y=0.0, z=0.0, volumeTolerance=0.001, permeabilityFactor=1.0, initialBallastQuantity=0.0, quantityType=BallastQuantityType.PERCENTAGE, ballastFluidDensity=1025.0, geometryFile="", state=BallastTankState.INTACT, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.tag = tag
        self.x = x
        self.y = y
        self.z = z
        self.volumeTolerance = volumeTolerance
        self.permeabilityFactor = permeabilityFactor
        self.initialBallastQuantity = initialBallastQuantity
        self.quantityType = quantityType
        self.ballastFluidDensity = ballastFluidDensity
        self.geometryPosition = None
        self.geometryFile = geometryFile
        self.state = state
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return BallastTankBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def tag(self) -> str:
        """"""
        return self.__tag

    @tag.setter
    def tag(self, value: str):
        """Set tag"""
        self.__tag = str(value)

    @property
    def x(self) -> float:
        """x position in body local coordinate system"""
        return self.__x

    @x.setter
    def x(self, value: float):
        """Set x"""
        self.__x = float(value)

    @property
    def y(self) -> float:
        """y position in body local coordinate system"""
        return self.__y

    @y.setter
    def y(self, value: float):
        """Set y"""
        self.__y = float(value)

    @property
    def z(self) -> float:
        """z position in body local coordinate system"""
        return self.__z

    @z.setter
    def z(self, value: float):
        """Set z"""
        self.__z = float(value)

    @property
    def volumeTolerance(self) -> float:
        """Precision that should be reached by volume computation"""
        return self.__volumeTolerance

    @volumeTolerance.setter
    def volumeTolerance(self, value: float):
        """Set volumeTolerance"""
        self.__volumeTolerance = float(value)

    @property
    def permeabilityFactor(self) -> float:
        """Fraction of the tank volume that can be used to fill it with ballast fluid"""
        return self.__permeabilityFactor

    @permeabilityFactor.setter
    def permeabilityFactor(self, value: float):
        """Set permeabilityFactor"""
        self.__permeabilityFactor = float(value)

    @property
    def initialBallastQuantity(self) -> float:
        """Initial ballast quantity."""
        return self.__initialBallastQuantity

    @initialBallastQuantity.setter
    def initialBallastQuantity(self, value: float):
        """Set initialBallastQuantity"""
        self.__initialBallastQuantity = float(value)

    @property
    def quantityType(self) -> BallastQuantityType:
        """"""
        return self.__quantityType

    @quantityType.setter
    def quantityType(self, value: BallastQuantityType):
        """Set quantityType"""
        self.__quantityType = value

    @property
    def ballastFluidDensity(self) -> float:
        """Density of the fluid used as ballast"""
        return self.__ballastFluidDensity

    @ballastFluidDensity.setter
    def ballastFluidDensity(self, value: float):
        """Set ballastFluidDensity"""
        self.__ballastFluidDensity = float(value)

    @property
    def geometryPosition(self) -> Position:
        """"""
        return self.__geometryPosition

    @geometryPosition.setter
    def geometryPosition(self, value: Position):
        """Set geometryPosition"""
        self.__geometryPosition = value

    @property
    def geometryFile(self) -> str:
        """Geometry definition file ( STL or GDF)"""
        return self.__geometryFile

    @geometryFile.setter
    def geometryFile(self, value: str):
        """Set geometryFile"""
        self.__geometryFile = str(value)

    @property
    def state(self) -> BallastTankState:
        """State of ballast tank"""
        return self.__state

    @state.setter
    def state(self, value: BallastTankState):
        """Set state"""
        self.__state = value
