# This an autogenerated file
# 
# Generated with SIMOLinearDampingMatrix
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.simolineardampingmatrix import SIMOLinearDampingMatrixBlueprint
from numpy import ndarray,asarray
from sima.hydro.lineardampingmatrix import LinearDampingMatrix
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.dampingmatrixmotionmode import DampingMatrixMotionMode

class SIMOLinearDampingMatrix(LinearDampingMatrix):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    values : ndarray
    mode : DampingMatrixMotionMode
         Select which motions the damping matrix force should be calculated from. When 'default' is selected, low frequency motion is used for bodies of type '6 DOF - separated analysis' and total motion otherwise.
    """

    def __init__(self , name="", description="", _id="", mode=DampingMatrixMotionMode.DEFAULT, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.values = ndarray(1)
        self.mode = mode
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SIMOLinearDampingMatrixBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def values(self) -> ndarray:
        """"""
        return self.__values

    @values.setter
    def values(self, value: ndarray):
        """Set values"""
        self.__values = asarray(value)

    @property
    def mode(self) -> DampingMatrixMotionMode:
        """Select which motions the damping matrix force should be calculated from. When 'default' is selected, low frequency motion is used for bodies of type '6 DOF - separated analysis' and total motion otherwise."""
        return self.__mode

    @mode.setter
    def mode(self, value: DampingMatrixMotionMode):
        """Set mode"""
        self.__mode = value
