# This an autogenerated file
# 
# Generated with SIMOStaticCalculationParameters
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.simostaticcalculationparameters import SIMOStaticCalculationParametersBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.bodyeigenvalueitem import BodyEigenvalueItem
from sima.simo.dofelimination import DOFElimination
from sima.simo.equilibriumcalculationoption import EquilibriumCalculationOption
from sima.simo.equilibriumgriddefinition import EquilibriumGridDefinition
from sima.simo.staticequilibriumbody import StaticEquilibriumBody

class SIMOStaticCalculationParameters(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    runStaticAutomatically : bool
         Run Static calculation automatically each time the model changes(default False)
    calculateEquilibrium : bool
         Perform equlibrium calculation(default True)
    maxPeriod : float
         Maximum natural period(default 10.0)
    posTol : float
         Position tolerance(default 0.1)
    dirTol : float
         Direction tolerance(default 0.1)
    timeStep : float
         Equilibrium time step(default 0.01)
    maxStep : int
         Maximum number of time steps(default 10000)
    criticalDamping : bool
         Add critical damping?(default True)
    writeVisFile : bool
         write visualization file?(default True)
    calculateEigenvalues : bool
         Perform eigenvalue calculation(default False)
    eliminations : List[DOFElimination]
    eigenvalueItems : List[BodyEigenvalueItem]
    equilibriumCalculationMethod : EquilibriumCalculationOption
    forceTolerance : float
         An equilibrium will be accepted if all the force components are lower than the force tolerance, and all the moment components are lower than the moment tolerance.(default 100.0)
    momentTolerance : float
         An equilibrium will be accepted if all the force components are lower than the force tolerance, and all the moment components are lower than the moment tolerance.(default 1000.0)
    staticEquilibriumBody : List[StaticEquilibriumBody]
    restrainFromGlobalDOFBodies : List[DOFElimination]
    multipleEquilibriumCalculations : bool
         (default False)
    equilibriumGridDefinition : EquilibriumGridDefinition
    requireSuccessfulCalculation : bool
         When checked, static calculation will fail if no equilibrium position is found(default True)
    """

    def __init__(self , name="", description="", _id="", runStaticAutomatically=False, calculateEquilibrium=True, maxPeriod=10.0, posTol=0.1, dirTol=0.1, timeStep=0.01, maxStep=10000, criticalDamping=True, writeVisFile=True, calculateEigenvalues=False, equilibriumCalculationMethod=EquilibriumCalculationOption.TRANSIENT, forceTolerance=100.0, momentTolerance=1000.0, multipleEquilibriumCalculations=False, requireSuccessfulCalculation=True, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.runStaticAutomatically = runStaticAutomatically
        self.calculateEquilibrium = calculateEquilibrium
        self.maxPeriod = maxPeriod
        self.posTol = posTol
        self.dirTol = dirTol
        self.timeStep = timeStep
        self.maxStep = maxStep
        self.criticalDamping = criticalDamping
        self.writeVisFile = writeVisFile
        self.calculateEigenvalues = calculateEigenvalues
        self.eliminations = list()
        self.eigenvalueItems = list()
        self.equilibriumCalculationMethod = equilibriumCalculationMethod
        self.forceTolerance = forceTolerance
        self.momentTolerance = momentTolerance
        self.staticEquilibriumBody = list()
        self.restrainFromGlobalDOFBodies = list()
        self.multipleEquilibriumCalculations = multipleEquilibriumCalculations
        self.equilibriumGridDefinition = None
        self.requireSuccessfulCalculation = requireSuccessfulCalculation
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SIMOStaticCalculationParametersBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def runStaticAutomatically(self) -> bool:
        """Run Static calculation automatically each time the model changes"""
        return self.__runStaticAutomatically

    @runStaticAutomatically.setter
    def runStaticAutomatically(self, value: bool):
        """Set runStaticAutomatically"""
        self.__runStaticAutomatically = bool(value)

    @property
    def calculateEquilibrium(self) -> bool:
        """Perform equlibrium calculation"""
        return self.__calculateEquilibrium

    @calculateEquilibrium.setter
    def calculateEquilibrium(self, value: bool):
        """Set calculateEquilibrium"""
        self.__calculateEquilibrium = bool(value)

    @property
    def maxPeriod(self) -> float:
        """Maximum natural period"""
        return self.__maxPeriod

    @maxPeriod.setter
    def maxPeriod(self, value: float):
        """Set maxPeriod"""
        self.__maxPeriod = float(value)

    @property
    def posTol(self) -> float:
        """Position tolerance"""
        return self.__posTol

    @posTol.setter
    def posTol(self, value: float):
        """Set posTol"""
        self.__posTol = float(value)

    @property
    def dirTol(self) -> float:
        """Direction tolerance"""
        return self.__dirTol

    @dirTol.setter
    def dirTol(self, value: float):
        """Set dirTol"""
        self.__dirTol = float(value)

    @property
    def timeStep(self) -> float:
        """Equilibrium time step"""
        return self.__timeStep

    @timeStep.setter
    def timeStep(self, value: float):
        """Set timeStep"""
        self.__timeStep = float(value)

    @property
    def maxStep(self) -> int:
        """Maximum number of time steps"""
        return self.__maxStep

    @maxStep.setter
    def maxStep(self, value: int):
        """Set maxStep"""
        self.__maxStep = int(value)

    @property
    def criticalDamping(self) -> bool:
        """Add critical damping?"""
        return self.__criticalDamping

    @criticalDamping.setter
    def criticalDamping(self, value: bool):
        """Set criticalDamping"""
        self.__criticalDamping = bool(value)

    @property
    def writeVisFile(self) -> bool:
        """write visualization file?"""
        return self.__writeVisFile

    @writeVisFile.setter
    def writeVisFile(self, value: bool):
        """Set writeVisFile"""
        self.__writeVisFile = bool(value)

    @property
    def calculateEigenvalues(self) -> bool:
        """Perform eigenvalue calculation"""
        return self.__calculateEigenvalues

    @calculateEigenvalues.setter
    def calculateEigenvalues(self, value: bool):
        """Set calculateEigenvalues"""
        self.__calculateEigenvalues = bool(value)

    @property
    def eliminations(self) -> List[DOFElimination]:
        """"""
        return self.__eliminations

    @eliminations.setter
    def eliminations(self, value: List[DOFElimination]):
        """Set eliminations"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__eliminations = value

    @property
    def eigenvalueItems(self) -> List[BodyEigenvalueItem]:
        """"""
        return self.__eigenvalueItems

    @eigenvalueItems.setter
    def eigenvalueItems(self, value: List[BodyEigenvalueItem]):
        """Set eigenvalueItems"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__eigenvalueItems = value

    @property
    def equilibriumCalculationMethod(self) -> EquilibriumCalculationOption:
        """"""
        return self.__equilibriumCalculationMethod

    @equilibriumCalculationMethod.setter
    def equilibriumCalculationMethod(self, value: EquilibriumCalculationOption):
        """Set equilibriumCalculationMethod"""
        self.__equilibriumCalculationMethod = value

    @property
    def forceTolerance(self) -> float:
        """An equilibrium will be accepted if all the force components are lower than the force tolerance, and all the moment components are lower than the moment tolerance."""
        return self.__forceTolerance

    @forceTolerance.setter
    def forceTolerance(self, value: float):
        """Set forceTolerance"""
        self.__forceTolerance = float(value)

    @property
    def momentTolerance(self) -> float:
        """An equilibrium will be accepted if all the force components are lower than the force tolerance, and all the moment components are lower than the moment tolerance."""
        return self.__momentTolerance

    @momentTolerance.setter
    def momentTolerance(self, value: float):
        """Set momentTolerance"""
        self.__momentTolerance = float(value)

    @property
    def staticEquilibriumBody(self) -> List[StaticEquilibriumBody]:
        """"""
        return self.__staticEquilibriumBody

    @staticEquilibriumBody.setter
    def staticEquilibriumBody(self, value: List[StaticEquilibriumBody]):
        """Set staticEquilibriumBody"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__staticEquilibriumBody = value

    @property
    def restrainFromGlobalDOFBodies(self) -> List[DOFElimination]:
        """"""
        return self.__restrainFromGlobalDOFBodies

    @restrainFromGlobalDOFBodies.setter
    def restrainFromGlobalDOFBodies(self, value: List[DOFElimination]):
        """Set restrainFromGlobalDOFBodies"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__restrainFromGlobalDOFBodies = value

    @property
    def multipleEquilibriumCalculations(self) -> bool:
        """"""
        return self.__multipleEquilibriumCalculations

    @multipleEquilibriumCalculations.setter
    def multipleEquilibriumCalculations(self, value: bool):
        """Set multipleEquilibriumCalculations"""
        self.__multipleEquilibriumCalculations = bool(value)

    @property
    def equilibriumGridDefinition(self) -> EquilibriumGridDefinition:
        """"""
        return self.__equilibriumGridDefinition

    @equilibriumGridDefinition.setter
    def equilibriumGridDefinition(self, value: EquilibriumGridDefinition):
        """Set equilibriumGridDefinition"""
        self.__equilibriumGridDefinition = value

    @property
    def requireSuccessfulCalculation(self) -> bool:
        """When checked, static calculation will fail if no equilibrium position is found"""
        return self.__requireSuccessfulCalculation

    @requireSuccessfulCalculation.setter
    def requireSuccessfulCalculation(self, value: bool):
        """Set requireSuccessfulCalculation"""
        self.__requireSuccessfulCalculation = bool(value)
