# This an autogenerated file
# 
# Generated with Waypoint
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.waypoint import WaypointBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class Waypoint(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    x : float
         X-coordinate of waypoint(default 0.0)
    y : float
         Y-coordinate of waypoint(default 0.0)
    velocity : float
         Velocity towards next waypoint(default 0.0)
    heading : float
         Heading towards next waypoint (Only for fixed heading reference)(default 0.0)
    turningRadius : float
         Turning radius of waypoint ( Maximum rate of turn = velocity/turning radius)(default 0.0)
    radiusOfAcceptance : float
         Radius of acceptance ( Select next waypoint when within radius of acceptance )(default 0.0)
    lineOfSight : float
         Line of sight length (Determines the line from the vessel to the intersection of the line between the current waypoint and the next)(default 0.0)
    """

    def __init__(self , name="", description="", _id="", x=0.0, y=0.0, velocity=0.0, heading=0.0, turningRadius=0.0, radiusOfAcceptance=0.0, lineOfSight=0.0, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.x = x
        self.y = y
        self.velocity = velocity
        self.heading = heading
        self.turningRadius = turningRadius
        self.radiusOfAcceptance = radiusOfAcceptance
        self.lineOfSight = lineOfSight
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WaypointBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def x(self) -> float:
        """X-coordinate of waypoint"""
        return self.__x

    @x.setter
    def x(self, value: float):
        """Set x"""
        self.__x = float(value)

    @property
    def y(self) -> float:
        """Y-coordinate of waypoint"""
        return self.__y

    @y.setter
    def y(self, value: float):
        """Set y"""
        self.__y = float(value)

    @property
    def velocity(self) -> float:
        """Velocity towards next waypoint"""
        return self.__velocity

    @velocity.setter
    def velocity(self, value: float):
        """Set velocity"""
        self.__velocity = float(value)

    @property
    def heading(self) -> float:
        """Heading towards next waypoint (Only for fixed heading reference)"""
        return self.__heading

    @heading.setter
    def heading(self, value: float):
        """Set heading"""
        self.__heading = float(value)

    @property
    def turningRadius(self) -> float:
        """Turning radius of waypoint ( Maximum rate of turn = velocity/turning radius)"""
        return self.__turningRadius

    @turningRadius.setter
    def turningRadius(self, value: float):
        """Set turningRadius"""
        self.__turningRadius = float(value)

    @property
    def radiusOfAcceptance(self) -> float:
        """Radius of acceptance ( Select next waypoint when within radius of acceptance )"""
        return self.__radiusOfAcceptance

    @radiusOfAcceptance.setter
    def radiusOfAcceptance(self, value: float):
        """Set radiusOfAcceptance"""
        self.__radiusOfAcceptance = float(value)

    @property
    def lineOfSight(self) -> float:
        """Line of sight length (Determines the line from the vessel to the intersection of the line between the current waypoint and the next)"""
        return self.__lineOfSight

    @lineOfSight.setter
    def lineOfSight(self, value: float):
        """Set lineOfSight"""
        self.__lineOfSight = float(value)
