# This an autogenerated file
# 
# Generated with YawController
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.yawcontroller import YawControllerBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.windturbine.yawcontrollertype import YawControllerType

class YawController(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    yawControllerType : YawControllerType
    timeStep : float
         (default 0.0)
    setPoint : float
         Desired yaw misalignment(default 0.0)
    yawRate : float
         (default 0.0)
    errorThreshold : float
         Yaw misalignment integrated error threshold(default 0.0)
    fastLowPassFilterPeriod : float
         Filter period for yaw misalignment signal. Used for determining if 'error threshold' has been passed(default 0.0)
    slowLowPassFilterPeriod : float
         Filter period for yaw misalignment signal. Used to determine end time for yawing back to set point(default 0.0)
    """

    def __init__(self , name="", description="", _id="", yawControllerType=YawControllerType.NONE, timeStep=0.0, setPoint=0.0, yawRate=0.0, errorThreshold=0.0, fastLowPassFilterPeriod=0.0, slowLowPassFilterPeriod=0.0, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.yawControllerType = yawControllerType
        self.timeStep = timeStep
        self.setPoint = setPoint
        self.yawRate = yawRate
        self.errorThreshold = errorThreshold
        self.fastLowPassFilterPeriod = fastLowPassFilterPeriod
        self.slowLowPassFilterPeriod = slowLowPassFilterPeriod
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return YawControllerBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def yawControllerType(self) -> YawControllerType:
        """"""
        return self.__yawControllerType

    @yawControllerType.setter
    def yawControllerType(self, value: YawControllerType):
        """Set yawControllerType"""
        self.__yawControllerType = value

    @property
    def timeStep(self) -> float:
        """"""
        return self.__timeStep

    @timeStep.setter
    def timeStep(self, value: float):
        """Set timeStep"""
        self.__timeStep = float(value)

    @property
    def setPoint(self) -> float:
        """Desired yaw misalignment"""
        return self.__setPoint

    @setPoint.setter
    def setPoint(self, value: float):
        """Set setPoint"""
        self.__setPoint = float(value)

    @property
    def yawRate(self) -> float:
        """"""
        return self.__yawRate

    @yawRate.setter
    def yawRate(self, value: float):
        """Set yawRate"""
        self.__yawRate = float(value)

    @property
    def errorThreshold(self) -> float:
        """Yaw misalignment integrated error threshold"""
        return self.__errorThreshold

    @errorThreshold.setter
    def errorThreshold(self, value: float):
        """Set errorThreshold"""
        self.__errorThreshold = float(value)

    @property
    def fastLowPassFilterPeriod(self) -> float:
        """Filter period for yaw misalignment signal. Used for determining if 'error threshold' has been passed"""
        return self.__fastLowPassFilterPeriod

    @fastLowPassFilterPeriod.setter
    def fastLowPassFilterPeriod(self, value: float):
        """Set fastLowPassFilterPeriod"""
        self.__fastLowPassFilterPeriod = float(value)

    @property
    def slowLowPassFilterPeriod(self) -> float:
        """Filter period for yaw misalignment signal. Used to determine end time for yawing back to set point"""
        return self.__slowLowPassFilterPeriod

    @slowLowPassFilterPeriod.setter
    def slowLowPassFilterPeriod(self, value: float):
        """Set slowLowPassFilterPeriod"""
        self.__slowLowPassFilterPeriod = float(value)
