from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="fiducia-miner",
    version="0.1.0",
    author="Fiducia Team",
    author_email="info@fiducia.org",
    description="A mining client for Fiducia blockchain",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/fiducia-miner",
    packages=find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.6",
    install_requires=[
        "argparse",
    ],
    entry_points={
        "console_scripts": [
            "fiducia-miner=fiducia_miner.cli:main",
        ],
    },
) 