"""create initial tables

Revision ID: 6d5ae5b9c541
Revises: 
Create Date: 2025-05-07 19:10:39.137004

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '6d5ae5b9c541'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('log_flows',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('transaction_id', sa.UUID(), nullable=False),
    sa.Column('flow_name', sa.String(length=255), nullable=False),
    sa.Column('flow_author', sa.Enum('user', 'system', name='logflowauthor'), nullable=False),
    sa.Column('started_at', sa.DateTime(timezone=True), nullable=False),
    sa.Column('ended_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('status', sa.Enum('in_progress', 'success', 'failure', name='logstepstatus'), nullable=True),
    sa.Column('s3_key', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('transaction_id')
    )
    op.create_table('log_steps',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('flow_id', sa.UUID(), nullable=False),
    sa.Column('step_name', sa.String(length=255), nullable=False),
    sa.Column('status', sa.Enum('in_progress', 'success', 'failure', name='logstepstatus', native_enum=False), nullable=False),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('duration_ms', sa.Integer(), nullable=True),
    sa.Column('error_message', sa.String(), nullable=True),
    sa.Column('step_metadata', sa.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['flow_id'], ['log_flows.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('log_step_exceptions',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('step_id', sa.UUID(), nullable=False),
    sa.Column('type', sa.String(length=128), nullable=False),
    sa.Column('message', sa.String(), nullable=True),
    sa.Column('traceback', sa.String(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=False),
    sa.ForeignKeyConstraint(['step_id'], ['log_steps.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('log_step_exceptions')
    op.drop_table('log_steps')
    op.drop_table('log_flows')
    # ### end Alembic commands ###
