# UNC4841 Exploiting Barracuda ESG Zero-Day Vulnerability

## Summary

On May 23, 2023, Barracuda announced that a zero-day vulnerability (CVE-2023-2868) in the Barracuda Email Security Gateway (ESG) had been exploited in-the-wild as early as October 2022 and that they engaged Mandiant to assist in the investigation. Through the investigation, Mandiant identified a suspected China-nexus actor, currently tracked as UNC4841, targeting a subset of Barracuda ESG appliances to utilize as a vector for espionage, spanning a multitude of regions and sectors. Mandiant assesses with high confidence that UNC4841 is an espionage actor behind this wide-ranging campaign in support of the People’s Republic of China.

You can find more information on the threat in the following articles:

- [Barracuda ESG Zero-Day Vulnerability (CVE-2023-2868) Exploited Globally by Aggressive and Skilled Actor, Suspected Links to China](https://www.mandiant.com/resources/blog/barracuda-esg-exploited-globally)
- [Barracuda ESG: CVE-2023-2868 Hardening Recommendations](https://mandiant.widen.net/s/qwlxddwdg6/barracuda-cve-2023-2868-hardening)

## Rules

- [UNC4841 - Email Exfiltration File Pattern](./file_event_lnx_apt_unc4841_exfil_mail_pattern.yml)
- [UNC4841 - Barracuda ESG Exploitation Indicators](./file_event_lnx_apt_unc4841_file_indicators.yml)
- [UNC4841 - SSL Certificate Exfiltration Via Openssl](./proc_creation_lnx_apt_unc4841_openssl_connection.yml)
- [UNC4841 - Download Compressed Files From Temp.sh Using Wget](./proc_creation_lnx_apt_unc4841_wget_download_compressed_file_tmep_sh.yml)
- [UNC4841 - Download Tar File From Untrusted Direct IP Via Wget](./proc_creation_lnx_apt_unc4841_wget_download_tar_files_direct_ip.yml)
- [UNC4841 - Potential SEASPY Execution](./proc_creation_lnx_atp_unc4841_seaspy_execution.yml)

> **Note**
>
> The detection and hunting rules provided for this threat might produce false positives when used outside of the context of incident response or compromise assessment. They are meant to be run and executed on affected systems and environments to look for signs of compromise.
