# Acknowledgments

Oumi makes use of several libraries and tools from the open-source community. 🚀

We would like to acknowledge these projects:

| Project | Usage in Oumi |
|-------------------|---------------|
| [Accelerate](https://github.com/huggingface/accelerate) | Distributed training and mixed precision computations |
| [bitsandbytes](https://github.com/bitsandbytes-foundation/bitsandbytes) | Quantization and efficient optimizers for QLora |
| [Datasets](https://github.com/huggingface/datasets) | Dataset loading and processing |
| [jsonlines](https://github.com/wbolster/jsonlines) | JSON Lines data format handling |
| [LLama.cpp](https://github.com/ggerganov/llama.cpp) | Efficient inference capabilities for quantized models |
| [LM Evaluation Harness](https://github.com/EleutherAI/lm-evaluation-harness) | Comprehensive suite for evaluating language models |
| [NumPy](https://github.com/numpy/numpy) | Numerical operations and data manipulation |
| [OmegaConf](https://github.com/omry/omegaconf) | Configuration system for managing model and training parameters |
| [Pandas](https://github.com/pandas-dev/pandas) | Data manipulation and analysis |
| [Peft](https://github.com/huggingface/peft) | Parameter-efficient fine-tuning techniques |
| [Pydantic](https://github.com/pydantic/pydantic) | Ensures type checking and validation for configuration objects |
| [PyTorch](https://github.com/pytorch/pytorch) | Primary deep learning framework for model training and inference |
| [SkyPilot](https://github.com/skypilot-org/skypilot) | Cloud-agnostic deployment and management of training jobs |
| [TensorBoard](https://github.com/tensorflow/tensorboard) | Training visualization and monitoring |
| [Tqdm](https://github.com/tqdm/tqdm) | Progress bars to enhance user experience during long-running operations |
| [Transformers](https://github.com/huggingface/transformers) | Core model architectures and utilities for working with transformer-based models |
| [TRL](https://github.com/huggingface/trl) | SFT, DPO, and GRPO training implementations |
| [Typer](https://github.com/tiangolo/typer) | Command-line interface for Oumi commands |
| [verl](https://github.com/volcengine/verl) | GRPO training implementation |
| [vllm](https://github.com/vllm-project/vllm) | Fast inference for large language models |
| [Weights & Biases](https://github.com/wandb/wandb) | Experiment tracking and visualization |

We are grateful to the developers and maintainers of these projects for their valuable contributions to the open-source community. 🙏
