# Updating the Documentation

## Suggesting Edits Using the UI

You need to submit PRs to update documentation. The easiest way to modify an existing page is to use the "Suggest Edit" UI:

1. Navigate to the page you'd like to edit in the [documentation website](https://oumi.ai/docs/en/latest/),
2. Click on the Github icon in the top right
3. Click on the "Suggest Edit" button, and make your changes.

To add a new page, you can add a new Markdown file in our Oumi GitHub repo. For example, the quickstart guide is located [here](https://github.com/oumi-ai/oumi/blame/main/docs/get_started/quickstart.md).

Note that [Sphinx](https://www.sphinx-doc.org/en/master/) & [MyST](https://myst-parser.readthedocs.io/en/latest/) have special syntax on top of regular Markdown syntax. A quick guide for Sphinx documentation can be found [here](https://myst-parser.readthedocs.io/en/latest/syntax/typography.html). You can also reference existing docs pages to learn.

## Test Changes Locally

Building the oumi docs locally is simple, and is a great way to verify your change (or test recently pulled changes) before pushing our docs to production.

**‼️ Important ‼️**
Don’t forget to activate your oumi conda environment first!

```bash
conda activate oumi
```

### First Time Setup

The following instructions only need to be done ONCE:

Before building our docs, you need to clone our [local fork of sphinx-term](https://github.com/oumi-ai/sphinx-term) and install it in the same Conda env you use for Oumi development:

```bash
git clone https://github.com/oumi-ai/sphinx-term.git
cd sphinx-term
git submodule update --init --recursive
pip install -e .
```

If you haven’t already installed our “\[docs\]” package for Oumi, make sure you do that as well.

```bash
# Switch to your oumi directory, wherever that may be
cd oumi
pip install -U -e ".[docs]"
```

The first time you run the docs locally, you need to run the following command to build the docs:

```bash
make docs-rebuild
```

### Serve Docs Locally

Now you’re ready to build the docs\! You can run one simple command to build the latest docs and open them in chrome. For reference, the local docs URL localhost:8000/get\_started/quickstart.html would correspond to [https://oumi.ai/docs/en/latest/get\_started/quickstart.html](https://oumi.ai/docs/en/latest/get_started/quickstart.html).

```bash
# Switch to your oumi directory, wherever that may be, then run
make docs-serve

# To cancel: ctrl+c
```

### \[Optional\] Fix for Missing Pages

If a few autogenerated pages (ex. [trainingConfig docs](https://oumi.ai/docs/en/latest/api/oumi.core.configs.html#oumi.core.configs.TrainingConfig)) are missing, run the following command to refresh all pages:

```bash
# Switch to your oumi directory, wherever that may be, then run
make docs-rebuild
```
